/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.md;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import org.aya.pretty.backend.html.Html5Stylist;
import org.aya.pretty.backend.md.MdStyle;
import org.aya.pretty.backend.string.ClosingStylist;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.doc.Style;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.StyleFamily;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleFamily;
import org.jetbrains.annotations.NotNull;

public class MdStylist
extends Html5Stylist {
    @NotNull
    public static final MdStylist DEFAULT = new MdStylist(AyaColorScheme.EMACS, AyaStyleFamily.DEFAULT);

    public MdStylist(@NotNull ColorScheme colorScheme, @NotNull StyleFamily styleFamily) {
        super(colorScheme, styleFamily);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatItalic(EnumSet<StringPrinter.Outer> outer) {
        return outer.isEmpty() ? new ClosingStylist.StyleToken("_", "_", false) : super.formatItalic(outer);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatBold(EnumSet<StringPrinter.Outer> outer) {
        return outer.isEmpty() ? new ClosingStylist.StyleToken("**", "**", false) : super.formatBold(outer);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatLineThrough( @NotNull Style.LineThrough line, EnumSet<StringPrinter.Outer> outer) {
        return outer.isEmpty() && line.position() == Style.LineThrough.Position.Strike ? new ClosingStylist.StyleToken("~~", "~~", false) : super.formatLineThrough(line, outer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatCustom( @NotNull Style.CustomStyle style) {
        ClosingStylist.StyleToken styleToken;
        MdStyle md;
        if (!(style instanceof MdStyle)) return super.formatCustom(style);
        MdStyle mdStyle = md = (MdStyle)style;
        Objects.requireNonNull(mdStyle);
        MdStyle mdStyle2 = mdStyle;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MdStyle.GFM.class, MdStyle.Heading.class}, (Object)mdStyle2, n)) {
            default: {
                throw new RuntimeException(null, null);
            }
            case 0: {
                MdStyle.GFM gfm = (MdStyle.GFM)mdStyle2;
                switch (gfm) {
                    default: {
                        throw new RuntimeException(null, null);
                    }
                    case BlockQuote: {
                        styleToken = new ClosingStylist.StyleToken(c -> c.invisibleContent("> "), c -> c.lineBreakWith("\n\n"));
                        return styleToken;
                    }
                    case Paragraph: {
                        styleToken = new ClosingStylist.StyleToken(c -> {}, c -> c.lineBreakWith("\n\n"));
                        return styleToken;
                    }
                    case ThematicBreak: 
                }
                styleToken = new ClosingStylist.StyleToken(c -> c.invisibleContent("---"), c -> c.lineBreakWith("\n\n"));
                return styleToken;
            }
            case 1: 
        }
        MdStyle.Heading heading = (MdStyle.Heading)mdStyle2;
        try {
            int n2;
            int level = n2 = heading.level();
            styleToken = new ClosingStylist.StyleToken(c -> {
                c.invisibleContent("#".repeat(level));
                c.invisibleContent(" ");
            }, c -> c.lineBreakWith("\n"));
            return styleToken;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }
}

