/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.latex;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.pretty.backend.string.ClosingStylist;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.doc.Style;
import org.aya.pretty.doc.Styles;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.StyleFamily;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleFamily;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeXStylist
extends ClosingStylist {
    @NotNull
    public static final TeXStylist DEFAULT = new TeXStylist(AyaColorScheme.INTELLIJ, AyaStyleFamily.DEFAULT, false);
    @NotNull
    public static final TeXStylist DEFAULT_KATEX = new TeXStylist(AyaColorScheme.INTELLIJ, AyaStyleFamily.DEFAULT, true);
    public final boolean isKaTeX;

    public TeXStylist(@NotNull ColorScheme colorScheme, @NotNull StyleFamily styleFamily, boolean isKaTeX) {
        super(colorScheme, styleFamily);
        this.isKaTeX = isKaTeX;
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatItalic(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("\\textit{", "}", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatBold(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("\\textbf{", "}", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatLineThrough(@NotNull Style.LineThrough line, EnumSet<StringPrinter.Outer> outer) {
        return switch (line.position()) {
            default -> throw new RuntimeException(null, null);
            case Style.LineThrough.Position.Underline -> new ClosingStylist.StyleToken("\\underline{", "}", false);
            case Style.LineThrough.Position.Strike -> new ClosingStylist.StyleToken("\\sout{", "}", false);
            case Style.LineThrough.Position.Overline -> ClosingStylist.StyleToken.NULL;
        };
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatColorHex(int rgb, boolean background) {
        String cmd = "\\%s%s{%06x}{".formatted(background ? "colorbox" : "textcolor", this.isKaTeX ? "" : "[HTML]", rgb);
        return new ClosingStylist.StyleToken(cmd, "}", false);
    }

    @NotNull
    public static String styleKeyToTex(@NotNull String styleName) {
        return TeXStylist.normalizeTexId(styleName);
    }

    @NotNull
    public static String normalizeTexId(@NotNull String id) {
        return id.replace("::", "");
    }

    @NotNull
    public static String stylesToTexCmd(@NotNull Styles styles, @NotNull String arg) {
        return (String)styles.styles().view().mapNotNull(TeXStylist::styleToTex).foldLeft((Object)arg, (acc, t) -> (String)t.component1() + acc + (String)t.component2());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Tuple2<String, String> styleToTex(@NotNull Style style) {
        Style style2 = style;
        Objects.requireNonNull(style2);
        Style style3 = style2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Style.Attr.class, Style.LineThrough.class, Style.ColorHex.class, Style.ColorName.class}, (Object)style3, n)) {
            case 0: {
                Tuple2 tuple2;
                Style.Attr attr = (Style.Attr)style3;
                switch (attr) {
                    default: {
                        throw new RuntimeException(null, null);
                    }
                    case Italic: {
                        tuple2 = Tuple.of((Object)"\\textit{", (Object)"}");
                        return tuple2;
                    }
                    case Bold: 
                }
                tuple2 = Tuple.of((Object)"\\textbf{", (Object)"}");
                return tuple2;
            }
            case 1: {
                Style.LineThrough.Position pos;
                Tuple2 tuple2;
                Style.LineThrough lineThrough = (Style.LineThrough)style3;
                try {
                    Object object = lineThrough.position();
                    pos = object;
                    object = lineThrough.shape();
                    object = lineThrough.color();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable.toString(), throwable);
                }
                switch (pos) {
                    default: {
                        throw new RuntimeException(null, null);
                    }
                    case Strike: {
                        tuple2 = Tuple.of((Object)"\\sout{", (Object)"}");
                        return tuple2;
                    }
                    case Underline: {
                        tuple2 = Tuple.of((Object)"\\underline{", (Object)"}");
                        return tuple2;
                    }
                    case Overline: 
                }
                return null;
            }
            case 2: {
                int background;
                int rgb;
                Style.ColorHex colorHex = (Style.ColorHex)style3;
                {
                    int n2;
                    rgb = n2 = colorHex.color();
                    background = n2 = (int)(colorHex.background() ? 1 : 0);
                }
                Tuple2 tuple2 = Tuple.of((Object)"\\%s[HTML]{%06x}{".formatted(background != 0 ? "colorbox" : "textcolor", rgb), (Object)"}");
                return tuple2;
            }
            case 3: {
                boolean background;
                String name;
                Style.ColorName colorName = (Style.ColorName)style3;
                {
                    boolean bl;
                    String string;
                    name = string = colorName.colorName();
                    background = bl = colorName.background();
                }
                Tuple2 tuple2 = Tuple.of((Object)"\\%s{%s}{".formatted(background ? "colorbox" : "textcolor", TeXStylist.normalizeTexId(name)), (Object)"}");
                return tuple2;
            }
        }
        return null;
    }

    @NotNull
    public static String colorsToTex(@NotNull ColorScheme colorScheme) {
        return colorScheme.definedColors().toImmutableSeq().view().map(t -> "\\definecolor{%s}{HTML}{%06x}".formatted(TeXStylist.normalizeTexId((String)t.component1()), t.component2())).joinToString((CharSequence)"\n");
    }

    public static class ClassedPreset
    extends ClosingStylist.Delegate {
        public ClassedPreset(@NotNull ClosingStylist delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        protected ImmutableSeq<ClosingStylist.StyleToken> formatPresetStyle(@NotNull String styleName, EnumSet<StringPrinter.Outer> outer) {
            String commandName = TeXStylist.styleKeyToTex(styleName);
            return ImmutableSeq.of((Object)new ClosingStylist.StyleToken("\\%s{".formatted(commandName), "}", false));
        }
    }
}

