/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.latex;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.pretty.backend.string.ClosingStylist;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.doc.Style;
import org.aya.pretty.doc.Styles;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.StyleFamily;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleFamily;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeXStylist
extends ClosingStylist {
    @NotNull
    public static final TeXStylist DEFAULT = new TeXStylist(AyaColorScheme.INTELLIJ, AyaStyleFamily.DEFAULT, false);
    @NotNull
    public static final TeXStylist DEFAULT_KATEX = new TeXStylist(AyaColorScheme.INTELLIJ, AyaStyleFamily.DEFAULT, true);
    public final boolean isKaTeX;

    public TeXStylist(@NotNull ColorScheme colorScheme, @NotNull StyleFamily styleFamily, boolean isKaTeX) {
        super(colorScheme, styleFamily);
        this.isKaTeX = isKaTeX;
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatItalic(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("\\textit{", "}", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatBold(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("\\textbf{", "}", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatLineThrough(@NotNull Style.LineThrough line, EnumSet<StringPrinter.Outer> outer) {
        return switch (line.position()) {
            default -> throw new IncompatibleClassChangeError();
            case Style.LineThrough.Position.Underline -> new ClosingStylist.StyleToken("\\underline{", "}", false);
            case Style.LineThrough.Position.Strike -> new ClosingStylist.StyleToken("\\sout{", "}", false);
            case Style.LineThrough.Position.Overline -> ClosingStylist.StyleToken.NULL;
        };
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatColorHex(int rgb, boolean background) {
        String cmd = "\\%s%s{%06x}{".formatted(background ? "colorbox" : "textcolor", this.isKaTeX ? "" : "[HTML]", rgb);
        return new ClosingStylist.StyleToken(cmd, "}", false);
    }

    @NotNull
    public static String styleKeyToTex(@NotNull String styleName) {
        return TeXStylist.normalizeTexId(styleName);
    }

    @NotNull
    public static String normalizeTexId(@NotNull String id) {
        return id.replace("::", "");
    }

    @NotNull
    public static String stylesToTexCmd(@NotNull Styles styles, @NotNull String arg) {
        return (String)styles.styles().view().mapNotNull(TeXStylist::styleToTex).foldLeft((Object)arg, (acc, t) -> (String)t.component1() + acc + (String)t.component2());
    }

    @Nullable
    public static Tuple2<String, String> styleToTex(@NotNull Style style) {
        Style style2 = style;
        Objects.requireNonNull(style2);
        Style style3 = style2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Style.Attr.class, Style.LineThrough.class, Style.ColorHex.class, Style.ColorName.class}, (Object)style3, n)) {
            case 0 -> {
                Style.Attr attr = (Style.Attr)style3;
                switch (attr) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Italic: {
                        yield Tuple.of((Object)"\\textit{", (Object)"}");
                    }
                    case Bold: 
                }
                yield Tuple.of((Object)"\\textbf{", (Object)"}");
            }
            case 1 -> {
                Object var7_4 = TeXStylist.$proxy$position((Style.LineThrough)style3);
                Style.LineThrough.Position pos = var7_4;
                var7_4 = TeXStylist.$proxy$shape((Style.LineThrough)style3);
                Enum $ = var7_4;
                Object $$ = var7_4 = TeXStylist.$proxy$color((Style.LineThrough)style3);
                switch (pos) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Strike: {
                        yield Tuple.of((Object)"\\sout{", (Object)"}");
                    }
                    case Underline: {
                        yield Tuple.of((Object)"\\underline{", (Object)"}");
                    }
                    case Overline: 
                }
                yield null;
            }
            case 2 -> {
                int var9_9 = TeXStylist.$proxy$color((Style.ColorHex)style3);
                int rgb = var9_9;
                boolean var9_10 = TeXStylist.$proxy$background((Style.ColorHex)style3);
                boolean background = var9_10;
                yield Tuple.of((Object)"\\%s[HTML]{%06x}{".formatted(background ? "colorbox" : "textcolor", rgb), (Object)"}");
            }
            case 3 -> {
                String var11_13;
                String var9_11 = var11_13 = TeXStylist.$proxy$colorName((Style.ColorName)style3);
                boolean var11_14 = TeXStylist.$proxy$background((Style.ColorName)style3);
                boolean background = var11_14;
                yield Tuple.of((Object)"\\%s{%s}{".formatted(background ? "colorbox" : "textcolor", TeXStylist.normalizeTexId(var9_11)), (Object)"}");
            }
            default -> null;
        };
    }

    @NotNull
    public static String colorsToTex(@NotNull ColorScheme colorScheme) {
        return colorScheme.definedColors().toImmutableSeq().view().map(t -> "\\definecolor{%s}{HTML}{%06x}".formatted(TeXStylist.normalizeTexId((String)t.component1()), t.component2())).joinToString((CharSequence)"\n");
    }

    private static /* synthetic */ Style.LineThrough.Position $proxy$position(Style.LineThrough arg0) {
        try {
            return arg0.position();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Style.LineThrough.Shape $proxy$shape(Style.LineThrough arg0) {
        try {
            return arg0.shape();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ Style.Color $proxy$color(Style.LineThrough arg0) {
        try {
            return arg0.color();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ int $proxy$color(Style.ColorHex arg0) {
        try {
            return arg0.color();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ boolean $proxy$background(Style.ColorHex arg0) {
        try {
            return arg0.background();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ String $proxy$colorName(Style.ColorName arg0) {
        try {
            return arg0.colorName();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ boolean $proxy$background(Style.ColorName arg0) {
        try {
            return arg0.background();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString(), throwable);
        }
    }

    public static class ClassedPreset
    extends ClosingStylist.Delegate {
        public ClassedPreset(@NotNull ClosingStylist delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        protected ImmutableSeq<ClosingStylist.StyleToken> formatPresetStyle(@NotNull String styleName, EnumSet<StringPrinter.Outer> outer) {
            String commandName = TeXStylist.styleKeyToTex(styleName);
            return ImmutableSeq.of((Object)new ClosingStylist.StyleToken("\\%s{".formatted(commandName), "}", false));
        }
    }
}

