/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.string;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;
import kala.collection.Seq;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.backend.string.StringStylist;
import org.aya.pretty.doc.Style;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.StyleFamily;
import org.jetbrains.annotations.NotNull;

public abstract class ClosingStylist
extends StringStylist {
    public ClosingStylist(@NotNull ColorScheme colorScheme, @NotNull StyleFamily styleFamily) {
        super(colorScheme, styleFamily);
    }

    @Override
    public void format(@NotNull Seq<Style> styles, @NotNull Cursor cursor, EnumSet<StringPrinter.Outer> outer, @NotNull Runnable inside) {
        this.formatInternal((SeqView<Style>)styles.view(), cursor, outer, inside);
    }

    private void formatInternal(@NotNull SeqView<Style> styles, @NotNull Cursor cursor, EnumSet<StringPrinter.Outer> outer, @NotNull Runnable inside) {
        ImmutableSeq<StyleToken> immutableSeq;
        if (styles.isEmpty()) {
            inside.run();
            return;
        }
        Style style = (Style)styles.getFirst();
        if (style instanceof Style.Preset) {
            Style.Preset preset = (Style.Preset)style;
            immutableSeq = this.formatPresetStyle(preset.styleName(), outer);
        } else {
            immutableSeq = ImmutableSeq.of((Object)this.formatOne(style, outer));
        }
        ImmutableSeq<StyleToken> formats = immutableSeq;
        formats.forEach(format -> format.start.accept(cursor));
        this.formatInternal((SeqView<Style>)styles.drop(1), cursor, outer, inside);
        formats.reversed().forEach(format -> format.end.accept(cursor));
    }

    @NotNull
    private StyleToken formatOne(@NotNull Style style, EnumSet<StringPrinter.Outer> outer) {
        Style style2 = style;
        Objects.requireNonNull(style2);
        Style style3 = style2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Style.Attr.class, Style.LineThrough.class, Style.ColorName.class, Style.ColorHex.class, Style.CustomStyle.class}, (Object)style3, n)) {
            case 0 -> {
                Style.Attr attr = (Style.Attr)style3;
                switch (attr) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case Italic: {
                        yield this.formatItalic(outer);
                    }
                    case Bold: 
                }
                yield this.formatBold(outer);
            }
            case 1 -> {
                Style.LineThrough line = (Style.LineThrough)style3;
                yield this.formatLineThrough(line, outer);
            }
            case 2 -> {
                Style.ColorName color = (Style.ColorName)style3;
                yield this.formatPresetColor(color.colorName(), color.background());
            }
            case 3 -> {
                Style.ColorHex hex = (Style.ColorHex)style3;
                yield this.formatColorHex(hex.color(), hex.background());
            }
            case 4 -> {
                Style.CustomStyle custom = (Style.CustomStyle)style3;
                yield this.formatCustom(custom);
            }
            default -> StyleToken.NULL;
        };
    }

    @NotNull
    protected ImmutableSeq<StyleToken> formatPresetStyle(@NotNull String styleName, EnumSet<StringPrinter.Outer> outer) {
        return (ImmutableSeq)this.styleFamily.definedStyles().getOption((Object)styleName).getOrDefault(it -> it.styles().map(sub -> this.formatOne((Style)sub, outer)), (Object)ImmutableSeq.empty());
    }

    @NotNull
    protected StyleToken formatPresetColor(@NotNull String colorName, boolean background) {
        return (StyleToken)this.colorScheme.definedColors().getOption((Object)colorName).getOrDefault(it -> this.formatColorHex((int)it, background), (Object)StyleToken.NULL);
    }

    @NotNull
    protected StyleToken formatCustom(@NotNull Style.CustomStyle style) {
        return StyleToken.NULL;
    }

    @NotNull
    protected abstract StyleToken formatItalic(EnumSet<StringPrinter.Outer> var1);

    @NotNull
    protected abstract StyleToken formatBold(EnumSet<StringPrinter.Outer> var1);

    @NotNull
    protected abstract StyleToken formatLineThrough(@NotNull Style.LineThrough var1, EnumSet<StringPrinter.Outer> var2);

    @NotNull
    protected abstract StyleToken formatColorHex(int var1, boolean var2);

    public record StyleToken(@NotNull Consumer<Cursor> start, @NotNull Consumer<Cursor> end) {
        @NotNull
        public static final StyleToken NULL = new StyleToken(c -> {}, c -> {});

        public StyleToken(@NotNull String start, @NotNull String end, boolean visible) {
            this(c -> c.content(start, visible), c -> c.content(end, visible));
        }
    }

    public static class Delegate
    extends ClosingStylist {
        @NotNull
        protected final ClosingStylist delegate;

        public Delegate(@NotNull ClosingStylist delegate) {
            super(delegate.colorScheme, delegate.styleFamily);
            this.delegate = delegate;
        }

        @Override
        @NotNull
        protected StyleToken formatCustom(@NotNull Style.CustomStyle style) {
            return this.delegate.formatCustom(style);
        }

        @Override
        @NotNull
        protected ImmutableSeq<StyleToken> formatPresetStyle(@NotNull String styleName, EnumSet<StringPrinter.Outer> outer) {
            return this.delegate.formatPresetStyle(styleName, outer);
        }

        @Override
        @NotNull
        protected StyleToken formatPresetColor(@NotNull String colorName, boolean background) {
            return this.delegate.formatPresetColor(colorName, background);
        }

        @Override
        @NotNull
        protected StyleToken formatItalic(EnumSet<StringPrinter.Outer> outer) {
            return this.delegate.formatItalic(outer);
        }

        @Override
        @NotNull
        protected StyleToken formatBold(EnumSet<StringPrinter.Outer> outer) {
            return this.delegate.formatBold(outer);
        }

        @Override
        @NotNull
        protected StyleToken formatLineThrough(@NotNull Style.LineThrough line, EnumSet<StringPrinter.Outer> outer) {
            return this.delegate.formatLineThrough(line, outer);
        }

        @Override
        @NotNull
        protected StyleToken formatColorHex(int rgb, boolean background) {
            return this.delegate.formatColorHex(rgb, background);
        }
    }
}

