/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.doc;

import java.io.Serializable;
import kala.collection.mutable.MutableList;
import org.aya.pretty.doc.Styles;
import org.aya.pretty.printer.ColorScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Style
extends Serializable {
    default public Styles and() {
        return new Styles((MutableList<Style>)MutableList.of((Object)this));
    }

    @NotNull
    public static Style italic() {
        return Attr.Italic;
    }

    @NotNull
    public static Style bold() {
        return Attr.Bold;
    }

    @NotNull
    public static Style strike() {
        return new LineThrough(LineThrough.Position.Strike, LineThrough.Shape.Solid, null);
    }

    @NotNull
    public static Style underline() {
        return new LineThrough(LineThrough.Position.Underline, LineThrough.Shape.Solid, null);
    }

    @NotNull
    public static Color color(@NotNull String colorName) {
        return new ColorName(colorName, false);
    }

    @NotNull
    public static Color colorBg(@NotNull String colorName) {
        return new ColorName(colorName, true);
    }

    @NotNull
    public static Color color(int color) {
        return new ColorHex(color, false);
    }

    @NotNull
    public static Color color(float r, float g, float b) {
        return new ColorHex(ColorScheme.colorOf(r, g, b), false);
    }

    @NotNull
    public static Color colorBg(int color) {
        return new ColorHex(color, true);
    }

    @NotNull
    public static Style preset(@NotNull String styleName) {
        return new Preset(styleName);
    }

    public static enum Attr implements Style
    {
        Italic,
        Bold;

    }

    public record LineThrough(@NotNull Position position, @NotNull Shape shape, @Nullable Color color) implements Style
    {

        public static enum Position {
            Underline,
            Overline,
            Strike;

        }

        public static enum Shape {
            Solid,
            Curly;

        }
    }

    public static sealed interface Color
    extends Style
    permits ColorName, ColorHex {
    }

    public record ColorName(@NotNull String colorName, boolean background) implements Color
    {
    }

    public record ColorHex(int color, boolean background) implements Color
    {
    }

    public record Preset(@NotNull String styleName) implements Style
    {
    }

    public static non-sealed interface CustomStyle
    extends Style {
    }
}

