/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.printer;

import kala.collection.mutable.MutableMap;
import org.aya.pretty.printer.Stylist;
import org.jetbrains.annotations.NotNull;

public interface PrinterConfig {
    public static final int INFINITE_SIZE = -1;

    default public int getPageWidth() {
        return -1;
    }

    default public int getPageHeight() {
        return -1;
    }

    @NotNull
    public Stylist getStylist();

    public static class Basic<S extends Stylist>
    implements PrinterConfig {
        @NotNull
        protected final MutableMap<Options<?>, Object> options = MutableMap.create();
        @NotNull
        private final S stylist;

        public Basic(@NotNull S stylist) {
            this.stylist = stylist;
        }

        @NotNull
        public <T> T opt(@NotNull Options<T> key, @NotNull T defaultValue) {
            return (T)this.options.getOrDefault(key, defaultValue);
        }

        public <T> void set(@NotNull Options<T> key, @NotNull T value) {
            this.options.put(key, value);
        }

        @NotNull
        public S getStylist() {
            return this.stylist;
        }

        @Override
        public int getPageWidth() {
            return this.opt(PageOptions.PageWidth, -1);
        }

        @Override
        public int getPageHeight() {
            return this.opt(PageOptions.PageHeight, -1);
        }
    }

    public static enum PageOptions implements Options<Integer>
    {
        PageWidth,
        PageHeight;

    }

    public static interface Options<T> {
    }
}

