/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.html;

import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Objects;
import java.util.regex.Pattern;
import kala.collection.immutable.ImmutableMap;
import kala.collection.immutable.ImmutableSeq;
import kala.control.Either;
import org.aya.pretty.backend.html.Html5Stylist;
import org.aya.pretty.backend.html.HtmlConstants;
import org.aya.pretty.backend.string.ClosingStylist;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.backend.string.StringStylist;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Link;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class DocHtmlPrinter<Config extends Config>
extends StringPrinter<Config> {
    @Language(value="HTML")
    @NotNull
    String HEAD = "<!DOCTYPE html><html lang=\"en\"><head>\n<title>Aya file</title>\n<meta charset=\"UTF-8\" />\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />\n" + HtmlConstants.HOVER_STYLE + HtmlConstants.HOVER_TYPE_POPUP_STYLE;
    @NotNull
    public static final Pattern entityPattern = Pattern.compile("[&<>\"\\\\]");
    @NotNull
    public static final ImmutableMap<String, String> entityMapping = ImmutableMap.of((Object)"&", (Object)"&amp;", (Object)"<", (Object)"&lt;", (Object)">", (Object)"&gt;", (Object)"\\", (Object)"&bsol;", (Object)"\"", (Object)"&quot;");

    @Override
    protected void renderHeader(@NotNull Cursor cursor) {
        if (((Config)this.config).opt(StringPrinterConfig.StyleOptions.HeaderCode, false).booleanValue()) {
            cursor.invisibleContent(this.HEAD);
            this.renderCssStyle(cursor);
            if (((Config)this.config).opt(StringPrinterConfig.StyleOptions.ServerSideRendering, false).booleanValue()) {
                cursor.invisibleContent(HtmlConstants.HOVER_SSR);
            } else {
                cursor.invisibleContent(HtmlConstants.HOVER);
                cursor.invisibleContent(HtmlConstants.KATEX_AUTO_RENDER);
            }
            cursor.invisibleContent("</head><body>\n");
        }
    }

    @Override
    protected void renderFooter(@NotNull Cursor cursor) {
        if (((Config)this.config).opt(StringPrinterConfig.StyleOptions.HeaderCode, false).booleanValue()) {
            cursor.invisibleContent("\n</body></html>\n");
        }
    }

    protected void renderCssStyle(@NotNull Cursor cursor) {
        if (!((Config)this.config).opt(StringPrinterConfig.StyleOptions.SeparateStyle, false).booleanValue()) {
            return;
        }
        if (!((Config)this.config).opt(StringPrinterConfig.StyleOptions.StyleCode, false).booleanValue()) {
            return;
        }
        cursor.invisibleContent("<style>");
        String colors = Html5Stylist.colorsToCss(((Html5Stylist)((Config)this.config).getStylist()).colorScheme);
        cursor.invisibleContent("\n:root {\n%s\n}\n".formatted(colors));
        ((Html5Stylist)((Config)this.config).getStylist()).styleFamily.definedStyles().forEach((name, style) -> {
            String selector = Html5Stylist.styleKeyToCss(name).map(x -> "." + x).joinToString((CharSequence)" ");
            String css = style.styles().mapNotNull(Html5Stylist::styleToCss).joinToString((CharSequence)"\n", arg_0 -> DocHtmlPrinter.lambda$renderCssStyle$1("  %s", arg_0));
            String stylesheet = "%s {\n%s\n}\n".formatted(selector, css);
            cursor.invisibleContent(stylesheet);
        });
        cursor.invisibleContent("</style>\n");
    }

    @Override
    @NotNull
    protected StringStylist prepareStylist() {
        return ((Config)this.config).opt(StringPrinterConfig.StyleOptions.SeparateStyle, false) != false ? new Html5Stylist.ClassedPreset((ClosingStylist)((Config)this.config).getStylist()) : super.prepareStylist();
    }

    @Override
    @NotNull
    protected String escapePlainText(@NotNull String content, EnumSet<StringPrinter.Outer> outer) {
        if (outer.contains((Object)StringPrinter.Outer.Math)) {
            return content;
        }
        return entityPattern.matcher(content).replaceAll(result -> (String)entityMapping.get((Object)result.group()));
    }

    @Override
    protected void renderTooltip(@NotNull Cursor cursor, @NotNull Doc.Tooltip tooltip, EnumSet<StringPrinter.Outer> outer) {
        Cursor newCursor = new Cursor(this);
        this.renderDoc(newCursor, tooltip.tooltip().toDoc(), FREE);
        String tip = newCursor.result().toString();
        cursor.invisibleContent("<span class=\"aya-tooltip\" ");
        cursor.invisibleContent("data-tooltip-text=\"");
        cursor.invisibleContent(Base64.getEncoder().encodeToString(tip.getBytes(StandardCharsets.UTF_8)));
        cursor.invisibleContent("\">");
        this.renderDoc(cursor, tooltip.doc(), EnumSet.of(StringPrinter.Outer.EnclosingTag));
        cursor.invisibleContent("</span>");
    }

    @Override
    protected void renderHyperLinked(@NotNull Cursor cursor, @NotNull Doc.HyperLinked text, EnumSet<StringPrinter.Outer> outer) {
        Link href = text.href();
        cursor.invisibleContent("<a ");
        if (text.id() != null) {
            cursor.invisibleContent("id=\"" + this.normalizeId(text.id()) + "\" ");
        }
        if (text.hover() != null) {
            cursor.invisibleContent("class=\"aya-hover\" ");
            cursor.invisibleContent("aya-hover-text=\"" + text.hover() + "\" ");
        }
        cursor.invisibleContent("href=\"");
        cursor.invisibleContent(this.normalizeHref(href));
        cursor.invisibleContent("\">");
        this.renderDoc(cursor, text.doc(), EnumSet.of(StringPrinter.Outer.EnclosingTag));
        cursor.invisibleContent("</a>");
    }

    @Override
    protected void renderImage(@NotNull Cursor cursor, @NotNull Doc.Image image, EnumSet<StringPrinter.Outer> outer) {
        cursor.invisibleContent("<img ");
        cursor.invisibleContent("src=\"" + this.normalizeHref(image.src()) + "\" ");
        cursor.invisibleContent("alt=\"");
        this.renderDoc(cursor, image.alt(), outer);
        cursor.invisibleContent("\"/>");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String normalizeId(@NotNull Link linkId) {
        Either<String, Integer> id;
        Object object;
        Link link = linkId;
        Objects.requireNonNull(link);
        Link link2 = link;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Link.CrossLink.class, Link.DirectLink.class, Link.LocalId.class}, (Object)link2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object loc;
                ImmutableSeq<String> path;
                Link.CrossLink crossLink = (Link.CrossLink)link2;
                try {
                    Object object2;
                    path = object2 = crossLink.path();
                    loc = object2 = crossLink.location();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (path.isEmpty()) {
                    if (loc == null) {
                        return "";
                    }
                    object = this.normalizeId((Link)loc);
                    return object;
                }
                String prefix = ((Config)this.config).opt(StringPrinterConfig.LinkOptions.CrossLinkPrefix, "/");
                String postfix = ((Config)this.config).opt(StringPrinterConfig.LinkOptions.CrossLinkPostfix, ".html");
                String sep = ((Config)this.config).opt(StringPrinterConfig.LinkOptions.CrossLinkSeparator, "/");
                object = path.joinToString((CharSequence)sep, (CharSequence)prefix, (CharSequence)postfix) + (String)(loc == null ? "" : "#" + this.normalizeId((Link)loc));
                return object;
            }
            case 1: {
                Link.DirectLink directLink = (Link.DirectLink)link2;
                {
                    String string;
                    String link3 = string = directLink.link();
                    object = link3;
                    return object;
                }
            }
            case 2: 
        }
        Link.LocalId localId = (Link.LocalId)link2;
        {
            Either<String, Integer> either;
            id = either = localId.type();
        }
        object = (String)id.fold(Html5Stylist::normalizeCssId, x -> "v" + x);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String normalizeHref(@NotNull Link linkId) {
        Object object;
        Link link = linkId;
        Objects.requireNonNull(link);
        Link link2 = link;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Link.CrossLink.class, Link.DirectLink.class, Link.LocalId.class}, (Object)link2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Link.CrossLink link3 = (Link.CrossLink)link2;
                object = this.normalizeId(link3);
                return object;
            }
            case 1: {
                Link.DirectLink directLink = (Link.DirectLink)link2;
                try {
                    String string;
                    String link4 = string = directLink.link();
                    object = link4;
                    return object;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 2: 
        }
        Link.LocalId localId = (Link.LocalId)link2;
        object = "#" + this.normalizeId(localId);
        return object;
    }

    @Override
    protected void renderHardLineBreak(@NotNull Cursor cursor, EnumSet<StringPrinter.Outer> outer) {
        cursor.lineBreakWith("<br>");
    }

    @Override
    protected void renderInlineCode(@NotNull Cursor cursor, @NotNull Doc.InlineCode code, EnumSet<StringPrinter.Outer> outer) {
        cursor.invisibleContent("<code class=\"" + this.capitalize(code.language()) + "\">");
        this.renderDoc(cursor, code.code(), EnumSet.of(StringPrinter.Outer.EnclosingTag));
        cursor.invisibleContent("</code>");
    }

    @Override
    protected void renderCodeBlock(@NotNull Cursor cursor, @NotNull Doc.CodeBlock block, EnumSet<StringPrinter.Outer> outer) {
        cursor.invisibleContent("<pre class=\"" + this.capitalize(block.language()) + "\">");
        this.renderDoc(cursor, block.code(), EnumSet.of(StringPrinter.Outer.EnclosingTag));
        cursor.invisibleContent("</pre>");
    }

    @Override
    protected void renderInlineMath(@NotNull Cursor cursor, @NotNull Doc.InlineMath code, EnumSet<StringPrinter.Outer> outer) {
        this.formatInline(cursor, code.formula(), "<span class=\"doc-katex-input\">\\(", "\\)</span>", EnumSet.of(StringPrinter.Outer.Math));
    }

    @Override
    protected void renderMathBlock(@NotNull Cursor cursor, @NotNull Doc.MathBlock block, EnumSet<StringPrinter.Outer> outer) {
        cursor.invisibleContent("<pre><div class=\"doc-katex-input\">");
        this.formatBlock(cursor, block.formula(), "\\[", "\\]", EnumSet.of(StringPrinter.Outer.Math));
        cursor.invisibleContent("</div></pre>");
    }

    @Override
    protected void renderList(@NotNull Cursor cursor, @NotNull Doc.List list, EnumSet<StringPrinter.Outer> outer) {
        String tag = list.isOrdered() ? "ol" : "ul";
        cursor.invisibleContent("<" + tag + ">");
        list.items().forEach(item -> {
            cursor.invisibleContent("<li>");
            this.renderDoc(cursor, (Doc)item, EnumSet.of(StringPrinter.Outer.List, StringPrinter.Outer.EnclosingTag));
            cursor.invisibleContent("</li>");
        });
        cursor.invisibleContent("</" + tag + ">");
    }

    @NotNull
    private String capitalize(@NotNull org.aya.pretty.doc.Language s) {
        String name = s.displayName();
        return name.isEmpty() ? name : name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static /* synthetic */ CharSequence lambda$renderCssStyle$1(String rec$, Object xva$0) {
        return "  %s".formatted(xva$0);
    }

    public static class Config
    extends StringPrinterConfig<Html5Stylist> {
        public Config(@NotNull Html5Stylist stylist) {
            super(stylist);
        }
    }
}

