/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.string;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.IntFunction;
import kala.collection.Map;
import kala.collection.SeqLike;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.backend.string.StringStylist;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.printer.Printer;
import org.aya.pretty.printer.PrinterConfig;
import org.jetbrains.annotations.NotNull;

public class StringPrinter<Config extends StringPrinterConfig<?>>
implements Printer<String, Config> {
    @NotNull
    public static final EnumSet<Outer> FREE = EnumSet.noneOf(Outer.class);
    protected Config config;
    @NotNull
    private static final Map<String, String> unicodeMapping = Map.ofEntries((Tuple2[])new Tuple2[]{Tuple.of((Object)"/\\", (Object)"\u2227"), Tuple.of((Object)"\\/", (Object)"\u2228"), Tuple.of((Object)"=>", (Object)"\u21d2"), Tuple.of((Object)"ulift", (Object)"\u2191"), Tuple.of((Object)"forall", (Object)"\u2200"), Tuple.of((Object)"->", (Object)"\u2192"), Tuple.of((Object)"_|_", (Object)"\u22a5"), Tuple.of((Object)"top", (Object)"\u22a4"), Tuple.of((Object)"(|", (Object)"\u2987"), Tuple.of((Object)"|)", (Object)"\u2988"), Tuple.of((Object)"{|", (Object)"\u2983"), Tuple.of((Object)"|}", (Object)"\u2984"), Tuple.of((Object)"[|", (Object)"\u27e6"), Tuple.of((Object)"|]", (Object)"\u27e7")});

    @NotNull
    protected String makeIndent(int indent) {
        return " ".repeat(indent);
    }

    @Override
    @NotNull
    public String render(@NotNull Config config, @NotNull Doc doc) {
        this.config = config;
        Cursor cursor = new Cursor(this);
        this.renderHeader(cursor);
        this.renderDoc(cursor, doc, FREE);
        this.renderFooter(cursor);
        return cursor.result().toString();
    }

    private int lineRemaining(@NotNull Cursor cursor) {
        int pw = ((PrinterConfig.Basic)this.config).getPageWidth();
        return pw == -1 ? pw : pw - cursor.getCursor();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int predictWidth(@NotNull Cursor cursor, @NotNull Doc doc) {
        int n;
        Doc doc2 = doc;
        Objects.requireNonNull(doc2);
        Doc doc3 = doc2;
        int n2 = 0;
        block26: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Doc.Empty.class, Doc.Line.class, Doc.PlainText.class, Doc.EscapedText.class, Doc.SpecialSymbol.class, Doc.HyperLinked.class, Doc.Image.class, Doc.Styled.class, Doc.Tooltip.class, Doc.FlatAlt.class, Doc.Cat.class, Doc.Nest.class, Doc.Union.class, Doc.Column.class, Doc.Nesting.class, Doc.PageWidth.class, Doc.CodeBlock.class, Doc.InlineCode.class, Doc.InlineMath.class, Doc.MathBlock.class, Doc.List.class}, (Object)doc3, n2)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
                case 1: {
                    if (!(doc3 instanceof Doc.Empty) && !(doc3 instanceof Doc.Line)) {
                        n2 = 2;
                        continue block26;
                    }
                    return 0;
                }
                case 2: {
                    Doc.PlainText plainText = (Doc.PlainText)doc3;
                    try {
                        String string;
                        String text = string = plainText.text();
                        n = text.length();
                        return n;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 3: {
                    Doc.EscapedText escapedText = (Doc.EscapedText)doc3;
                    {
                        String string;
                        String text = string = escapedText.text();
                        n = text.length();
                        return n;
                    }
                }
                case 4: {
                    Doc.SpecialSymbol specialSymbol = (Doc.SpecialSymbol)doc3;
                    {
                        String string;
                        String text = string = specialSymbol.text();
                        n = text.length();
                        return n;
                    }
                }
                case 5: {
                    Doc.HyperLinked text = (Doc.HyperLinked)doc3;
                    n = this.predictWidth(cursor, text.doc());
                    return n;
                }
                case 6: {
                    Doc.Image i = (Doc.Image)doc3;
                    n = this.predictWidth(cursor, i.alt());
                    return n;
                }
                case 7: {
                    Doc.Styled styled = (Doc.Styled)doc3;
                    n = this.predictWidth(cursor, styled.doc());
                    return n;
                }
                case 8: {
                    Doc.Tooltip tooltip = (Doc.Tooltip)doc3;
                    n = this.predictWidth(cursor, tooltip.doc());
                    return n;
                }
                case 9: {
                    Doc.FlatAlt alt = (Doc.FlatAlt)doc3;
                    n = this.predictWidth(cursor, alt.defaultDoc());
                    return n;
                }
                case 10: {
                    Doc.Cat cat = (Doc.Cat)doc3;
                    n = (Integer)cat.inner().view().map(inner -> this.predictWidth(cursor, (Doc)inner)).reduce(Integer::sum);
                    return n;
                }
                case 11: {
                    Doc.Nest nest = (Doc.Nest)doc3;
                    n = this.predictWidth(cursor, nest.doc()) + nest.indent();
                    return n;
                }
                case 12: {
                    Doc.Union union = (Doc.Union)doc3;
                    n = this.predictWidth(cursor, union.longerOne());
                    return n;
                }
                case 13: {
                    Doc.Column column = (Doc.Column)doc3;
                    n = this.predictWidth(cursor, column.docBuilder().apply(cursor.getCursor()));
                    return n;
                }
                case 14: {
                    Doc.Nesting nesting = (Doc.Nesting)doc3;
                    n = this.predictWidth(cursor, nesting.docBuilder().apply(cursor.getNestLevel()));
                    return n;
                }
                case 15: {
                    Doc.PageWidth pageWidth = (Doc.PageWidth)doc3;
                    n = this.predictWidth(cursor, pageWidth.docBuilder().apply(((PrinterConfig.Basic)this.config).getPageWidth()));
                    return n;
                }
                case 16: {
                    Doc.CodeBlock codeBlock = (Doc.CodeBlock)doc3;
                    n = this.predictWidth(cursor, codeBlock.code());
                    return n;
                }
                case 17: {
                    Doc.InlineCode inlineCode = (Doc.InlineCode)doc3;
                    n = this.predictWidth(cursor, inlineCode.code());
                    return n;
                }
                case 18: {
                    Doc.InlineMath inlineMath = (Doc.InlineMath)doc3;
                    n = this.predictWidth(cursor, inlineMath.formula());
                    return n;
                }
                case 19: {
                    Doc.MathBlock mathBlock = (Doc.MathBlock)doc3;
                    n = this.predictWidth(cursor, mathBlock.formula());
                    return n;
                }
                case 20: 
            }
            break;
        }
        Doc.List list = (Doc.List)doc3;
        n = (Integer)list.items().view().map(x -> this.predictWidth(cursor, (Doc)x)).reduce(Integer::sum);
        return n;
    }

    @NotNull
    protected Doc fitsBetter(@NotNull Cursor cursor, @NotNull Doc a, @NotNull Doc b) {
        if (cursor.isAtLineStart()) {
            return a;
        }
        int lineRem = this.lineRemaining(cursor);
        return lineRem == -1 || this.predictWidth(cursor, a) <= lineRem ? a : b;
    }

    protected void renderHeader(@NotNull Cursor cursor) {
    }

    protected void renderFooter(@NotNull Cursor cursor) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void renderDoc(@NotNull Cursor cursor, @NotNull Doc doc, EnumSet<Outer> outer) {
        Doc doc2 = doc;
        Objects.requireNonNull(doc2);
        Doc doc3 = doc2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Doc.PlainText.class, Doc.EscapedText.class, Doc.SpecialSymbol.class, Doc.HyperLinked.class, Doc.Image.class, Doc.Styled.class, Doc.Line.class, Doc.FlatAlt.class, Doc.Cat.class, Doc.Nest.class, Doc.Union.class, Doc.Column.class, Doc.Nesting.class, Doc.PageWidth.class, Doc.CodeBlock.class, Doc.InlineCode.class, Doc.List.class, Doc.InlineMath.class, Doc.MathBlock.class, Doc.Tooltip.class, Doc.Empty.class}, (Object)doc3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Doc.PlainText plainText = (Doc.PlainText)doc3;
                try {
                    String string;
                    String text = string = plainText.text();
                    this.renderPlainText(cursor, text, outer);
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                Doc.EscapedText escapedText = (Doc.EscapedText)doc3;
                {
                    String string;
                    String text = string = escapedText.text();
                    cursor.visibleContent(text);
                    return;
                }
            }
            case 2: {
                Doc.SpecialSymbol specialSymbol = (Doc.SpecialSymbol)doc3;
                {
                    String string;
                    String symbol = string = specialSymbol.text();
                    this.renderSpecialSymbol(cursor, symbol, outer);
                    return;
                }
            }
            case 3: {
                Doc.HyperLinked text = (Doc.HyperLinked)doc3;
                this.renderHyperLinked(cursor, text, outer);
                return;
            }
            case 4: {
                Doc.Image image = (Doc.Image)doc3;
                this.renderImage(cursor, image, outer);
                return;
            }
            case 5: {
                Doc.Styled styled = (Doc.Styled)doc3;
                this.renderStyled(cursor, styled, outer);
                return;
            }
            case 6: {
                this.renderHardLineBreak(cursor, outer);
                return;
            }
            case 7: {
                Doc.FlatAlt alt = (Doc.FlatAlt)doc3;
                this.renderFlatAlt(cursor, alt, outer);
                return;
            }
            case 8: {
                Doc.Cat cat = (Doc.Cat)doc3;
                cat.inner().forEach(inner -> this.renderDoc(cursor, (Doc)inner, outer));
                return;
            }
            case 9: {
                Doc.Nest nest = (Doc.Nest)doc3;
                this.renderNest(cursor, nest, outer);
                return;
            }
            case 10: {
                Doc.Union union = (Doc.Union)doc3;
                this.renderUnionDoc(cursor, union, outer);
                return;
            }
            case 11: {
                Doc.Column column = (Doc.Column)doc3;
                this.renderDoc(cursor, column.docBuilder().apply(cursor.getCursor()), outer);
                return;
            }
            case 12: {
                Doc.Nesting nesting = (Doc.Nesting)doc3;
                this.renderDoc(cursor, nesting.docBuilder().apply(cursor.getNestLevel()), outer);
                return;
            }
            case 13: {
                Doc.PageWidth pageWidth = (Doc.PageWidth)doc3;
                this.renderDoc(cursor, pageWidth.docBuilder().apply(((PrinterConfig.Basic)this.config).getPageWidth()), outer);
                return;
            }
            case 14: {
                Doc.CodeBlock codeBlock = (Doc.CodeBlock)doc3;
                this.renderCodeBlock(cursor, codeBlock, outer);
                return;
            }
            case 15: {
                Doc.InlineCode inlineCode = (Doc.InlineCode)doc3;
                this.renderInlineCode(cursor, inlineCode, outer);
                return;
            }
            case 16: {
                Doc.List list = (Doc.List)doc3;
                this.renderList(cursor, list, outer);
                return;
            }
            case 17: {
                Doc.InlineMath inlineMath = (Doc.InlineMath)doc3;
                this.renderInlineMath(cursor, inlineMath, outer);
                return;
            }
            case 18: {
                Doc.MathBlock mathBlock = (Doc.MathBlock)doc3;
                this.renderMathBlock(cursor, mathBlock, outer);
                return;
            }
            case 19: {
                Doc.Tooltip tooltip = (Doc.Tooltip)doc3;
                this.renderTooltip(cursor, tooltip, outer);
                return;
            }
            case 20: 
        }
    }

    protected void renderSpecialSymbol(@NotNull Cursor cursor, @NotNull String text, EnumSet<Outer> outer) {
        if (((PrinterConfig.Basic)this.config).opt(StringPrinterConfig.TextOptions.Unicode, false).booleanValue()) {
            for (String k : unicodeMapping.keysView()) {
                if (!text.trim().equals(k)) continue;
                cursor.visibleContent(text.replace(k, (CharSequence)unicodeMapping.get((Object)k)));
                return;
            }
        }
        this.renderPlainText(cursor, text, outer);
    }

    protected void renderNest(@NotNull Cursor cursor, @NotNull Doc.Nest nest, EnumSet<Outer> outer) {
        cursor.nested(nest.indent(), () -> this.renderDoc(cursor, nest.doc(), outer));
    }

    protected void renderUnionDoc(@NotNull Cursor cursor, @NotNull Doc.Union union, EnumSet<Outer> outer) {
        this.renderDoc(cursor, this.fitsBetter(cursor, union.shorterOne(), union.longerOne()), outer);
    }

    protected void renderFlatAlt(@NotNull Cursor cursor, @NotNull Doc.FlatAlt alt, EnumSet<Outer> outer) {
        this.renderDoc(cursor, this.fitsBetter(cursor, alt.defaultDoc(), alt.preferWhenFlatten()), outer);
    }

    protected void renderHyperLinked(@NotNull Cursor cursor, @NotNull Doc.HyperLinked text, EnumSet<Outer> outer) {
        this.renderDoc(cursor, text.doc(), outer);
    }

    protected void renderImage(@NotNull Cursor cursor, @NotNull Doc.Image image, EnumSet<Outer> outer) {
        this.renderDoc(cursor, image.alt(), outer);
    }

    protected void renderStyled(@NotNull Cursor cursor, @NotNull Doc.Styled styled, EnumSet<Outer> outer) {
        StringStylist stylist = this.prepareStylist();
        stylist.format(styled.styles(), cursor, outer, () -> this.renderDoc(cursor, styled.doc(), outer));
    }

    @NotNull
    protected StringStylist prepareStylist() {
        return (StringStylist)((PrinterConfig.Basic)this.config).getStylist();
    }

    protected void renderPlainText(@NotNull Cursor cursor, @NotNull String content, EnumSet<Outer> outer) {
        cursor.visibleContent(this.escapePlainText(content, outer));
    }

    @NotNull
    protected String escapePlainText(@NotNull String content, EnumSet<Outer> outer) {
        return content;
    }

    protected void renderBlockSeparator(@NotNull Cursor cursor, EnumSet<Outer> ignoredOuter) {
        cursor.lineBreakWith("\n");
    }

    protected void renderHardLineBreak(@NotNull Cursor cursor, EnumSet<Outer> outer) {
        this.renderBlockSeparator(cursor, outer);
    }

    protected void renderTooltip(@NotNull Cursor cursor, @NotNull Doc.Tooltip tooltip, EnumSet<Outer> outer) {
        this.renderDoc(cursor, tooltip.doc(), outer);
    }

    protected void renderCodeBlock(@NotNull Cursor cursor, @NotNull Doc.CodeBlock block, EnumSet<Outer> outer) {
        this.separateBlockIfNeeded(cursor, outer);
        this.formatBlock(cursor, block.code(), "", "", EnumSet.of(Outer.Code));
    }

    protected void renderInlineCode(@NotNull Cursor cursor, @NotNull Doc.InlineCode code, EnumSet<Outer> outer) {
        cursor.visibleContent("`");
        this.renderDoc(cursor, code.code(), EnumSet.of(Outer.Code));
        cursor.visibleContent("`");
    }

    protected void renderMathBlock(@NotNull Cursor cursor, @NotNull Doc.MathBlock block, EnumSet<Outer> outer) {
        this.separateBlockIfNeeded(cursor, outer);
        this.formatBlock(cursor, block.formula(), "", "", EnumSet.of(Outer.Math));
    }

    protected void renderInlineMath(@NotNull Cursor cursor, @NotNull Doc.InlineMath code, EnumSet<Outer> outer) {
        this.renderDoc(cursor, code.formula(), EnumSet.of(Outer.Math));
    }

    protected void renderList(@NotNull Cursor cursor, @NotNull Doc.List list, EnumSet<Outer> outer) {
        this.formatList(cursor, list, outer);
    }

    protected void formatList(@NotNull Cursor cursor, @NotNull Doc.List list, EnumSet<Outer> outer) {
        this.formatList(cursor, list, idx -> list.isOrdered() ? idx + 1 + "." : "-", outer);
    }

    protected void formatList(@NotNull Cursor cursor, @NotNull Doc.List list, @NotNull IntFunction<String> itemBegin, EnumSet<Outer> outer) {
        this.separateBlockIfNeeded(cursor, outer);
        Doc items = Doc.vcat((SeqLike<Doc>)list.items().mapIndexed((idx, item) -> {
            String pre = (String)itemBegin.apply(idx);
            Doc content = Doc.align(item);
            return Doc.stickySep(Doc.escaped(pre), content);
        }));
        this.renderDoc(cursor, items, EnumSet.of(Outer.List));
        if (!outer.contains((Object)Outer.List)) {
            this.separateBlockIfNeeded(cursor, outer);
            this.renderBlockSeparator(cursor, outer);
        }
    }

    protected void separateBlockIfNeeded(@NotNull Cursor cursor, EnumSet<Outer> outer) {
        cursor.whenLineUsed(() -> this.renderBlockSeparator(cursor, outer));
    }

    protected void formatBlock(@NotNull Cursor cursor, @NotNull Doc doc, @NotNull String begin, @NotNull String end, EnumSet<Outer> outer) {
        this.formatBlock(cursor, begin, end, outer, () -> this.renderDoc(cursor, doc, outer));
    }

    protected void formatBlock(@NotNull Cursor cursor, @NotNull String begin, @NotNull String end, EnumSet<Outer> outer, @NotNull Runnable inside) {
        cursor.invisibleContent(begin);
        this.renderBlockSeparator(cursor, outer);
        inside.run();
        this.renderBlockSeparator(cursor, outer);
        cursor.invisibleContent(end);
        this.renderBlockSeparator(cursor, outer);
    }

    protected void formatInline(@NotNull Cursor cursor, @NotNull Doc doc, @NotNull String begin, @NotNull String end, EnumSet<Outer> outer) {
        cursor.invisibleContent(begin);
        this.renderDoc(cursor, doc, outer);
        cursor.invisibleContent(end);
    }

    public static enum Outer {
        Code,
        Math,
        EnclosingTag,
        List;

    }
}

