/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.terminal;

import java.util.EnumSet;
import org.aya.pretty.backend.string.ClosingStylist;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.backend.terminal.UnixTermStyle;
import org.aya.pretty.doc.Style;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.StyleFamily;
import org.jetbrains.annotations.NotNull;

public class UnixTermStylist
extends ClosingStylist {
    public UnixTermStylist(@NotNull ColorScheme colorScheme, @NotNull StyleFamily styleFamily) {
        super(colorScheme, styleFamily);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatItalic(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("\u001b[3m", "\u001b[23m", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatBold(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("\u001b[1m", "\u001b[22m", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatLineThrough(@NotNull Style.LineThrough line, EnumSet<StringPrinter.Outer> outer) {
        return switch (line.position()) {
            default -> throw new MatchException(null, null);
            case Style.LineThrough.Position.Underline -> new ClosingStylist.StyleToken("\u001b[4m", "\u001b[24m", false);
            case Style.LineThrough.Position.Strike -> new ClosingStylist.StyleToken("\u001b[9m", "\u001b[29m", false);
            case Style.LineThrough.Position.Overline -> ClosingStylist.StyleToken.NULL;
        };
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatCustom( @NotNull Style.CustomStyle style) {
        if (style instanceof UnixTermStyle) {
            UnixTermStyle termStyle = (UnixTermStyle)style;
            return switch (termStyle) {
                default -> throw new MatchException(null, null);
                case UnixTermStyle.Dim -> new ClosingStylist.StyleToken("\u001b[2m", "\u001b[22m", false);
                case UnixTermStyle.DoubleUnderline -> new ClosingStylist.StyleToken("\u001b[21m", "\u001b[24m", false);
                case UnixTermStyle.CurlyUnderline -> new ClosingStylist.StyleToken("\u001b[4:3m", "\u001b[4:0m", false);
                case UnixTermStyle.Overline -> new ClosingStylist.StyleToken("\u001b[53m", "\u001b[55m", false);
                case UnixTermStyle.Blink -> new ClosingStylist.StyleToken("\u001b[5m", "\u001b[25m", false);
                case UnixTermStyle.Reverse -> new ClosingStylist.StyleToken("\u001b[7m", "\u001b[27m", false);
                case UnixTermStyle.TerminalRed -> new ClosingStylist.StyleToken("\u001b[31m", "\u001b[39m", false);
                case UnixTermStyle.TerminalGreen -> new ClosingStylist.StyleToken("\u001b[32m", "\u001b[39m", false);
                case UnixTermStyle.TerminalBlue -> new ClosingStylist.StyleToken("\u001b[34m", "\u001b[39m", false);
                case UnixTermStyle.TerminalYellow -> new ClosingStylist.StyleToken("\u001b[33m", "\u001b[39m", false);
                case UnixTermStyle.TerminalPurple -> new ClosingStylist.StyleToken("\u001b[35m", "\u001b[39m", false);
                case UnixTermStyle.TerminalCyan -> new ClosingStylist.StyleToken("\u001b[36m", "\u001b[39m", false);
            };
        }
        return super.formatCustom(style);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatColorHex(int rgb, boolean bg) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return new ClosingStylist.StyleToken(String.format("\u001b[%d;2;%d;%d;%dm", bg ? 48 : 38, r, g, b), String.format("\u001b[%dm", bg ? 49 : 39), false);
    }
}

