/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.error;

import java.util.Comparator;
import java.util.List;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Docile;
import org.aya.pretty.error.PrettyErrorConfig;
import org.aya.pretty.error.Span;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PrettyError(@NotNull String filePath, @NotNull Span errorRange, @NotNull Doc brief, @NotNull FormatConfig formatConfig, @NotNull ImmutableSeq<Tuple2<Span, Doc>> inlineHints) implements Docile
{
    private static final int INDENT_FACTOR = 2;

    @NotNull
    public Doc toDoc(@NotNull PrettyErrorConfig config) {
        Span.Data primary = this.errorRange.normalize(config);
        ImmutableSeq hints = this.inlineHints.view().map(kv -> Tuple.of((Object)((Span)kv.component1()).normalize(config), (Object)((Doc)kv.component2()))).filter(kv -> ((Span.Data)kv.component1()).startLine() == ((Span.Data)kv.component1()).endLine()).toImmutableSeq();
        Span.Data allRange = (Span.Data)hints.map(Tuple2::component1).foldLeft((Object)primary, Span.Data::union);
        return Doc.vcat(Doc.plain("In file " + this.filePath + ":" + primary.startLine() + ":" + primary.startCol() + " ->"), Doc.empty(), Doc.hang(2, this.visualizeCode(config, allRange, primary, (ImmutableSeq<Tuple2<Span.Data, Doc>>)hints)), Doc.empty(), this.brief, Doc.empty());
    }

    @Override
    @NotNull
    public Doc toDoc() {
        return this.toDoc(PrettyErrorConfig.DEFAULT);
    }

    @NotNull
    private String visualizeLine(@NotNull PrettyErrorConfig config, @NotNull String line) {
        int tabWidth = config.tabWidth();
        return line.replaceAll("\t", " ".repeat(tabWidth));
    }

    @NotNull
    private HintGroup splitHints(@NotNull ImmutableSeq<HintLine> others) {
        HintGroup group = new HintGroup();
        if (others.isNotEmpty()) {
            int right;
            HintLine first = (HintLine)others.getFirst();
            group.add(first.startCol, first, this.formatConfig);
            int left = first.startCol;
            int last = right = first.endCol;
            for (int i = 1; i < others.size(); ++i) {
                HintLine the = (HintLine)others.get(i);
                if (PrettyError.overlaps(left, right, the.startCol, the.endCol)) {
                    group.overlapped.append((Object)the);
                    continue;
                }
                int indent = the.startCol - last;
                group.add(indent, the, this.formatConfig);
                last = the.endCol;
                left = Math.min(left, the.startCol);
                right = Math.max(right, the.endCol);
            }
        }
        return group;
    }

    /*
     * Unable to fully structure code
     */
    private void renderHints(boolean continued, boolean continuedFromStartEnd, int currentLine, int codeIndent, int vbarUsedIndent, @NotNull Doc vbar, @NotNull Doc currentCode, @NotNull CodeBuilder builder, @NotNull ImmutableSeq<HintLine> others) {
        block7: {
            split = this.splitHints(others);
            startOrEnd = split.startOrEnd;
            rest = codeIndent - vbarUsedIndent;
            if (!continued) {
                codeDoc = startOrEnd == null || startOrEnd.loc != Span.NowLoc.End ? Doc.cat(new Doc[]{vbar, Doc.indent(rest * 2, currentCode)}) : Doc.cat(new Doc[]{vbar, this.formatConfig.lineNoSepDoc(), Doc.indent(rest * 2 - 1, currentCode)});
                builder.add(currentLine, codeDoc);
            }
            underlines = Doc.cat(split.underlines);
            notes = Doc.cat(split.notes);
            if (notes.isEmpty()) ** GOTO lbl-1000
            if (notes instanceof Doc.Cat) {
                var17_15 = (Doc.Cat)notes;
                inner = var18_17 = var17_15.inner();
                ** if (!inner.isEmpty()) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v0 = underlines;
                ** GOTO lbl19
            }
lbl-1000:
            // 2 sources

            {
                v0 = Doc.stickySep(new Doc[]{underlines, Doc.align(notes)});
            }
lbl19:
            // 2 sources

            almost = v0;
            codeHint = startOrEnd != null ? this.renderStartEndHint(startOrEnd, vbar, almost, rest) : this.renderContinuedHint(continued, continuedFromStartEnd, vbar, almost, rest);
            builder.add(codeHint);
            if (split.overlapped.isNotEmpty()) {
                this.renderHints(true, startOrEnd != null, currentLine, codeIndent, vbarUsedIndent, vbar, currentCode, builder, (ImmutableSeq<HintLine>)split.overlapped.toImmutableSeq());
            }
            break block7;
            catch (Throwable var17_16) {
                throw new MatchException(var17_16.toString(), var17_16);
            }
        }
    }

    @NotNull
    private Doc renderStartEndHint(@NotNull HintLine startOrEnd, @NotNull Doc vbar, @NotNull Doc almost, int rest) {
        return startOrEnd.loc == Span.NowLoc.Start ? Doc.cat(vbar, this.formatConfig.beginCornerDoc(), this.formatConfig.underlineBodyDoc(rest * 2 - 1), almost) : Doc.cat(vbar, this.formatConfig.endCornerDoc(), this.formatConfig.underlineBodyDoc(rest * 2 - 1), almost);
    }

    @NotNull
    private Doc renderContinuedHint(boolean continued, boolean fromStartEnd, @NotNull Doc vbar, @NotNull Doc almost, int rest) {
        return continued && fromStartEnd ? Doc.cat(this.formatConfig.lineNoSepDoc(), Doc.indent(rest * 2, almost)) : Doc.cat(vbar, Doc.indent(rest * 2, almost));
    }

    private Tuple2<Integer, Doc> computeMultilineVBar(@NotNull ImmutableSeq<HintLine> between) {
        int last = 0;
        Doc vbar = Doc.empty();
        for (HintLine the : between) {
            int level = the.allocIndent - last;
            vbar = Doc.cat(vbar, Doc.indent(level * 2, this.formatConfig.lineNoSepDoc()));
            last = the.endCol;
        }
        return Tuple.of((Object)last, (Object)vbar);
    }

    private void renderHints(int currentLine, int codeIndent, @NotNull Doc currentCode, @NotNull CodeBuilder builder, @NotNull ImmutableSeq<HintLine> hintLines) {
        ImmutableSeq between = hintLines.view().filter(h -> h.loc == Span.NowLoc.Between).sorted(Comparator.comparingInt(a -> a.allocIndent)).toImmutableSeq();
        ImmutableSeq others = hintLines.filter(h -> h.loc != Span.NowLoc.Between);
        Tuple2<Integer, Doc> vbar = this.computeMultilineVBar((ImmutableSeq<HintLine>)between);
        this.renderHints(false, false, currentLine, codeIndent, (Integer)vbar.component1(), (Doc)vbar.component2(), currentCode, builder, (ImmutableSeq<HintLine>)others);
    }

    @NotNull
    private Doc visualizeCode(@NotNull PrettyErrorConfig config, @NotNull Span.Data fullRange, @NotNull Span.Data primaryRange, @NotNull ImmutableSeq<Tuple2<Span.Data, Doc>> hints) {
        int startLine = fullRange.startLine();
        int endLine = fullRange.endLine();
        int showMore = config.showMore();
        int linenoWidth = Math.max(this.widthOfLineNumber(startLine), this.widthOfLineNumber(endLine)) + 1;
        List<String> lines = this.errorRange.input().lines().skip(Math.max(startLine - 1 - showMore, 0)).limit(endLine - startLine + 1 + showMore).map(line -> this.visualizeLine(config, (String)line)).toList();
        int minLineNo = Math.max(startLine - showMore, 1);
        int maxLineNo = minLineNo + lines.size();
        MutableList alloc = MutableList.create();
        alloc.append((Object)Tuple.of((Object)primaryRange, (Object)Doc.empty(), (Object)0));
        hints.view().filter(kv -> ((Span.Data)kv.component1()).startLine() >= minLineNo && ((Span.Data)kv.component1()).endLine() <= maxLineNo).mapIndexed((i, kv) -> Tuple.of((Object)((Span.Data)kv.component1()), (Object)((Doc)kv.component2()), (Object)(i + 1))).forEach(arg_0 -> ((MutableList)alloc).append(arg_0));
        int codeIndent = alloc.size();
        int lineNo = minLineNo;
        CodeBuilder builder = new CodeBuilder();
        for (String line2 : lines) {
            int currentLine = lineNo;
            Doc currentCode = Doc.plain(line2);
            ImmutableSeq hintLines = alloc.view().mapNotNull(note -> switch (((Span.Data)note.component1()).nowLoc(currentLine)) {
                default -> throw new MatchException(null, null);
                case Span.NowLoc.Shot -> new HintLine((Doc)note.component2(), Span.NowLoc.Shot, ((Span.Data)note.component1()).startCol(), ((Span.Data)note.component1()).endCol(), (Integer)note.component3());
                case Span.NowLoc.Start -> new HintLine(Doc.empty(), Span.NowLoc.Start, 0, ((Span.Data)note.component1()).startCol(), (Integer)note.component3());
                case Span.NowLoc.End -> new HintLine((Doc)note.component2(), Span.NowLoc.End, 0, ((Span.Data)note.component1()).endCol(), (Integer)note.component3());
                case Span.NowLoc.Between -> new HintLine(Doc.empty(), Span.NowLoc.Between, 0, 0, (Integer)note.component3());
                case Span.NowLoc.None -> null;
            }).sorted(Comparator.comparingInt(a -> a.startCol)).toImmutableSeq();
            if (hintLines.isEmpty()) {
                builder.add(currentLine, Doc.indent(codeIndent * 2, currentCode));
            } else {
                this.renderHints(currentLine, codeIndent, currentCode, builder, (ImmutableSeq<HintLine>)hintLines);
            }
            ++lineNo;
        }
        return Doc.catBlockR(linenoWidth, builder.lineDocs, Doc.cat(this.formatConfig.lineNoSepDoc(), Doc.ONE_WS), builder.codeDocs);
    }

    private static boolean overlaps(int x1, int x2, int y1, int y2) {
        return x1 <= y2 && y1 <= x2;
    }

    @NotNull
    private static Doc renderHint(@NotNull FormatConfig cfg, int startCol, int endCol, MultilineMode mode) {
        StringBuilder builder = new StringBuilder();
        if (mode == MultilineMode.DISABLED || cfg.errorIndicator().isEmpty()) {
            builder.append(cfg.underlineBegin());
            int length = endCol - startCol - 1;
            if (length > 0) {
                builder.append(cfg.underlineBody(length));
            }
            builder.append(cfg.underlineEnd());
        } else {
            int length = endCol - startCol;
            if (length > 0) {
                builder.append(cfg.underlineBody(length));
            }
            builder.append(cfg.errorIndicator().get());
        }
        return Doc.plain(builder.toString());
    }

    private int widthOfLineNumber(int line) {
        return String.valueOf(line).length();
    }

    public record FormatConfig(@NotNull Option<Character> vbarForHints, char lineNoSeparator, @NotNull Option<Character> errorIndicator, char underlineBegin, char underlineEnd, char underlineBody, char beginCorner, char endCorner) {
        public static final FormatConfig CLASSIC = new FormatConfig((Option<Character>)Option.none(), '|', (Option<Character>)Option.none(), '^', '^', '-', '+', '+');
        public static final FormatConfig UNICODE = new FormatConfig((Option<Character>)Option.some((Object)Character.valueOf('\u251d')), '\u2502', (Option<Character>)Option.some((Object)Character.valueOf('\u256f')), '\u2570', '\u256f', '\u2500', '\u256d', '\u2570');

        @NotNull
        public String underlineBody(int n) {
            return Character.toString(this.underlineBody).repeat(n);
        }

        @NotNull
        public Doc underlineBodyDoc(int n) {
            return Doc.plain(this.underlineBody(n));
        }

        @NotNull
        public Doc lineNoSepDoc() {
            return Doc.plain(Character.toString(this.lineNoSeparator));
        }

        @NotNull
        public Doc beginCornerDoc() {
            return Doc.plain(Character.toString(this.beginCorner));
        }

        @NotNull
        public Doc endCornerDoc() {
            return Doc.plain(Character.toString(this.endCorner));
        }
    }

    private static final class HintGroup {
        @NotNull
        MutableList<Doc> underlines = MutableList.create();
        @NotNull
        MutableList<Doc> notes = MutableList.create();
        @NotNull
        MutableList<HintLine> overlapped = MutableList.create();
        @Nullable
        HintLine startOrEnd = null;

        private HintGroup() {
        }

        public void add(int indent, @NotNull HintLine line, @NotNull FormatConfig cfg) {
            int n = line.startCol;
            int n2 = line.endCol;
            Doc hint = PrettyError.renderHint(cfg, n, n2, switch (line.loc) {
                default -> throw new MatchException(null, null);
                case Span.NowLoc.Shot, Span.NowLoc.Between, Span.NowLoc.None -> MultilineMode.DISABLED;
                case Span.NowLoc.Start -> MultilineMode.START;
                case Span.NowLoc.End -> MultilineMode.END;
            });
            this.underlines.append((Object)Doc.indent(indent, hint));
            this.notes.append((Object)line.note);
            if (line.loc == Span.NowLoc.Start || line.loc == Span.NowLoc.End) {
                this.startOrEnd = line;
            }
        }
    }

    record HintLine(Doc note, Span.NowLoc loc, int startCol, int endCol, int allocIndent) {
    }

    private static final class CodeBuilder {
        @NotNull
        private final MutableList<Doc> lineDocs = MutableList.create();
        @NotNull
        private final MutableList<Doc> codeDocs = MutableList.create();

        private CodeBuilder() {
        }

        void add(int currentLine, @NotNull Doc code) {
            this.lineDocs.append((Object)Doc.plain(String.valueOf(currentLine)));
            this.codeDocs.append((Object)code);
        }

        void add(@NotNull Doc code) {
            this.lineDocs.append((Object)Doc.ONE_WS);
            this.codeDocs.append((Object)code);
        }
    }

    static enum MultilineMode {
        DISABLED,
        START,
        END;

    }
}

