/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.html;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import kala.collection.immutable.ImmutableSeq;
import org.aya.pretty.backend.string.ClosingStylist;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.doc.Style;
import org.aya.pretty.printer.ColorScheme;
import org.aya.pretty.printer.StyleFamily;
import org.aya.pretty.style.AyaColorScheme;
import org.aya.pretty.style.AyaStyleFamily;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Html5Stylist
extends ClosingStylist {
    @NotNull
    public static final Html5Stylist DEFAULT = new Html5Stylist(AyaColorScheme.EMACS, AyaStyleFamily.DEFAULT);

    public Html5Stylist(@NotNull ColorScheme colorScheme, @NotNull StyleFamily styleFamily) {
        super(colorScheme, styleFamily);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatItalic(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("<i>", "</i>", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatBold(EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("<b>", "</b>", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatLineThrough(@NotNull Style.LineThrough line, EnumSet<StringPrinter.Outer> outer) {
        return new ClosingStylist.StyleToken("<span style=\"%s\">".formatted(Html5Stylist.styleToCss(line)), "</span>", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatColorHex(int rgb, boolean background) {
        return new ClosingStylist.StyleToken("<span style=\"%s:%s;\">".formatted(background ? "background-color" : "color", Html5Stylist.cssColor(rgb)), "</span>", false);
    }

    @NotNull
    public static ImmutableSeq<String> styleKeyToCss(@NotNull String className) {
        return ImmutableSeq.from((Object[])className.split("::", -1)).map(Html5Stylist::normalizeCssId);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String styleToCss(@NotNull Style style) {
        Style style2 = style;
        Objects.requireNonNull(style2);
        Style style3 = style2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Style.Attr.class, Style.LineThrough.class, Style.ColorHex.class, Style.ColorName.class}, (Style)style3, n)) {
            case 0: {
                Style.Attr attr = (Style.Attr)style3;
                switch (attr) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case Italic: {
                        return "font-style: italic;";
                    }
                    case Bold: 
                }
                return "font-weight: bold;";
            }
            case 1: {
                int n2;
                Object color;
                Object shape;
                Object pos;
                Object object;
                Style.LineThrough lineThrough = (Style.LineThrough)style3;
                try {
                    pos = object = lineThrough.position();
                    shape = object = lineThrough.shape();
                    color = object = lineThrough.color();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                String decoLine = switch (1.$SwitchMap$org$aya$pretty$doc$Style$LineThrough$Position[((Enum)pos).ordinal()]) {
                    default -> throw new MatchException(null, null);
                    case 1 -> "text-decoration-line: overline;";
                    case 2 -> "text-decoration-line: underline; text-underline-position: under;";
                    case 3 -> "text-decoration-line: line-through;";
                };
                String decoStyle = switch (1.$SwitchMap$org$aya$pretty$doc$Style$LineThrough$Shape[((Enum)shape).ordinal()]) {
                    default -> throw new MatchException(null, null);
                    case 1 -> "text-decoration-style: solid;";
                    case 2 -> "text-decoration-style: wavy;";
                };
                Object object2 = color;
                int n3 = 0;
                String colorRef = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Style.ColorHex.class, Style.ColorName.class}, (Style.Color)object2, n3)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        int rgb;
                        Style.ColorHex var13_22 = (Style.ColorHex)object2;
                        {
                            int var16_24 = n2 = var13_22.color();
                            rgb = n2;
                            n2 = var13_22.background() ? 1 : 0;
                        }
                        yield Html5Stylist.cssColor(rgb);
                    }
                    case 1 -> {
                        String name;
                        Style.ColorName var15_16 = (Style.ColorName)object2;
                        {
                            String var17_26;
                            name = var17_26 = var15_16.colorName();
                            boolean var17_27 = var15_16.background();
                        }
                        yield "var(%s)".formatted(Html5Stylist.cssVar(name));
                    }
                    case -1 -> null;
                };
                String decoColor = colorRef != null ? "text-decoration-color: %s;".formatted(colorRef) : "";
                Object object3 = decoLine + decoStyle + decoColor;
                return object3;
            }
            case 2: {
                int rgb;
                int n4;
                Object object3;
                Object object = (Style.ColorHex)style3;
                {
                    int n5 = n4 = ((Style.ColorHex)object).color();
                    rgb = n4;
                    n5 = n4 = (int)(((Style.ColorHex)object).background() ? 1 : 0);
                }
                int background = n4;
                if (background != 0) {
                    object3 = "background-color: %s".formatted(Html5Stylist.cssColor(rgb));
                    return object3;
                }
                object3 = "color: %s;".formatted(Html5Stylist.cssColor(rgb));
                return object3;
            }
            case 3: {
                int n6;
                String name;
                Object object3;
                int n2;
                Style.ColorName colorName = (Style.ColorName)style3;
                {
                    String string;
                    name = string = colorName.colorName();
                    n2 = n6 = colorName.background();
                }
                int background = n6;
                if (background != 0) {
                    object3 = "background-color: var(%s);".formatted(Html5Stylist.cssVar(name));
                    return object3;
                }
                object3 = "color: var(%s);".formatted(Html5Stylist.cssVar(name));
                return object3;
            }
        }
        return null;
    }

    @NotNull
    public static String colorsToCss(@NotNull ColorScheme colorScheme) {
        String string = "  %s";
        return colorScheme.definedColors().toImmutableSeq().view().map(t -> "%s: %s;".formatted(Html5Stylist.cssVar((String)t.component1()), Html5Stylist.cssColor((Integer)t.component2()))).joinToString((CharSequence)"\n", arg_0 -> Html5Stylist.lambda$colorsToCss$1("  %s", arg_0));
    }

    @NotNull
    public static String cssVar(@NotNull String name) {
        return "--" + Html5Stylist.normalizeCssId(name);
    }

    @NotNull
    public static String cssColor(int rgb) {
        return "#%06x".formatted(rgb);
    }

    @NotNull
    public static String normalizeCssId(@NotNull String selector) {
        selector = selector.replaceAll("::", "-");
        StringBuilder builder = new StringBuilder();
        for (char c : selector.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c >= '\u00a0' || c == '-' || c == '_') {
                builder.append(c);
                continue;
            }
            builder.append(Integer.toHexString(c));
        }
        return builder.toString();
    }

    private static /* synthetic */ CharSequence lambda$colorsToCss$1(String rec$, Object xva$0) {
        return "  %s".formatted(xva$0);
    }

    public static class ClassedPreset
    extends ClosingStylist.Delegate {
        public ClassedPreset(@NotNull ClosingStylist delegate) {
            super(delegate);
        }

        @Override
        @NotNull
        protected ImmutableSeq<ClosingStylist.StyleToken> formatPresetStyle(@NotNull String styleName, EnumSet<StringPrinter.Outer> outer) {
            String className = (String)Html5Stylist.styleKeyToCss(styleName).getLast();
            return ImmutableSeq.of((Object)new ClosingStylist.StyleToken("<span class=\"%s\">".formatted(className), "</span>", false));
        }
    }
}

