/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.doc;

import java.util.function.IntFunction;
import java.util.function.Supplier;
import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.MutableList;
import org.aya.pretty.backend.html.DocHtmlPrinter;
import org.aya.pretty.backend.html.Html5Stylist;
import org.aya.pretty.backend.latex.DocTeXPrinter;
import org.aya.pretty.backend.md.DocMdPrinter;
import org.aya.pretty.backend.md.MdStylist;
import org.aya.pretty.backend.string.DebugStylist;
import org.aya.pretty.backend.string.StringPrinter;
import org.aya.pretty.backend.string.StringPrinterConfig;
import org.aya.pretty.backend.terminal.AdaptiveCliStylist;
import org.aya.pretty.backend.terminal.DocTermPrinter;
import org.aya.pretty.doc.Docile;
import org.aya.pretty.doc.Language;
import org.aya.pretty.doc.Link;
import org.aya.pretty.doc.Style;
import org.aya.pretty.doc.Styles;
import org.aya.pretty.printer.Printer;
import org.aya.pretty.printer.PrinterConfig;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Doc
extends Docile {
    @NotNull
    public static final Doc ONE_WS;
    @NotNull
    public static final Doc ALT_WS;
    @NotNull
    public static final Doc COMMA;

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    default public boolean isEmpty() {
        return this instanceof Empty;
    }

    @Override
    @NotNull
    default public Doc toDoc() {
        return this;
    }

    @NotNull
    default public String renderToString(@NotNull StringPrinterConfig<?> config) {
        return (String)this.render(new StringPrinter(), config);
    }

    @NotNull
    default public String renderToString(int pageWidth, boolean unicode) {
        StringPrinterConfig<DebugStylist> config = new StringPrinterConfig<DebugStylist>(DebugStylist.DEFAULT);
        config.set(PrinterConfig.PageOptions.PageWidth, pageWidth);
        config.set(StringPrinterConfig.TextOptions.Unicode, unicode);
        return this.renderToString(config);
    }

    @NotNull
    default public String renderToTerminal() {
        return this.renderToTerminal(-1, true);
    }

    @NotNull
    default public String renderToTerminal(int pageWidth, boolean unicode) {
        DocTermPrinter.Config config = new DocTermPrinter.Config(AdaptiveCliStylist.INSTANCE);
        config.set(PrinterConfig.PageOptions.PageWidth, pageWidth);
        config.set(StringPrinterConfig.TextOptions.Unicode, unicode);
        return this.render(new DocTermPrinter(), config);
    }

    @NotNull
    default public String renderToHtml() {
        return this.renderToHtml(true);
    }

    @NotNull
    default public String renderToHtml(boolean withHeader) {
        DocHtmlPrinter.Config config = new DocHtmlPrinter.Config(Html5Stylist.DEFAULT);
        config.set(StringPrinterConfig.StyleOptions.HeaderCode, withHeader);
        config.set(StringPrinterConfig.StyleOptions.StyleCode, withHeader);
        config.set(StringPrinterConfig.StyleOptions.SeparateStyle, withHeader);
        config.set(StringPrinterConfig.TextOptions.Unicode, true);
        return (String)this.render(new DocHtmlPrinter(), config);
    }

    @NotNull
    default public String renderToMd() {
        return this.render(new DocMdPrinter(), new DocMdPrinter.Config(MdStylist.DEFAULT));
    }

    @NotNull
    default public String renderToAyaMd() {
        DocMdPrinter.Config config = new DocMdPrinter.Config(MdStylist.DEFAULT);
        config.set(StringPrinterConfig.StyleOptions.AyaFlavored, true);
        config.set(StringPrinterConfig.StyleOptions.HeaderCode, true);
        config.set(StringPrinterConfig.StyleOptions.StyleCode, true);
        config.set(StringPrinterConfig.StyleOptions.SeparateStyle, true);
        config.set(StringPrinterConfig.TextOptions.Unicode, true);
        return this.render(new DocMdPrinter(), config);
    }

    @NotNull
    default public String renderToTeX() {
        return this.render(new DocTeXPrinter(), new DocTeXPrinter.Config());
    }

    @NotNull
    default public <Out, Config extends PrinterConfig> Out render(@NotNull Printer<Out, Config> printer, @NotNull Config config) {
        return printer.render(config, this);
    }

    @NotNull
    default public String debugRender() {
        return this.renderToString(-1, false);
    }

    @NotNull
    default public String commonRender() {
        return this.renderToString(80, true);
    }

    @NotNull
    public static Doc linkDef(@NotNull Doc doc, @NotNull Link id) {
        return Doc.linkDef(doc, id, null);
    }

    @NotNull
    public static Doc linkRef(@NotNull Doc doc, @NotNull Link href) {
        return Doc.linkRef(doc, href, null);
    }

    @NotNull
    public static Doc linkDef(@NotNull Doc doc, @NotNull Link id, @Nullable String hover) {
        return new HyperLinked(doc, id, id, hover);
    }

    @NotNull
    public static Doc linkRef(@NotNull Doc doc, @NotNull Link href, @Nullable String hover) {
        return new HyperLinked(doc, href, null, hover);
    }

    @NotNull
    public static Doc hyperLink(@NotNull Doc doc, @NotNull Link href, @Nullable String hover) {
        return new HyperLinked(doc, href, null, hover);
    }

    @NotNull
    public static Doc hyperLink(@NotNull String plain, @NotNull Link href) {
        return Doc.hyperLink(Doc.plain(plain), href, null);
    }

    @NotNull
    public static Doc image(@NotNull Doc alt, @NotNull Link src) {
        return new Image(alt, src);
    }

    @NotNull
    public static Doc code(@NotNull String code) {
        return Doc.code(Language.Builtin.Plain, Doc.plain(code));
    }

    @NotNull
    public static Doc code(@NotNull Doc code) {
        return Doc.code(Language.Builtin.Aya, code);
    }

    @NotNull
    public static Doc code(@NotNull Language language, @NotNull Doc code) {
        return new InlineCode(language, code);
    }

    @NotNull
    public static Doc codeBlock(@NotNull Language language, @NotNull Doc code) {
        return new CodeBlock(language, code);
    }

    @NotNull
    public static Doc codeBlock(@NotNull Language language, @NotNull String code) {
        return Doc.codeBlock(language, Doc.plain(code));
    }

    @NotNull
    public static Doc math(@NotNull Doc formula) {
        return new InlineMath(formula);
    }

    @NotNull
    public static Doc mathBlock(@NotNull Doc formula) {
        return new MathBlock(formula);
    }

    @NotNull
    public static Doc styled(@NotNull Style style, @NotNull Doc doc) {
        return new Styled((Seq<Style>)Seq.of((Object)style), doc);
    }

    @NotNull
    public static Doc styled(@NotNull Style style, @NotNull String plain) {
        return new Styled((Seq<Style>)Seq.of((Object)style), Doc.plain(plain));
    }

    @NotNull
    public static Doc styled(@NotNull Styles builder, @NotNull Doc doc) {
        return new Styled((Seq<Style>)builder.styles(), doc);
    }

    @NotNull
    public static Doc styled(@NotNull Styles builder, @NotNull String plain) {
        return new Styled((Seq<Style>)builder.styles(), Doc.plain(plain));
    }

    @NotNull
    public static Doc licit(boolean explicit, Doc doc) {
        return Doc.wrap(explicit ? "(" : "{", explicit ? ")" : "}", doc);
    }

    @NotNull
    public static Doc spaced(Doc symbol) {
        return Doc.cat(ONE_WS, symbol, ONE_WS);
    }

    @NotNull
    public static Doc wrap(@NotNull Doc left, @NotNull Doc right, @NotNull Doc doc) {
        return Doc.cat(left, doc, right);
    }

    @NotNull
    public static Doc wrap(String leftSymbol, String rightSymbol, Doc doc) {
        return Doc.wrap(Doc.symbol(leftSymbol), Doc.symbol(rightSymbol), doc);
    }

    @NotNull
    public static Doc spacedWrap(@NotNull Doc left, @NotNull Doc right, @NotNull Doc doc) {
        return Doc.wrap(left, right, Doc.wrap(ONE_WS, ONE_WS, doc));
    }

    @NotNull
    public static Doc spacedWrap(@NotNull String leftSymbol, @NotNull String rightSymbol, @NotNull Doc doc) {
        return Doc.spacedWrap(Doc.symbol(leftSymbol), Doc.symbol(rightSymbol), doc);
    }

    @NotNull
    public static Doc bracedUnless(Doc doc, boolean falsification) {
        return falsification ? doc : Doc.braced(doc);
    }

    @NotNull
    public static Doc braced(Doc doc) {
        return Doc.wrap("{", "}", doc);
    }

    @NotNull
    public static Doc flatAltBracedBlock(Doc defaultDoc, Doc flatDoc) {
        return Doc.flatAlt(Doc.stickySep(Doc.symbol("{"), defaultDoc, Doc.symbol("}")), Doc.vcat(Doc.symbol("{"), flatDoc, Doc.symbol("}")));
    }

    @NotNull
    public static Doc angled(Doc doc) {
        return Doc.wrap("<", ">", doc);
    }

    @NotNull
    public static Doc parened(Doc doc) {
        return Doc.wrap("(", ")", doc);
    }

    @NotNull
    public static Doc emptyIf(boolean cond, Supplier<@NotNull Doc> otherwise) {
        return cond ? Doc.empty() : otherwise.get();
    }

    @NotNull
    public static Doc empty() {
        return Empty.INSTANCE;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc flatAlt(@NotNull Doc defaultDoc, @NotNull Doc preferWhenFlattened) {
        return new FlatAlt(defaultDoc, preferWhenFlattened);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc column(@NotNull IntFunction<Doc> docBuilder) {
        return new Column(docBuilder);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc nesting(@NotNull IntFunction<Doc> docBuilder) {
        return new Nesting(docBuilder);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc pageWidth(@NotNull IntFunction<Doc> docBuilder) {
        return new PageWidth(docBuilder);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc nest(int indent, @NotNull Doc doc) {
        return indent == 0 || doc.isEmpty() ? doc : new Nest(indent, doc);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc align(@NotNull Doc doc) {
        return Doc.column(k -> Doc.nesting(i -> Doc.nest(k - i, doc)));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc hang(int deltaNest, @NotNull Doc doc) {
        return Doc.align(Doc.nest(deltaNest, doc));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc indent(int indent, @NotNull Doc doc) {
        return Doc.hang(indent, Doc.cat(Doc.spaces(indent), doc));
    }

    @NotNull
    public static Doc spaces(int n) {
        return n <= 0 ? Doc.empty() : Doc.plain(" ".repeat(n));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc par(int indent, @NotNull Doc doc) {
        return Doc.nest(indent, Doc.cat(Doc.spaces(indent), doc));
    }

    @NotNull
    public static Doc splitR(int minBeforeDelim, @NotNull Doc left, @NotNull Doc delim, @NotNull Doc right) {
        Doc alignedMiddle = Doc.column(k -> Doc.nesting(i -> Doc.indent(minBeforeDelim - k + i, delim)));
        return Doc.cat(left, alignedMiddle, Doc.align(right));
    }

    @NotNull
    public static Doc splitL(int minBeforeRight, @NotNull Doc left, @NotNull Doc delim, @NotNull Doc right) {
        Doc alignedRight = Doc.column(k -> Doc.nesting(i -> Doc.indent(minBeforeRight - k + i, Doc.align(right))));
        return Doc.cat(left, delim, alignedRight);
    }

    @NotNull
    public static Doc catBlockR(int minBeforeDelim, @NotNull SeqLike<Doc> left, @NotNull Doc delim, @NotNull SeqLike<Doc> right) {
        SeqView vs = left.zipView(right).map(p -> Doc.splitR(minBeforeDelim, (Doc)p.component1(), delim, (Doc)p.component2()));
        return Doc.vcat((SeqLike<Doc>)vs);
    }

    @NotNull
    public static Doc catBlockL(int minBeforeRight, @NotNull SeqLike<Doc> left, @NotNull Doc delim, @NotNull SeqLike<Doc> right) {
        SeqView vs = left.zipView(right).map(p -> Doc.splitL(minBeforeRight, (Doc)p.component1(), delim, (Doc)p.component2()));
        return Doc.vcat((SeqLike<Doc>)vs);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static Doc cblock(@NotNull Doc prefix, int indent, @NotNull Doc block) {
        if (block.isEmpty()) {
            return prefix;
        }
        return Doc.vcat(Doc.sepNonEmpty(prefix, Doc.symbol("{")), Doc.nest(indent, Doc.vcat(block)), Doc.symbol("}"));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc ordinal(int n) {
        int m = n % 100;
        if (m >= 4 && m <= 20) {
            return Doc.plain(n + "th");
        }
        return Doc.plain(n + (switch (n % 10) {
            case 1 -> "st";
            case 2 -> "nd";
            case 3 -> "rd";
            default -> "th";
        }));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc plain(String text) {
        if (text.isEmpty()) {
            return Doc.empty();
        }
        return new PlainText(text);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc escaped(String text) {
        return new EscapedText(text);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc english(String text) {
        if (!text.contains(" ")) {
            return Doc.plain(text);
        }
        return Doc.sep((SeqLike<Doc>)Seq.from((Object[])text.split(" ", -1)).view().map(Doc::plain).map(p -> Doc.flatAlt(p, Doc.cat(Doc.line(), p))));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc symbol(String symbol) {
        if (!1.$assertionsDisabled && symbol.contains("\n")) {
            throw new AssertionError();
        }
        return new SpecialSymbol(symbol);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc symbols(String ... symbols) {
        return Doc.sep((SeqLike<Doc>)Seq.of((Object[])symbols).map(Doc::symbol));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc cat(@NotNull SeqLike<Doc> docs) {
        return Doc.simpleCat(docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc cat(Doc ... docs) {
        return Doc.cat((SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc vcat(Doc ... docs) {
        return Doc.join(Doc.line(), docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc vcat(@NotNull @NotNull SeqLike<@NotNull Doc> docs) {
        return Doc.join(Doc.line(), docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc vcatNonEmpty(Doc ... docs) {
        return Doc.vcatNonEmpty((SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc vcatNonEmpty(@NotNull SeqLike<Doc> docs) {
        return Doc.vcat((SeqLike<Doc>)docs.view().filter(Doc::isNotEmpty));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc list(boolean isOrdered, @NotNull @NotNull SeqLike<@NotNull Doc> docs) {
        return new List(isOrdered, (ImmutableSeq<Doc>)docs.toSeq());
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc ordered(Doc ... docs) {
        return Doc.list(true, (SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc bullet(Doc ... docs) {
        return Doc.list(false, (SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc stickySep(@NotNull @NotNull SeqLike<@NotNull Doc> docs) {
        return Doc.join(ONE_WS, docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc stickySep(Doc ... docs) {
        return Doc.join(ONE_WS, docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc sep(Doc ... docs) {
        return Doc.join(ALT_WS, docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc sep(@NotNull SeqLike<Doc> docs) {
        return Doc.join(ALT_WS, docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc sepNonEmpty(Doc ... docs) {
        return Doc.sepNonEmpty((SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc sepNonEmpty(@NotNull SeqLike<Doc> docs) {
        return Doc.sep((SeqLike<Doc>)docs.view().filter(Doc::isNotEmpty));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc commaList(Doc ... docs) {
        return Doc.commaList((SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc commaList(@NotNull SeqLike<Doc> docs) {
        return Doc.join(COMMA, docs);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Doc vcommaList(@NotNull SeqLike<Doc> docs) {
        return Doc.join(Doc.cat(Doc.plain(","), Doc.line()), docs);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc join(@NotNull Doc delim, Doc ... docs) {
        return Doc.join(delim, (SeqLike<Doc>)Seq.of((Object[])docs));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Doc join(@NotNull Doc delim, @NotNull @NotNull SeqLike<@NotNull Doc> docs) {
        ImmutableSeq cache = docs.toSeq();
        if (cache.isEmpty()) {
            return Doc.empty();
        }
        Doc first = (Doc)cache.getFirst();
        if (cache.sizeEquals(1)) {
            return first;
        }
        return Doc.simpleCat((SeqLike<Doc>)((SeqLike)cache.view().drop(1).foldLeft((Object)MutableList.of((Object)first), (l, r) -> {
            l.append((Object)delim);
            l.append(r);
            return l;
        })));
    }

    @Contract(value="-> new")
    @NotNull
    public static Doc line() {
        return Line.INSTANCE;
    }

    @NotNull
    private static Doc simpleCat(@NotNull @NotNull SeqLike<@NotNull Doc> xs) {
        ImmutableSeq seq = xs.toSeq();
        if (seq.isEmpty()) {
            return Doc.empty();
        }
        if (seq.sizeEquals(1)) {
            return (Doc)seq.getFirst();
        }
        return new Cat((ImmutableSeq<Doc>)seq);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        ONE_WS = Doc.plain(" ");
        ALT_WS = Doc.flatAlt(ONE_WS, Doc.line());
        COMMA = Doc.cat(Doc.plain(","), ALT_WS);
    }

    public static enum Empty implements Doc
    {
        INSTANCE;

    }

    public record HyperLinked(@NotNull Doc doc, @NotNull Link href, @Nullable Link id, @Nullable String hover) implements Doc
    {
    }

    public record Image(@NotNull Doc alt, @NotNull Link src) implements Doc
    {
    }

    public record InlineCode(@NotNull Language language, @NotNull Doc code) implements Doc
    {
    }

    public record CodeBlock(@NotNull Language language, @NotNull Doc code) implements Doc
    {
    }

    public record InlineMath(@NotNull Doc formula) implements Doc
    {
    }

    public record MathBlock(@NotNull Doc formula) implements Doc
    {
    }

    public record Styled(@NotNull Seq<Style> styles, @NotNull Doc doc) implements Doc
    {
    }

    public record FlatAlt(@NotNull Doc defaultDoc, @NotNull Doc preferWhenFlatten) implements Doc
    {
    }

    public record Column(@NotNull IntFunction<Doc> docBuilder) implements Doc
    {
    }

    public record Nesting(@NotNull IntFunction<Doc> docBuilder) implements Doc
    {
    }

    public record PageWidth(@NotNull IntFunction<Doc> docBuilder) implements Doc
    {
    }

    public record Nest(int indent, @NotNull Doc doc) implements Doc
    {
    }

    public record PlainText(@NotNull String text) implements Doc
    {
    }

    public record EscapedText(@NotNull String text) implements Doc
    {
    }

    public record SpecialSymbol(@NotNull String text) implements Doc
    {
    }

    public record List(boolean isOrdered, @NotNull ImmutableSeq<Doc> items) implements Doc
    {
    }

    public static enum Line implements Doc
    {
        INSTANCE;

    }

    public record Cat(@NotNull ImmutableSeq<Doc> inner) implements Doc
    {
    }

    public record Union(@NotNull Doc shorterOne, @NotNull Doc longerOne) implements Doc
    {
    }

    public record Tooltip(@NotNull Doc doc, @NotNull Docile tooltip) implements Doc
    {
    }
}

