/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.error;

import kala.collection.Seq;
import kala.collection.SeqLike;
import kala.collection.SeqView;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.Buffer;
import kala.control.Option;
import kala.tuple.Tuple;
import kala.tuple.Tuple2;
import org.aya.pretty.doc.Doc;
import org.aya.pretty.doc.Docile;
import org.aya.pretty.error.PrettyErrorConfig;
import org.aya.pretty.error.Span;
import org.jetbrains.annotations.NotNull;

public record PrettyError(@NotNull String filePath, @NotNull Span errorRange, @NotNull Doc brief, @NotNull ImmutableSeq<Tuple2<Span, Doc>> inlineHints) implements Docile
{
    @NotNull
    public Doc toDoc(@NotNull PrettyErrorConfig config) {
        Span.Data primary = this.errorRange.normalize(config);
        SeqView hints = this.inlineHints.view().map(kv -> Tuple.of((Object)((Span)kv._1).normalize(config), (Object)((Doc)kv._2)));
        Span.Data range = (Span.Data)hints.map(kv -> (Span.Data)kv._1).foldLeft((Object)primary, Span.Data::union);
        SeqView allHints = hints.isEmpty() ? Seq.of((Object)Tuple.of((Object)primary, (Object)Doc.empty())) : hints;
        return Doc.vcat(Doc.plain("In file " + this.filePath + ":" + primary.startLine() + ":" + primary.startCol() + " ->"), Doc.empty(), Doc.hang(2, this.visualizeCode(config, range, (SeqLike<Tuple2<Span.Data, Doc>>)allHints)), this.brief);
    }

    @Override
    @NotNull
    public Doc toDoc() {
        return this.toDoc(PrettyErrorConfig.DEFAULT);
    }

    @NotNull
    private String visualizeLine(@NotNull PrettyErrorConfig config, @NotNull String line) {
        int tabWidth = config.tabWidth();
        return line.replaceAll("\t", " ".repeat(tabWidth));
    }

    @NotNull
    private Doc visualizeCode(@NotNull PrettyErrorConfig config, @NotNull Span.Data fullRange, @NotNull SeqLike<Tuple2<Span.Data, Doc>> hints) {
        int startLine = fullRange.startLine();
        int endLine = fullRange.endLine();
        int showMore = config.showMore();
        int linenoWidth = Math.max(this.widthOfLineNumber(startLine), this.widthOfLineNumber(endLine));
        Buffer lines = (Buffer)this.errorRange.input().lines().skip(Math.max(startLine - 1 - showMore, 0)).limit(endLine - startLine + 1 + showMore).map(line -> this.visualizeLine(config, (String)line)).collect(Buffer.factory());
        int lineNo = Math.max(startLine - showMore, 1);
        Buffer docs = Buffer.of();
        for (String line2 : lines) {
            docs.append((Object)this.renderLine(line2, lineNo, linenoWidth));
            int finalLineNo = lineNo;
            Option r = hints.find(kv -> ((Span.Data)kv._1).startLine() == finalLineNo);
            if (r.isDefined()) {
                Tuple2 find = (Tuple2)r.get();
                int startCol = ((Span.Data)find._1).startCol();
                int endCol = ((Span.Data)find._1).endCol();
                Doc hintUnderline = this.renderHint(startCol, endCol, linenoWidth);
                Doc doc = (Doc)find._2;
                if (doc instanceof Doc.Empty) {
                    docs.append((Object)hintUnderline);
                } else {
                    docs.append((Object)Doc.cat(hintUnderline, Doc.ONE_WS, doc));
                }
            }
            ++lineNo;
        }
        docs.append((Object)Doc.empty());
        return Doc.vcat((SeqLike<Doc>)docs);
    }

    private Doc renderHint(int startCol, int endCol, int linenoWidth) {
        StringBuilder builder = new StringBuilder();
        builder.append(" ".repeat(startCol + linenoWidth + " | ".length()));
        builder.append("^");
        int length = endCol - startCol - 1;
        if (length > 0) {
            builder.append("-".repeat(length));
        }
        builder.append("^");
        return Doc.plain(builder.toString());
    }

    private Doc renderLine(String line, int lineNo, int linenoWidth) {
        return this.renderLine(line, (Option<Integer>)Option.of((Object)lineNo), linenoWidth);
    }

    private Doc renderLine(String line, Option<Integer> lineNo, int linenoWidth) {
        StringBuilder builder = new StringBuilder();
        if (lineNo.isDefined()) {
            builder.append(String.format("%" + linenoWidth + "d | ", lineNo.get()));
        } else {
            builder.append(String.format("%" + linenoWidth + "s | ", ""));
        }
        builder.append(line);
        return Doc.plain(builder.toString());
    }

    private int widthOfLineNumber(int line) {
        return String.valueOf(line).length();
    }
}

