/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.string.style;

import kala.collection.Seq;
import kala.collection.SeqView;
import kala.control.Option;
import org.aya.pretty.backend.string.Cursor;
import org.aya.pretty.backend.string.StringStylist;
import org.aya.pretty.doc.Style;
import org.aya.pretty.doc.Styles;
import org.jetbrains.annotations.NotNull;

public abstract class ClosingStylist
extends StringStylist {
    @Override
    public void format(@NotNull Seq<Style> styles, @NotNull Cursor cursor, @NotNull Runnable inside) {
        this.formatInternal((SeqView<Style>)styles.view(), cursor, inside);
    }

    private void formatInternal(@NotNull SeqView<Style> styles, @NotNull Cursor cursor, @NotNull Runnable inside) {
        if (styles.isEmpty()) {
            inside.run();
            return;
        }
        Style style = (Style)styles.first();
        if (style instanceof Style.Preset) {
            Style.Preset preset = (Style.Preset)style;
            this.formatMany(styles, cursor, inside, this.formatPreset(preset.styleName()));
        } else {
            this.formatMany(styles, cursor, inside, (SeqView<StyleToken>)SeqView.of((Object)this.formatOne(style)));
        }
    }

    private void formatMany(@NotNull SeqView<Style> styles, @NotNull Cursor cursor, @NotNull Runnable inside, @NotNull SeqView<StyleToken> formats) {
        formats.forEach(format -> cursor.content(format.start, format.visible));
        this.formatInternal((SeqView<Style>)styles.drop(1), cursor, inside);
        formats.reversed().forEach(format -> cursor.content(format.end, format.visible));
    }

    @NotNull
    protected StyleToken formatOne(Style style) {
        if (style instanceof Style.Attr) {
            Style.Attr attr = (Style.Attr)style;
            return switch (attr) {
                default -> throw new IncompatibleClassChangeError();
                case Style.Attr.Code -> this.formatCode();
                case Style.Attr.Italic -> this.formatItalic();
                case Style.Attr.Bold -> this.formatBold();
                case Style.Attr.Strike -> this.formatStrike();
                case Style.Attr.Underline -> this.formatUnderline();
            };
        }
        if (style instanceof Style.ColorName) {
            Style.ColorName color = (Style.ColorName)style;
            return this.formatColorName(color, color.background());
        }
        if (style instanceof Style.ColorHex) {
            Style.ColorHex color = (Style.ColorHex)style;
            return this.formatColorHex(color.color(), color.background());
        }
        if (style instanceof Style.CustomStyle) {
            Style.CustomStyle custom = (Style.CustomStyle)style;
            return this.formatCustom(custom);
        }
        throw new IllegalArgumentException("Unsupported style: " + style.getClass().getName());
    }

    @NotNull
    private Option<Integer> getColor(@NotNull String colorName) {
        return this.colorScheme.definedColors().getOption((Object)colorName);
    }

    @NotNull
    protected SeqView<StyleToken> formatPreset(String styleName) {
        Option style = this.styleFamily.definedStyles().getOption((Object)styleName);
        if (style.isEmpty()) {
            return SeqView.empty();
        }
        return ((Styles)style.get()).styles.view().map(this::formatOne);
    }

    @NotNull
    protected StyleToken formatColorName(@NotNull Style.ColorName color, boolean background) {
        Option<Integer> rgb = this.getColor(color.colorName());
        return rgb.isDefined() ? this.formatColorHex((Integer)rgb.get(), background) : StyleToken.NULL;
    }

    protected abstract StyleToken formatItalic();

    protected abstract StyleToken formatCode();

    protected abstract StyleToken formatBold();

    protected abstract StyleToken formatStrike();

    protected abstract StyleToken formatUnderline();

    protected abstract StyleToken formatColorHex(int var1, boolean var2);

    @NotNull
    protected abstract StyleToken formatCustom(@NotNull Style.CustomStyle var1);

    public record StyleToken(@NotNull String start, @NotNull String end, boolean visible) {
        @NotNull
        public static final StyleToken NULL = new StyleToken("", "", false);
    }
}

