/*
 * Decompiled with CFR 0.152.
 */
package org.aya.pretty.backend.string.style;

import org.aya.pretty.backend.string.custom.UnixTermStyle;
import org.aya.pretty.backend.string.style.ClosingStylist;
import org.jetbrains.annotations.NotNull;

public class UnixTermStylist
extends ClosingStylist {
    @NotNull
    public static final UnixTermStylist INSTANCE = new UnixTermStylist();

    private UnixTermStylist() {
    }

    @Override
    protected ClosingStylist.StyleToken formatItalic() {
        return new ClosingStylist.StyleToken("\u001b[3m", "\u001b[23m", false);
    }

    @Override
    protected ClosingStylist.StyleToken formatCode() {
        return new ClosingStylist.StyleToken("`", "'", true);
    }

    @Override
    protected ClosingStylist.StyleToken formatBold() {
        return new ClosingStylist.StyleToken("\u001b[1m", "\u001b[22m", false);
    }

    @Override
    protected ClosingStylist.StyleToken formatStrike() {
        return new ClosingStylist.StyleToken("\u001b[9m", "\u001b[29m", false);
    }

    @Override
    protected ClosingStylist.StyleToken formatUnderline() {
        return new ClosingStylist.StyleToken("\u001b[4m", "\u001b[24m", false);
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatCustom( @NotNull Style.CustomStyle style) {
        if (style instanceof UnixTermStyle) {
            UnixTermStyle termStyle = (UnixTermStyle)style;
            return switch (termStyle) {
                default -> throw new IncompatibleClassChangeError();
                case UnixTermStyle.Dim -> new ClosingStylist.StyleToken("\u001b[2m", "\u001b[22m", false);
                case UnixTermStyle.DoubleUnderline -> new ClosingStylist.StyleToken("\u001b[21m", "\u001b[24m", false);
                case UnixTermStyle.CurlyUnderline -> new ClosingStylist.StyleToken("\u001b[4:3m", "\u001b[4:0m", false);
                case UnixTermStyle.Overline -> new ClosingStylist.StyleToken("\u001b[53m", "\u001b[55m", false);
                case UnixTermStyle.Blink -> new ClosingStylist.StyleToken("\u001b[5m", "\u001b[25m", false);
                case UnixTermStyle.Reverse -> new ClosingStylist.StyleToken("\u001b[7m", "\u001b[27m", false);
            };
        }
        return ClosingStylist.StyleToken.NULL;
    }

    @Override
    @NotNull
    protected ClosingStylist.StyleToken formatColorHex(int rgb, boolean bg) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return new ClosingStylist.StyleToken(String.format("\u001b[%d;2;%d;%d;%dm", bg ? 48 : 38, r, g, b), String.format("\u001b[%dm", bg ? 49 : 39), false);
    }
}

