package org.intellij.markdown.ext

import org.intellij.markdown.ast.ASTNode
import org.intellij.markdown.ast.getTextInNode
import org.intellij.markdown.html.GeneratingProvider
import org.intellij.markdown.html.HtmlGenerator

internal class FrontMatterGeneratingProvider: GeneratingProvider {
  override fun processNode(visitor: HtmlGenerator.HtmlGeneratingVisitor, text: String, node: ASTNode) {
    visitor.consumeTagOpen(node, "pre", """class="frontmatter-header"""")
    visitor.consumeHtml(node.getTextInNode(text))
    visitor.consumeTagClose("pre")
  }
}
