/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.net.URI;
import java.net.URLEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"resolveToStringSafe", "", "Ljava/net/URI;", "str", "PUNCTUATION_MASK", "", "isAsciiPunctuationFix", "", "char", "", "isWhitespace", "isPunctuation", "urlEncode", "jb-md"})
public final class CommonDefsKt {
    private static final int PUNCTUATION_MASK = 1676673024;

    @NotNull
    public static final String resolveToStringSafe(@NotNull URI $this$resolveToStringSafe, @NotNull String str) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$resolveToStringSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        try {
            string = $this$resolveToStringSafe.resolve(str).toString();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Throwable e) {
            string = str;
        }
        return string;
    }

    private static final boolean isAsciiPunctuationFix(char c) {
        return StringsKt.contains$default((CharSequence)"$^`", (char)c, (boolean)false, (int)2, null);
    }

    public static final boolean isWhitespace(char c) {
        return CharsKt.isWhitespace((char)c);
    }

    public static final boolean isPunctuation(char c) {
        return CommonDefsKt.isAsciiPunctuationFix(c) || (1676673024 >> Character.getType(c) & 1) != 0;
    }

    @NotNull
    public static final String urlEncode(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String string = URLEncoder.encode(str, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return string;
    }
}

