/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGeneratorKt;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0004!\"#$B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0010Ji\u0010\u0014\u001a\u00020\u00032_\u0010\u0015\u001a[\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001b\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001c\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001d\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001c0\u0016j\u0002`\u001eH\u0007J\u0010\u0010\u0014\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator;", "", "markdownText", "", "root", "Lorg/intellij/markdown/ast/ASTNode;", "providers", "", "Lcom/intellij/psi/tree/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "includeSrcPositions", "", "<init>", "(Ljava/lang/String;Lorg/intellij/markdown/ast/ASTNode;Ljava/util/Map;Z)V", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "(Ljava/lang/String;Lorg/intellij/markdown/ast/ASTNode;Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;Z)V", "htmlString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "generateHtml", "customizer", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "node", "", "tagName", "", "attributes", "Lorg/intellij/markdown/html/AttributesCustomizer;", "tagRenderer", "Lorg/intellij/markdown/html/HtmlGenerator$TagRenderer;", "HtmlGeneratingVisitor", "DefaultTagRenderer", "TagRenderer", "Companion", "jb-md"})
public final class HtmlGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String markdownText;
    @NotNull
    private final ASTNode root;
    @NotNull
    private final Map<IElementType, GeneratingProvider> providers;
    private final boolean includeSrcPositions;
    @NotNull
    private final StringBuilder htmlString;
    @NotNull
    private static final String SRC_ATTRIBUTE_NAME = "md-src-pos";

    public HtmlGenerator(@NotNull String markdownText, @NotNull ASTNode root, @NotNull Map<IElementType, ? extends GeneratingProvider> providers, boolean includeSrcPositions) {
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        this.markdownText = markdownText;
        this.root = root;
        this.providers = providers;
        this.includeSrcPositions = includeSrcPositions;
        this.htmlString = new StringBuilder();
    }

    public /* synthetic */ HtmlGenerator(String string, ASTNode aSTNode, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, aSTNode, map, bl);
    }

    public HtmlGenerator(@NotNull String markdownText, @NotNull ASTNode root, @NotNull MarkdownFlavourDescriptor flavour, boolean includeSrcPositions) {
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        this(markdownText, root, flavour.createHtmlGeneratingProviders(LinkMap.Builder.buildLinkMap(root, markdownText), null), includeSrcPositions);
    }

    public /* synthetic */ HtmlGenerator(String string, ASTNode aSTNode, MarkdownFlavourDescriptor markdownFlavourDescriptor, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(string, aSTNode, markdownFlavourDescriptor, bl);
    }

    @Deprecated(message="To be removed, pass custom visitor instead", replaceWith=@ReplaceWith(expression="generateHtml(HtmlGeneratingVisitor)", imports={}))
    @NotNull
    public final String generateHtml(@NotNull Function3<? super ASTNode, ? super CharSequence, ? super Iterable<? extends CharSequence>, ? extends Iterable<? extends CharSequence>> customizer) {
        Intrinsics.checkNotNullParameter(customizer, (String)"customizer");
        new HtmlGeneratingVisitor(new DefaultTagRenderer(customizer, this.includeSrcPositions)).visitNode(this.root);
        String string = this.htmlString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String generateHtml(@NotNull TagRenderer tagRenderer) {
        Intrinsics.checkNotNullParameter((Object)tagRenderer, (String)"tagRenderer");
        new HtmlGeneratingVisitor(tagRenderer).visitNode(this.root);
        String string = this.htmlString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String generateHtml$default(HtmlGenerator htmlGenerator, TagRenderer tagRenderer, int n, Object object) {
        if ((n & 1) != 0) {
            tagRenderer = new DefaultTagRenderer(HtmlGeneratorKt.getDUMMY_ATTRIBUTES_CUSTOMIZER(), htmlGenerator.includeSrcPositions);
        }
        return htmlGenerator.generateHtml(tagRenderer);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator$Companion;", "", "<init>", "()V", "SRC_ATTRIBUTE_NAME", "", "getSRC_ATTRIBUTE_NAME", "()Ljava/lang/String;", "leafText", "", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "replaceEscapesAndEntities", "", "getSrcPosAttribute", "trimIndents", "indent", "", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSRC_ATTRIBUTE_NAME() {
            return SRC_ATTRIBUTE_NAME;
        }

        @NotNull
        public final CharSequence leafText(@NotNull String text, @NotNull ASTNode node, boolean replaceEscapesAndEntities) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.BLOCK_QUOTE)) {
                return "";
            }
            return EntityConverter.INSTANCE.replaceEntities((CharSequence)ASTUtilKt.getTextInNode(node, text), replaceEscapesAndEntities, replaceEscapesAndEntities);
        }

        public static /* synthetic */ CharSequence leafText$default(Companion companion, String string, ASTNode aSTNode, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.leafText(string, aSTNode, bl);
        }

        @NotNull
        public final CharSequence getSrcPosAttribute(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return this.getSRC_ATTRIBUTE_NAME() + "=\"" + node.getStartOffset() + ".." + node.getEndOffset() + "\"";
        }

        @NotNull
        public final CharSequence trimIndents(@NotNull CharSequence text, int indent) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (indent == 0) {
                return text;
            }
            StringBuilder buffer = new StringBuilder();
            int lastFlushed = 0;
            for (int offset = 0; offset < text.length(); ++offset) {
                if (offset != 0 && text.charAt(offset - 1) != '\n') continue;
                buffer.append(text.subSequence(lastFlushed, offset));
                int indentEaten = 0;
                block5: while (indentEaten < indent && offset < text.length()) {
                    switch (text.charAt(offset)) {
                        case ' ': {
                            ++indentEaten;
                            break;
                        }
                        case '\t': {
                            indentEaten += 4 - indentEaten % 4;
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    ++offset;
                }
                if (indentEaten > indent) {
                    buffer.append(StringsKt.repeat((CharSequence)" ", (int)(indentEaten - indent)));
                }
                lastFlushed = offset;
            }
            buffer.append(text.subSequence(lastFlushed, text.length()));
            return buffer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001Bp\u0012_\u0010\u0002\u001a[\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\b0\n\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u000b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\n0\u0003j\u0002`\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J=\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0016\"\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016Rm\u0010\u0002\u001a[\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\b0\n\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u000b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\n0\u0003j\u0002`\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator$DefaultTagRenderer;", "Lorg/intellij/markdown/html/HtmlGenerator$TagRenderer;", "customizer", "Lkotlin/Function3;", "Lorg/intellij/markdown/ast/ASTNode;", "Lkotlin/ParameterName;", "name", "node", "", "tagName", "", "attributes", "Lorg/intellij/markdown/html/AttributesCustomizer;", "includeSrcPositions", "", "<init>", "(Lkotlin/jvm/functions/Function3;Z)V", "getCustomizer", "()Lkotlin/jvm/functions/Function3;", "getIncludeSrcPositions", "()Z", "openTag", "", "autoClose", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;[Ljava/lang/CharSequence;Z)Ljava/lang/CharSequence;", "closeTag", "printHtml", "html", "jb-md"})
    public static class DefaultTagRenderer
    implements TagRenderer {
        @NotNull
        private final Function3<ASTNode, CharSequence, Iterable<? extends CharSequence>, Iterable<CharSequence>> customizer;
        private final boolean includeSrcPositions;

        public DefaultTagRenderer(@NotNull Function3<? super ASTNode, ? super CharSequence, ? super Iterable<? extends CharSequence>, ? extends Iterable<? extends CharSequence>> customizer, boolean includeSrcPositions) {
            Intrinsics.checkNotNullParameter(customizer, (String)"customizer");
            this.customizer = customizer;
            this.includeSrcPositions = includeSrcPositions;
        }

        @NotNull
        protected final Function3<ASTNode, CharSequence, Iterable<? extends CharSequence>, Iterable<CharSequence>> getCustomizer() {
            return this.customizer;
        }

        protected final boolean getIncludeSrcPositions() {
            return this.includeSrcPositions;
        }

        @Override
        @NotNull
        public CharSequence openTag(@NotNull ASTNode node, @NotNull CharSequence tagName, @NotNull CharSequence[] attributes, boolean autoClose) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            StringBuilder $this$openTag_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$openTag_u24lambda_u240.append("<" + tagName);
            for (CharSequence attribute : (Iterable)this.customizer.invoke((Object)node, (Object)tagName, (Object)ArraysKt.asIterable((Object[])attributes))) {
                if (attribute == null) continue;
                $this$openTag_u24lambda_u240.append(" " + attribute);
            }
            if (this.includeSrcPositions) {
                $this$openTag_u24lambda_u240.append(" " + Companion.getSrcPosAttribute(node));
            }
            StringBuilder stringBuilder2 = autoClose ? $this$openTag_u24lambda_u240.append(" />") : $this$openTag_u24lambda_u240.append(">");
            return stringBuilder.toString();
        }

        @Override
        @NotNull
        public CharSequence closeTag(@NotNull CharSequence tagName) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            return "</" + tagName + ">";
        }

        @Override
        @NotNull
        public CharSequence printHtml(@NotNull CharSequence html) {
            Intrinsics.checkNotNullParameter((Object)html, (String)"html");
            return html;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ=\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\u000f\"\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/ast/visitors/RecursiveVisitor;", "tagRenderer", "Lorg/intellij/markdown/html/HtmlGenerator$TagRenderer;", "<init>", "(Lorg/intellij/markdown/html/HtmlGenerator;Lorg/intellij/markdown/html/HtmlGenerator$TagRenderer;)V", "visitNode", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "visitLeaf", "consumeTagOpen", "tagName", "", "attributes", "", "autoClose", "", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;[Ljava/lang/CharSequence;Z)V", "consumeTagClose", "consumeHtml", "html", "jb-md"})
    public final class HtmlGeneratingVisitor
    extends RecursiveVisitor {
        @NotNull
        private final TagRenderer tagRenderer;

        public HtmlGeneratingVisitor(TagRenderer tagRenderer) {
            Intrinsics.checkNotNullParameter((Object)tagRenderer, (String)"tagRenderer");
            this.tagRenderer = tagRenderer;
        }

        @Override
        public void visitNode(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            GeneratingProvider generatingProvider = (GeneratingProvider)HtmlGenerator.this.providers.get(node.getType());
            if (generatingProvider != null) {
                generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
            } else {
                ASTNodeKt.acceptChildren(node, this);
            }
        }

        public final void visitLeaf(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            GeneratingProvider generatingProvider = (GeneratingProvider)HtmlGenerator.this.providers.get(node.getType());
            if (generatingProvider != null) {
                generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
            } else {
                this.consumeHtml(org.intellij.markdown.html.HtmlGenerator$Companion.leafText$default(Companion, HtmlGenerator.this.markdownText, node, false, 4, null));
            }
        }

        public final void consumeTagOpen(@NotNull ASTNode node, @NotNull CharSequence tagName, @NotNull CharSequence[] attributes, boolean autoClose) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            HtmlGenerator.this.htmlString.append(this.tagRenderer.openTag(node, tagName, Arrays.copyOf(attributes, attributes.length), autoClose));
        }

        public static /* synthetic */ void consumeTagOpen$default(HtmlGeneratingVisitor htmlGeneratingVisitor, ASTNode aSTNode, CharSequence charSequence, CharSequence[] charSequenceArray, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray, bl);
        }

        public final void consumeTagClose(@NotNull CharSequence tagName) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            HtmlGenerator.this.htmlString.append(this.tagRenderer.closeTag(tagName));
        }

        public final void consumeHtml(@NotNull CharSequence html) {
            Intrinsics.checkNotNullParameter((Object)html, (String)"html");
            HtmlGenerator.this.htmlString.append(this.tagRenderer.printHtml(html));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J?\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0016\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\b\"\u0004\u0018\u00010\u00032\b\b\u0002\u0010\t\u001a\u00020\nH&\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H&\u00a8\u0006\u000f"}, d2={"Lorg/intellij/markdown/html/HtmlGenerator$TagRenderer;", "", "openTag", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "tagName", "attributes", "", "autoClose", "", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;[Ljava/lang/CharSequence;Z)Ljava/lang/CharSequence;", "closeTag", "printHtml", "html", "jb-md"})
    public static interface TagRenderer {
        @NotNull
        public CharSequence openTag(@NotNull ASTNode var1, @NotNull CharSequence var2, @NotNull CharSequence[] var3, boolean var4);

        @NotNull
        public CharSequence closeTag(@NotNull CharSequence var1);

        @NotNull
        public CharSequence printHtml(@NotNull CharSequence var1);

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ CharSequence openTag$default(TagRenderer tagRenderer, ASTNode aSTNode, CharSequence charSequence, CharSequence[] charSequenceArray, boolean bl, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openTag");
                }
                if ((n & 8) != 0) {
                    bl = false;
                }
                return tagRenderer.openTag(aSTNode, charSequence, charSequenceArray, bl);
            }
        }
    }
}

