/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html.entities;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.html.entities.Entities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/html/entities/EntityConverter;", "", "<init>", "()V", "escapeAllowedString", "", "replacements", "", "", "REGEX", "Lkotlin/text/Regex;", "REGEX_ESCAPES", "replaceEntities", "text", "", "processEntities", "", "processEscapes", "jb-md"})
public final class EntityConverter {
    @NotNull
    public static final EntityConverter INSTANCE = new EntityConverter();
    @NotNull
    private static final String escapeAllowedString = "!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}~";
    @NotNull
    private static final Map<Character, String> replacements;
    @NotNull
    private static final Regex REGEX;
    @NotNull
    private static final Regex REGEX_ESCAPES;

    private EntityConverter() {
    }

    @NotNull
    public final String replaceEntities(@NotNull CharSequence text, boolean processEntities, boolean processEscapes) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (processEscapes ? REGEX_ESCAPES : REGEX).replace(text, arg_0 -> EntityConverter.replaceEntities$lambda$0(processEntities, arg_0));
    }

    private static final CharSequence replaceEntities$lambda$0(boolean $processEntities, MatchResult match) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        MatchGroupCollection g = match.getGroups();
        if (g.size() > 5 && g.get(5) != null) {
            MatchGroup matchGroup = g.get(5);
            Intrinsics.checkNotNull((Object)matchGroup);
            char c = matchGroup.getValue().charAt(0);
            String string = replacements.get(Character.valueOf(c));
            if (string == null) {
                string = String.valueOf(c);
            }
            charSequence = string;
        } else if (g.get(4) != null) {
            MatchGroup matchGroup = g.get(4);
            Intrinsics.checkNotNull((Object)matchGroup);
            String string = replacements.get(Character.valueOf(matchGroup.getValue().charAt(0)));
            if (string == null) {
                string = match.getValue();
            }
            charSequence = string;
        } else {
            Object object;
            Character c;
            Integer code;
            Integer n;
            if (!$processEntities) {
                n = null;
            } else if (g.get(1) != null) {
                n = Entities.INSTANCE.getMap().get(match.getValue());
            } else if (g.get(2) != null) {
                MatchGroup matchGroup = g.get(2);
                Intrinsics.checkNotNull((Object)matchGroup);
                n = Integer.parseInt(matchGroup.getValue());
            } else if (g.get(3) != null) {
                MatchGroup matchGroup = g.get(3);
                Intrinsics.checkNotNull((Object)matchGroup);
                n = Integer.parseInt(matchGroup.getValue(), CharsKt.checkRadix((int)16));
            } else {
                n = null;
            }
            Integer n2 = code = n;
            Character c2 = c = n2 != null ? Character.valueOf((char)n2.intValue()) : null;
            if (c != null) {
                object = replacements.get(c);
                if (object == null) {
                    object = c.toString();
                }
            } else {
                String string = match.getValue().substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = "&amp;" + string;
            }
            charSequence = (CharSequence)object;
        }
        return charSequence;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\"'), (Object)"&quot;"), TuplesKt.to((Object)Character.valueOf('&'), (Object)"&amp;"), TuplesKt.to((Object)Character.valueOf('<'), (Object)"&lt;"), TuplesKt.to((Object)Character.valueOf('>'), (Object)"&gt;")};
        replacements = MapsKt.mapOf((Pair[])pairArray);
        REGEX = new Regex("&(?:([a-zA-Z0-9]+)|#([0-9]{1,8})|#[xX]([a-fA-F0-9]{1,8}));|([\"&<>])");
        REGEX_ESCAPES = new Regex(REGEX.getPattern() + "|\\\\([!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}~])");
    }
}

