/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kala.text.StringSlice;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.html.CommonDefsKt;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.lexer.Compat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/intellij/markdown/parser/LinkMap;", "", "map", "", "", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "<init>", "(Ljava/util/Map;)V", "getLinkInfo", "label", "Builder", "LinkInfo", "jb-md"})
public final class LinkMap {
    @NotNull
    public static final Builder Builder = new Builder(null);
    @NotNull
    private final Map<CharSequence, LinkInfo> map;
    @NotNull
    private static final Regex SPACES_REGEX = new Regex("\\s+");

    public LinkMap(@NotNull Map<CharSequence, LinkInfo> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.map = map;
    }

    @Nullable
    public final LinkInfo getLinkInfo(@NotNull CharSequence label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return this.map.get(Builder.normalizeLabel(label));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J)\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0014\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/intellij/markdown/parser/LinkMap$Builder;", "", "<init>", "()V", "normalizeLabel", "", "label", "buildLinkMap", "Lorg/intellij/markdown/parser/LinkMap;", "root", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "normalizeDestination", "s", "processEscapes", "", "normalizeTitle", "clearBounding", "boundQuotes", "", "(Ljava/lang/CharSequence;[Ljava/lang/String;)Ljava/lang/CharSequence;", "SPACES_REGEX", "Lkotlin/text/Regex;", "jb-md"})
    public static final class Builder {
        private Builder() {
        }

        @NotNull
        public final CharSequence normalizeLabel(@NotNull CharSequence label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            String string = SPACES_REGEX.replace(label, " ").toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        @NotNull
        public final LinkMap buildLinkMap(@NotNull ASTNode root, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            HashMap<CharSequence, LinkInfo> map = new HashMap<CharSequence, LinkInfo>();
            ASTNodeKt.accept(root, new RecursiveVisitor(text, map){
                final /* synthetic */ String $text;
                final /* synthetic */ HashMap<CharSequence, LinkInfo> $map;
                {
                    this.$text = $text;
                    this.$map = $map;
                }

                public void visitNode(ASTNode node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.LINK_DEFINITION)) {
                        CharSequence linkLabel = LinkMap.Builder.normalizeLabel((CharSequence)ASTUtilKt.getTextInNode(node.childOfType(MarkdownElementTypes.LINK_LABEL), this.$text));
                        if (!this.$map.containsKey(linkLabel)) {
                            ((Map)this.$map).put(linkLabel, LinkInfo.Companion.create(node, this.$text));
                        }
                    } else {
                        super.visitNode(node);
                    }
                }
            });
            return new LinkMap((Map<CharSequence, LinkInfo>)map);
        }

        @NotNull
        public final CharSequence normalizeDestination(@NotNull CharSequence s, boolean processEscapes) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            String[] stringArray = new String[]{"<>"};
            String destination = EntityConverter.INSTANCE.replaceEntities(this.clearBounding(s, stringArray), true, processEscapes);
            StringBuilder sb = new StringBuilder();
            Compat.INSTANCE.forEachCodePoint(destination, (Function1<? super Integer, Unit>)((Function1)arg_0 -> Builder.normalizeDestination$lambda$0(sb, arg_0)));
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final CharSequence normalizeTitle(@NotNull CharSequence s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            String[] stringArray = new String[]{"\"\"", "''", "()"};
            return EntityConverter.INSTANCE.replaceEntities(this.clearBounding(s, stringArray), true, true);
        }

        private final CharSequence clearBounding(CharSequence s, String ... boundQuotes) {
            if (s.length() == 0) {
                return s;
            }
            for (String quotePair : boundQuotes) {
                if (s.charAt(0) != quotePair.charAt(0) || s.charAt(s.length() - 1) != quotePair.charAt(1)) continue;
                return s.subSequence(1, s.length() - 1);
            }
            return s;
        }

        private static final Unit normalizeDestination$lambda$0(StringBuilder $sb, int code) {
            char c = (char)code;
            StringBuilder stringBuilder = code == 32 ? $sb.append("%20") : (code < 32 || code >= 128 || StringsKt.contains$default((CharSequence)"\".<>\\^_`{|}", (char)c, (boolean)false, (int)2, null) ? $sb.append(CommonDefsKt.urlEncode(Compat.INSTANCE.codePointToString(code))) : $sb.append(c));
            return Unit.INSTANCE;
        }

        public /* synthetic */ Builder(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "destination", "", "title", "<init>", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getDestination", "()Ljava/lang/CharSequence;", "getTitle", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "jb-md"})
    public static final class LinkInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ASTNode node;
        @NotNull
        private final CharSequence destination;
        @Nullable
        private final CharSequence title;

        public LinkInfo(@NotNull ASTNode node, @NotNull CharSequence destination, @Nullable CharSequence title) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            this.node = node;
            this.destination = destination;
            this.title = title;
        }

        @NotNull
        public final ASTNode getNode() {
            return this.node;
        }

        @NotNull
        public final CharSequence getDestination() {
            return this.destination;
        }

        @Nullable
        public final CharSequence getTitle() {
            return this.title;
        }

        @NotNull
        public final ASTNode component1() {
            return this.node;
        }

        @NotNull
        public final CharSequence component2() {
            return this.destination;
        }

        @Nullable
        public final CharSequence component3() {
            return this.title;
        }

        @NotNull
        public final LinkInfo copy(@NotNull ASTNode node, @NotNull CharSequence destination, @Nullable CharSequence title) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            return new LinkInfo(node, destination, title);
        }

        public static /* synthetic */ LinkInfo copy$default(LinkInfo linkInfo, ASTNode aSTNode, CharSequence charSequence, CharSequence charSequence2, int n, Object object) {
            if ((n & 1) != 0) {
                aSTNode = linkInfo.node;
            }
            if ((n & 2) != 0) {
                charSequence = linkInfo.destination;
            }
            if ((n & 4) != 0) {
                charSequence2 = linkInfo.title;
            }
            return linkInfo.copy(aSTNode, charSequence, charSequence2);
        }

        @NotNull
        public String toString() {
            return "LinkInfo(node=" + this.node + ", destination=" + this.destination + ", title=" + this.title + ")";
        }

        public int hashCode() {
            int result = this.node.hashCode();
            result = result * 31 + this.destination.hashCode();
            result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LinkInfo)) {
                return false;
            }
            LinkInfo linkInfo = (LinkInfo)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)linkInfo.node)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.destination, (Object)linkInfo.destination)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.title, (Object)linkInfo.title);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo$Companion;", "", "<init>", "()V", "create", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "fileText", "", "jb-md"})
        @SourceDebugExtension(value={"SMAP\nLinkMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkMap.kt\norg/intellij/markdown/parser/LinkMap$LinkInfo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LinkInfo create(@NotNull ASTNode node, @NotNull String fileText) {
                CharSequence charSequence;
                StringSlice stringSlice;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
                CharSequence destination = Builder.normalizeDestination((CharSequence)ASTUtilKt.getTextInNode(node.childOfType(MarkdownElementTypes.LINK_DESTINATION), fileText), true);
                ASTNode aSTNode = node.findChildOfType(MarkdownElementTypes.LINK_TITLE);
                if (aSTNode != null && (stringSlice = ASTUtilKt.getTextInNode(aSTNode, fileText)) != null) {
                    StringSlice it = stringSlice;
                    boolean bl = false;
                    charSequence = Builder.normalizeTitle((CharSequence)it);
                } else {
                    charSequence = null;
                }
                CharSequence title = charSequence;
                return new LinkInfo(node, destination, title);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

