/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\f2\n\u0010\u000e\u001a\u00060\u0007R\u00020\bH\u0016J\u0014\u0010\u0011\u001a\u00020\u00102\n\u0010\u000e\u001a\u00060\u0007R\u00020\bH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u001c\u0010\u0014\u001a\u00020\u00152\n\u0010\u000e\u001a\u00060\u0007R\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/markdown/parser/markerblocks/impl/CodeBlockMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "<init>", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/LookaheadText$Position;)V", "allowsSubBlocks", "", "isInterestingOffset", "pos", "realInterestingOffset", "", "calcNextInterestingOffset", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultNodeType", "Lcom/intellij/psi/tree/IElementType;", "jb-md"})
@SourceDebugExtension(value={"SMAP\nCodeBlockMarkerBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeBlockMarkerBlock.kt\norg/intellij/markdown/parser/markerblocks/impl/CodeBlockMarkerBlock\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,93:1\n107#2,3:94\n111#2:98\n107#3:97\n*S KotlinDebug\n*F\n+ 1 CodeBlockMarkerBlock.kt\norg/intellij/markdown/parser/markerblocks/impl/CodeBlockMarkerBlock\n*L\n58#1:94,3\n58#1:98\n58#1:97\n*E\n"})
public final class CodeBlockMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final ProductionHolder productionHolder;
    private int realInterestingOffset;

    public CodeBlockMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull LookaheadText.Position startPosition) {
        Intrinsics.checkNotNullParameter((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startPosition.getOffset(), startPosition.getNextLineOrEofOffset()), MarkdownTokenTypes.CODE_LINE)));
        this.realInterestingOffset = -1;
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        LookaheadText.Position position;
        MarkdownConstraints nextConstraints;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
                if (pos.getOffset() < this.realInterestingOffset) {
                    return MarkerBlock.ProcessingResult.Companion.getCANCEL();
                }
                if (pos.getOffsetInCurrentLine() != -1) {
                    return MarkerBlock.ProcessingResult.Companion.getCANCEL();
                }
                Compat compat = Compat.INSTANCE;
                boolean condition$iv = pos.getOffsetInCurrentLine() == -1;
                boolean $i$f$assert = false;
                if (!condition$iv) {
                    boolean bl = false;
                    String string = "";
                    throw new MarkdownParsingException(string);
                }
                LookaheadText.Position position2 = MarkdownParserUtil.INSTANCE.findNonEmptyLineWithSameConstraints(this.getConstraints(), pos);
                if (position2 == null) {
                    return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
                }
                LookaheadText.Position nonemptyPos = position2;
                nextConstraints = MarkdownConstraintsKt.applyToNextLineAndAddModifiers(this.getConstraints(), nonemptyPos);
                LookaheadText.Position shifted = nonemptyPos.nextPosition(1 + MarkdownConstraintsKt.getCharsEaten(nextConstraints, nonemptyPos.getCurrentLine()));
                position = shifted;
                if (position == null) break block9;
                Integer n = shifted.charsToNonWhitespace();
                if ((position = position.nextPosition(n != null ? n : 0)) != null) break block10;
            }
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position nonWhitespace = position;
        if (!MarkdownParserUtil.INSTANCE.hasCodeBlockIndent(nonWhitespace, nextConstraints)) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        MarkdownConstraints nextLineConstraints = MarkdownConstraintsKt.applyToNextLineAndAddModifiers(this.getConstraints(), pos);
        IntRange nodeRange = new IntRange(pos.getOffset() + 1 + MarkdownConstraintsKt.getCharsEaten(nextLineConstraints, pos.getCurrentLine()), pos.getNextLineOrEofOffset());
        if (nodeRange.getLast() - nodeRange.getFirst() > 0) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(nodeRange, MarkdownTokenTypes.CODE_LINE)));
        }
        this.realInterestingOffset = pos.getNextLineOrEofOffset();
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.CODE_BLOCK;
    }
}

