/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.html.CommonDefsKt;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000e\u00a8\u0006\u0011"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserUtil;", "", "<init>", "()V", "isWhitespace", "", "info", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "lookup", "", "isPunctuation", "filterBlockquotes", "", "Lkotlin/ranges/IntRange;", "tokensCache", "textRange", "jb-md"})
public final class SequentialParserUtil {
    @NotNull
    public static final SequentialParserUtil INSTANCE = new SequentialParserUtil();

    private SequentialParserUtil() {
    }

    public final boolean isWhitespace(@NotNull TokensCache.Iterator info, int lookup) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return CommonDefsKt.isWhitespace(info.charLookup(lookup));
    }

    public final boolean isPunctuation(@NotNull TokensCache.Iterator info, int lookup) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return CommonDefsKt.isPunctuation(info.charLookup(lookup));
    }

    @NotNull
    public final List<IntRange> filterBlockquotes(@NotNull TokensCache tokensCache, @NotNull IntRange textRange) {
        Intrinsics.checkNotNullParameter((Object)tokensCache, (String)"tokensCache");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        ArrayList<IntRange> result = new ArrayList<IntRange>();
        int lastStart = textRange.getFirst();
        int R = textRange.getLast();
        int i = lastStart;
        int n = R - 1;
        if (i <= n) {
            while (true) {
                if (Intrinsics.areEqual((Object)new TokensCache.Iterator(tokensCache, i).getType(), (Object)MarkdownTokenTypes.BLOCK_QUOTE)) {
                    if (lastStart < i) {
                        result.add(new IntRange(lastStart, i - 1));
                    }
                    lastStart = i + 1;
                }
                if (i == n) break;
                ++i;
            }
        }
        if (lastStart < R) {
            result.add(new IntRange(lastStart, R));
        }
        return result;
    }
}

