package org.intellij.markdown.ast

import com.intellij.openapi.util.TextRange
import com.intellij.psi.tree.IElementType
import kala.collection.Seq
import org.intellij.markdown.ast.visitors.Visitor
import org.jetbrains.annotations.Debug.Renderer

@Renderer(text = "getType().toString()")
interface ASTNode {
  val type: IElementType
  val startOffset: Int
  val endOffset: Int
  val parent: ASTNode?
  val children: Seq<ASTNode>

  val textRange: TextRange
    get() = TextRange(startOffset, endOffset)

  fun childrenWithoutSurrounding(count: Int) =
    children.sliceView(count, children.size() - count)

  fun findChildOfType(type: IElementType): ASTNode? {
    return children.firstOrNull { it.type == type }
  }

  fun childOfType(type: IElementType): ASTNode {
    return children.first { it.type == type }
  }
}

fun ASTNode.accept(visitor: Visitor) {
  visitor.visitNode(this)
}

fun ASTNode.acceptChildren(visitor: Visitor) {
  for (child in children) {
    child.accept(visitor)
  }
}   
