package org.intellij.markdown.html

import java.net.URI
import java.net.URLEncoder

fun URI.resolveToStringSafe(str: String): String {
  return try {
    resolve(str).toString()
  } catch (e: Throwable) {
    str
  }
}

class BitSet(size: Int) : java.util.BitSet(size) {
  val size = size()
  override fun clear(index: Int) = set(index, false)
}

private const val PUNCTUATION_MASK: Int = (1 shl Character.DASH_PUNCTUATION.toInt()) or
  (1 shl Character.START_PUNCTUATION.toInt()) or
  (1 shl Character.END_PUNCTUATION.toInt()) or
  (1 shl Character.CONNECTOR_PUNCTUATION.toInt()) or
  (1 shl Character.OTHER_PUNCTUATION.toInt()) or
  (1 shl Character.INITIAL_QUOTE_PUNCTUATION.toInt()) or
  (1 shl Character.FINAL_QUOTE_PUNCTUATION.toInt()) or
  (1 shl Character.MATH_SYMBOL.toInt())

private fun isAsciiPunctuationFix(char: Char): Boolean {
  // the ones which are not covered by a more general check
  return "$^`".contains(char)
}

fun isWhitespace(char: Char): Boolean = char.isWhitespace()
fun isPunctuation(char: Char): Boolean =
  isAsciiPunctuationFix(char) || (PUNCTUATION_MASK shr Character.getType(char)) and 1 != 0

fun urlEncode(str: String) : String = URLEncoder.encode(str, Charsets.UTF_8)
