/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineHolderGeneratingProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.intellij.markdown.lexer.Compat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u000e\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/intellij/markdown/flavours/gfm/CheckedListItemGeneratingProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "<init>", "()V", "openTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "processNode", "getIsCheckedString", "SubParagraphGeneratingProvider", "jb-md"})
@SourceDebugExtension(value={"SMAP\nGFMGeneratingProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GFMGeneratingProviders.kt\norg/intellij/markdown/flavours/gfm/CheckedListItemGeneratingProvider\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,253:1\n107#2,3:254\n111#2:258\n107#2,3:259\n111#2:263\n107#3:257\n107#3:262\n*S KotlinDebug\n*F\n+ 1 GFMGeneratingProviders.kt\norg/intellij/markdown/flavours/gfm/CheckedListItemGeneratingProvider\n*L\n20#1:254,3\n20#1:258\n37#1:259,3\n37#1:263\n20#1:257\n37#1:262\n*E\n"})
public final class CheckedListItemGeneratingProvider
extends SimpleTagProvider {
    public CheckedListItemGeneratingProvider() {
        super("li");
    }

    @Override
    public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
    }

    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = node instanceof ListItemCompositeNode;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        ASTNode checkBoxElement = node.findChildOfType(GFMTokenTypes.CHECK_BOX);
        CharSequence inputHtml = null;
        CharSequence listItemClass = null;
        if (checkBoxElement != null) {
            listItemClass = "class=\"task-list-item\"";
            String checkedString = this.getIsCheckedString(checkBoxElement, text);
            inputHtml = "<input type=\"checkbox\" class=\"task-list-item-checkbox\"" + checkedString + " disabled />";
        } else {
            listItemClass = null;
            inputHtml = "";
        }
        CharSequence[] checkedString = new CharSequence[]{listItemClass};
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "li", checkedString, false, 8, null);
        ASTNode listNode = node.getParent();
        Compat bl = Compat.INSTANCE;
        boolean condition$iv2 = listNode instanceof ListCompositeNode;
        boolean $i$f$assert2 = false;
        if (!condition$iv2) {
            boolean bl2 = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        Intrinsics.checkNotNull((Object)listNode, (String)"null cannot be cast to non-null type org.intellij.markdown.ast.impl.ListCompositeNode");
        boolean isLoose = ((ListCompositeNode)listNode).getLoose();
        boolean flushedInput = false;
        Iterator iterator = node.getChildren().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ASTNode child = (ASTNode)iterator2.next();
            if (child instanceof LeafASTNode) continue;
            if (!flushedInput) {
                if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownElementTypes.PARAGRAPH)) {
                    SubParagraphGeneratingProvider subParagraphGeneratingProvider = new SubParagraphGeneratingProvider(isLoose, (String)inputHtml);
                    Intrinsics.checkNotNull((Object)child);
                    subParagraphGeneratingProvider.processNode(visitor, text, child);
                } else {
                    visitor.consumeHtml(inputHtml);
                    Intrinsics.checkNotNull((Object)child);
                    ASTNodeKt.accept(child, visitor);
                }
                flushedInput = true;
                continue;
            }
            Intrinsics.checkNotNull((Object)child);
            ASTNodeKt.accept(child, visitor);
        }
        this.closeTag(visitor, text, node);
    }

    private final String getIsCheckedString(ASTNode node, String text) {
        boolean bl;
        ASTNode aSTNode = node;
        if (aSTNode != null && (aSTNode = ASTUtilKt.getTextInNode(aSTNode, text)) != null) {
            ASTNode it = aSTNode;
            boolean bl2 = false;
            bl = it.length() > 1 && it.charAt(1) != ' ';
        } else {
            bl = false;
        }
        boolean isChecked = bl;
        String checkedString = isChecked ? " checked" : "";
        return checkedString;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fR\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fR\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/intellij/markdown/flavours/gfm/CheckedListItemGeneratingProvider$SubParagraphGeneratingProvider;", "Lorg/intellij/markdown/html/InlineHolderGeneratingProvider;", "wrapInParagraph", "", "inputHtml", "", "<init>", "(ZLjava/lang/String;)V", "getWrapInParagraph", "()Z", "getInputHtml", "()Ljava/lang/String;", "openTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "closeTag", "jb-md"})
    private static final class SubParagraphGeneratingProvider
    extends InlineHolderGeneratingProvider {
        private final boolean wrapInParagraph;
        @NotNull
        private final String inputHtml;

        public SubParagraphGeneratingProvider(boolean wrapInParagraph, @NotNull String inputHtml) {
            Intrinsics.checkNotNullParameter((Object)inputHtml, (String)"inputHtml");
            this.wrapInParagraph = wrapInParagraph;
            this.inputHtml = inputHtml;
        }

        public final boolean getWrapInParagraph() {
            return this.wrapInParagraph;
        }

        @NotNull
        public final String getInputHtml() {
            return this.inputHtml;
        }

        @Override
        public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.wrapInParagraph) {
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "p", new CharSequence[0], false, 8, null);
            }
            visitor.consumeHtml(this.inputHtml);
        }

        @Override
        public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.wrapInParagraph) {
                visitor.consumeTagClose("p");
            }
        }
    }
}

