/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import com.intellij.psi.tree.IElementType;
import java.net.URI;
import java.util.Map;
import kala.collection.Seq;
import kala.text.StringSlice;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.CheckedListItemGeneratingProvider;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMMarkerProcessor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.MathGeneratingProvider;
import org.intellij.markdown.flavours.gfm.StrikeThroughDelimiterParser;
import org.intellij.markdown.flavours.gfm.TableAwareCodeSpanGeneratingProvider;
import org.intellij.markdown.flavours.gfm.TablesGeneratingProvider;
import org.intellij.markdown.flavours.gfm.lexer._GFMLexer;
import org.intellij.markdown.html.EqualDelimiterTrimmingInlineTagProvider;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.TrimmingInlineHolderProvider;
import org.intellij.markdown.html.XssSafeLinksKt;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.EmphasisLikeParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongDelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.MathParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J&\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkFlavourDescriptor;", "useSafeLinks", "", "absolutizeAnchorLinks", "makeHttpsAutoLinks", "<init>", "(ZZZ)V", "markerProcessorFactory", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "getMarkerProcessorFactory", "()Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "createInlinesLexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "createHtmlGeneratingProviders", "", "Lcom/intellij/psi/tree/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "jb-md"})
public class GFMFlavourDescriptor
extends CommonMarkFlavourDescriptor {
    private final boolean makeHttpsAutoLinks;
    @NotNull
    private final MarkerProcessorFactory markerProcessorFactory;
    @NotNull
    private final SequentialParserManager sequentialParserManager;

    public GFMFlavourDescriptor(boolean useSafeLinks, boolean absolutizeAnchorLinks, boolean makeHttpsAutoLinks) {
        super(useSafeLinks, absolutizeAnchorLinks);
        this.makeHttpsAutoLinks = makeHttpsAutoLinks;
        this.markerProcessorFactory = GFMMarkerProcessor.Factory.INSTANCE;
        this.sequentialParserManager = new SequentialParserManager(){

            public Seq<SequentialParser> getParserSequence() {
                Object[] objectArray = new SequentialParser[7];
                Seq seq = Seq.of((Object)MarkdownTokenTypes.AUTOLINK, (Object)GFMTokenTypes.GFM_AUTOLINK);
                Intrinsics.checkNotNullExpressionValue((Object)seq, (String)"of(...)");
                objectArray[0] = new AutolinkParser((Seq<IElementType>)seq);
                objectArray[1] = new BacktickParser();
                objectArray[2] = new MathParser();
                objectArray[3] = new ImageParser();
                objectArray[4] = new InlineLinkParser();
                objectArray[5] = new ReferenceLinkParser();
                DelimiterParser[] delimiterParserArray = new DelimiterParser[]{new EmphStrongDelimiterParser(), new StrikeThroughDelimiterParser()};
                objectArray[6] = new EmphasisLikeParser(delimiterParserArray);
                Seq seq2 = Seq.of((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)seq2, (String)"of(...)");
                return seq2;
            }
        };
    }

    public /* synthetic */ GFMFlavourDescriptor(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        this(bl, bl2, bl3);
    }

    @Override
    @NotNull
    public MarkerProcessorFactory getMarkerProcessorFactory() {
        return this.markerProcessorFactory;
    }

    @Override
    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return new MarkdownLexer(new _GFMLexer());
    }

    @Override
    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    @Override
    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        Pair[] pairArray = new Pair[8];
        IElementType iElementType = GFMTokenTypes.TILDE;
        pairArray[0] = TuplesKt.to((Object)GFMElementTypes.STRIKETHROUGH, (Object)new EqualDelimiterTrimmingInlineTagProvider(iElementType){

            public void openTag(HtmlGenerator.HtmlGeneratingVisitor visitor, String text, ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                CharSequence[] charSequenceArray = new CharSequence[]{"class=\"user-del\""};
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, this.getTagName(), charSequenceArray, false, 8, null);
            }
        });
        pairArray[1] = TuplesKt.to((Object)GFMElementTypes.TABLE, (Object)new TablesGeneratingProvider());
        pairArray[2] = TuplesKt.to((Object)GFMTokenTypes.CELL, (Object)new TrimmingInlineHolderProvider());
        pairArray[3] = TuplesKt.to((Object)MarkdownElementTypes.CODE_SPAN, (Object)new TableAwareCodeSpanGeneratingProvider());
        pairArray[4] = TuplesKt.to((Object)GFMTokenTypes.GFM_AUTOLINK, (Object)new GeneratingProvider(this){
            final /* synthetic */ GFMFlavourDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public void processNode(HtmlGenerator.HtmlGeneratingVisitor visitor, String text, ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                StringSlice linkText = ASTUtilKt.getTextInNode(node, text);
                IElementType[] iElementTypeArray = new IElementType[]{MarkdownElementTypes.LINK_LABEL, MarkdownElementTypes.LINK_TEXT};
                if (ASTUtilKt.getParentOfType(node, iElementTypeArray) != null) {
                    visitor.consumeHtml((CharSequence)linkText);
                    return;
                }
                StringSlice absoluteLink = this.hasSchema((CharSequence)linkText) ? linkText : (GFMFlavourDescriptor.access$getMakeHttpsAutoLinks$p(this.this$0) ? "https://" + linkText : "http://" + linkText);
                String link = EntityConverter.INSTANCE.replaceEntities((CharSequence)linkText, true, false);
                CharSequence[] charSequenceArray = LinkMap.Builder.normalizeDestination((CharSequence)absoluteLink, false);
                GFMFlavourDescriptor gFMFlavourDescriptor = this.this$0;
                CharSequence[] it = charSequenceArray;
                boolean bl = false;
                CharSequence[] normalizedDestination = GFMFlavourDescriptor.access$getUseSafeLinks(gFMFlavourDescriptor) ? XssSafeLinksKt.makeXssSafeDestination((CharSequence)it) : it;
                charSequenceArray = new CharSequence[]{"href=\"" + (CharSequence)normalizedDestination + "\""};
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "a", charSequenceArray, false, 8, null);
                visitor.consumeHtml(link);
                visitor.consumeTagClose("a");
            }

            private final boolean hasSchema(CharSequence linkText) {
                int index = StringsKt.indexOf$default((CharSequence)linkText, (char)'/', (int)0, (boolean)false, (int)6, null);
                if (index == -1) {
                    return false;
                }
                return index != 0 && index + 1 < linkText.length() && linkText.charAt(index - 1) == ':' && linkText.charAt(index + 1) == '/';
            }
        });
        pairArray[5] = TuplesKt.to((Object)MarkdownElementTypes.LIST_ITEM, (Object)new CheckedListItemGeneratingProvider());
        pairArray[6] = TuplesKt.to((Object)GFMElementTypes.INLINE_MATH, (Object)new MathGeneratingProvider(true));
        pairArray[7] = TuplesKt.to((Object)GFMElementTypes.BLOCK_MATH, (Object)new MathGeneratingProvider(false, 1, null));
        return MapsKt.plus(super.createHtmlGeneratingProviders(linkMap, baseURI), (Map)MapsKt.hashMapOf((Pair[])pairArray));
    }

    public GFMFlavourDescriptor() {
        this(false, false, false, 7, null);
    }

    public static final /* synthetic */ boolean access$getMakeHttpsAutoLinks$p(GFMFlavourDescriptor $this) {
        return $this.makeHttpsAutoLinks;
    }

    public static final /* synthetic */ boolean access$getUseSafeLinks(GFMFlavourDescriptor $this) {
        return $this.getUseSafeLinks();
    }
}

