/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kala.collection.immutable.ImmutableSeq;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.lexer.Compat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J:\u0010\r\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "<init>", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "populateRow", "cellName", "alignmentInfo", "", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "rowNumber", "", "getAlignmentInfo", "Alignment", "Companion", "jb-md"})
@SourceDebugExtension(value={"SMAP\nGFMGeneratingProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GFMGeneratingProviders.kt\norg/intellij/markdown/flavours/gfm/TablesGeneratingProvider\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n107#2,3:254\n111#2:258\n107#3:257\n1#4:259\n*S KotlinDebug\n*F\n+ 1 GFMGeneratingProviders.kt\norg/intellij/markdown/flavours/gfm/TablesGeneratingProvider\n*L\n157#1:254,3\n157#1:258\n157#1:257\n*E\n"})
public final class TablesGeneratingProvider
implements GeneratingProvider {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Alignment DEFAULT_ALIGNMENT;
    @NotNull
    private static final Regex SPLIT_REGEX;

    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = Intrinsics.areEqual((Object)node.getType(), (Object)GFMElementTypes.TABLE);
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        List<Alignment> alignmentInfo = this.getAlignmentInfo(text, node);
        int rowsPopulated = 0;
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "table", new CharSequence[0], false, 8, null);
        Iterator iterator = node.getChildren().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ASTNode child = (ASTNode)iterator2.next();
            if (Intrinsics.areEqual((Object)child.getType(), (Object)GFMElementTypes.HEADER)) {
                visitor.consumeHtml("<thead>");
                Intrinsics.checkNotNull((Object)child);
                this.populateRow(visitor, child, "th", alignmentInfo, -1);
                visitor.consumeHtml("</thead>");
                continue;
            }
            if (!Intrinsics.areEqual((Object)child.getType(), (Object)GFMElementTypes.ROW)) continue;
            if (rowsPopulated == 0) {
                visitor.consumeHtml("<tbody>");
            }
            Intrinsics.checkNotNull((Object)child);
            this.populateRow(visitor, child, "td", alignmentInfo, ++rowsPopulated);
        }
        if (rowsPopulated > 0) {
            visitor.consumeHtml("</tbody>");
        }
        visitor.consumeTagClose("table");
    }

    private final void populateRow(HtmlGenerator.HtmlGeneratingVisitor visitor, ASTNode node, String cellName, List<? extends Alignment> alignmentInfo, int rowNumber) {
        String parityAttribute = rowNumber > 0 && rowNumber % 2 == 0 ? "class=\"intellij-row-even\"" : null;
        CharSequence[] charSequenceArray = new CharSequence[]{parityAttribute};
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "tr", charSequenceArray, false, 8, null);
        ImmutableSeq immutableSeq = node.getChildren().filter(arg_0 -> TablesGeneratingProvider.populateRow$lambda$1(TablesGeneratingProvider::populateRow$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)immutableSeq, (String)"filter(...)");
        for (IndexedValue child : CollectionsKt.withIndex((Iterable)((Iterable)immutableSeq))) {
            if (child.getIndex() >= alignmentInfo.size()) {
                throw new IllegalStateException("Too many cells in a row! Should check parser.");
            }
            Alignment alignment = alignmentInfo.get(child.getIndex());
            String alignmentAttribute = alignment.isDefault() ? null : "align=\"" + alignment.getHtmlName() + "\"";
            Object object = child.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
            CharSequence[] charSequenceArray2 = new CharSequence[]{alignmentAttribute};
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, (ASTNode)object, cellName, charSequenceArray2, false, 8, null);
            Object object2 = child.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-value>(...)");
            visitor.visitNode((ASTNode)object2);
            visitor.consumeTagClose(cellName);
        }
        int n = alignmentInfo.size();
        for (int i = node.getChildren().count(arg_0 -> TablesGeneratingProvider.populateRow$lambda$3(TablesGeneratingProvider::populateRow$lambda$2, arg_0)); i < n; ++i) {
            visitor.consumeHtml("<td></td>");
        }
        visitor.consumeTagClose("tr");
    }

    private final List<Alignment> getAlignmentInfo(String text, ASTNode node) {
        ASTNode aSTNode = node.findChildOfType(GFMTokenTypes.TABLE_SEPARATOR);
        if (aSTNode == null) {
            throw new IllegalStateException("Could not find table separator");
        }
        ASTNode separatorRow = aSTNode;
        ArrayList<Alignment> result = new ArrayList<Alignment>();
        List cells = Regex.split$default((Regex)SPLIT_REGEX, (CharSequence)((CharSequence)ASTUtilKt.getTextInNode(separatorRow, text)), (int)0, (int)2, null);
        int n = ((Collection)cells).size();
        for (int i = 0; i < n; ++i) {
            String cell = (String)cells.get(i);
            if (StringsKt.isBlank((CharSequence)cell)) {
                boolean bl = 1 <= i ? i <= CollectionsKt.getLastIndex((List)cells) - 1 : false;
                if (!bl) continue;
            }
            String trimmed = ((Object)StringsKt.trim((CharSequence)cell)).toString();
            boolean starts = StringsKt.startsWith$default((CharSequence)trimmed, (char)':', (boolean)false, (int)2, null);
            boolean ends = StringsKt.endsWith$default((CharSequence)trimmed, (char)':', (boolean)false, (int)2, null);
            result.add(starts && ends ? Alignment.CENTER : (starts ? Alignment.LEFT : (ends ? Alignment.RIGHT : DEFAULT_ALIGNMENT)));
        }
        return result;
    }

    private static final boolean populateRow$lambda$0(ASTNode it) {
        return Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.CELL);
    }

    private static final boolean populateRow$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean populateRow$lambda$2(ASTNode it) {
        return Intrinsics.areEqual((Object)it.getType(), (Object)GFMTokenTypes.CELL);
    }

    private static final boolean populateRow$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object v0;
        block2: {
            Companion = new Companion(null);
            Iterable iterable = (Iterable)Alignment.getEntries();
            for (Object t : iterable) {
                Alignment it = (Alignment)((Object)t);
                boolean bl = false;
                if (!it.isDefault()) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Alignment alignment = v0;
        if (alignment == null) {
            throw new IllegalStateException("Must be default alignment");
        }
        DEFAULT_ALIGNMENT = alignment;
        SPLIT_REGEX = new Regex("\\|");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "", "htmlName", "", "isDefault", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getHtmlName", "()Ljava/lang/String;", "()Z", "LEFT", "CENTER", "RIGHT", "jb-md"})
    public static final class Alignment
    extends Enum<Alignment> {
        @NotNull
        private final String htmlName;
        private final boolean isDefault;
        public static final /* enum */ Alignment LEFT = new Alignment("left", true);
        public static final /* enum */ Alignment CENTER = new Alignment("center", false);
        public static final /* enum */ Alignment RIGHT = new Alignment("right", false);
        private static final /* synthetic */ Alignment[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Alignment(String htmlName, boolean isDefault) {
            this.htmlName = htmlName;
            this.isDefault = isDefault;
        }

        @NotNull
        public final String getHtmlName() {
            return this.htmlName;
        }

        public final boolean isDefault() {
            return this.isDefault;
        }

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }

        public static Alignment valueOf(String value) {
            return Enum.valueOf(Alignment.class, value);
        }

        @NotNull
        public static EnumEntries<Alignment> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = alignmentArray = new Alignment[]{Alignment.LEFT, Alignment.CENTER, Alignment.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Companion;", "", "<init>", "()V", "DEFAULT_ALIGNMENT", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "getDEFAULT_ALIGNMENT", "()Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "SPLIT_REGEX", "Lkotlin/text/Regex;", "getSPLIT_REGEX", "()Lkotlin/text/Regex;", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Alignment getDEFAULT_ALIGNMENT() {
            return DEFAULT_ALIGNMENT;
        }

        @NotNull
        public final Regex getSPLIT_REGEX() {
            return SPLIT_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

