/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm.table;

import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kala.text.StringSlice;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B+\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\u0002\u001a\u00060\u0003R\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0006H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0014\u0010\u0017\u001a\u00020\n2\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "tableColumnsNumber", "", "<init>", "(Lorg/intellij/markdown/parser/LookaheadText$Position;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;I)V", "currentLine", "getCurrentLine", "()I", "setCurrentLine", "(I)V", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "calcNextInterestingOffset", "getDefaultNodeType", "Lcom/intellij/psi/tree/IElementType;", "isInterestingOffset", "", "allowsSubBlocks", "fillCells", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "isProbablyTableLine", "line", "", "Companion", "jb-md"})
public final class GitHubTableMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProductionHolder productionHolder;
    private final int tableColumnsNumber;
    private int currentLine;

    public GitHubTableMarkerBlock(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder, int tableColumnsNumber) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        super(constraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.tableColumnsNumber = tableColumnsNumber;
        this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset(), pos.getNextLineOrEofOffset()), GFMElementTypes.HEADER)));
        this.productionHolder.addProduction((Collection<SequentialParser.Node>)this.fillCells(pos));
    }

    public final int getCurrentLine() {
        return this.currentLine;
    }

    public final void setCurrentLine(int n) {
        this.currentLine = n;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
        int n = this.currentLine;
        this.currentLine = n + 1;
        if (this.currentLine == 1) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset() + 1, pos.getNextLineOrEofOffset()), GFMTokenTypes.TABLE_SEPARATOR)));
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        String line = pos.getCurrentLine();
        if (!this.isProbablyTableLine(line)) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        List<SequentialParser.Node> cellsAndSeps = this.fillCells(pos);
        if (cellsAndSeps.isEmpty()) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        this.productionHolder.addProduction(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(((SequentialParser.Node)CollectionsKt.first(cellsAndSeps)).getRange().getFirst(), ((SequentialParser.Node)CollectionsKt.last(cellsAndSeps)).getRange().getLast()), GFMElementTypes.ROW)), (Iterable)cellsAndSeps));
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return GFMElementTypes.TABLE;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getOffsetInCurrentLine() == -1;
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    private final List<SequentialParser.Node> fillCells(LookaheadText.Position pos) {
        ArrayList<SequentialParser.Node> result = new ArrayList<SequentialParser.Node>();
        int offset = pos.getOffset();
        if (pos.getOffsetInCurrentLine() == -1) {
            offset += 1 + MarkdownConstraintsKt.getCharsEaten(this.getConstraints(), pos.getCurrentLine());
        }
        StringSlice line = MarkdownConstraintsKt.eatItselfFromString(this.getConstraints(), pos.getCurrentLine());
        List<StringSlice> cells = Companion.splitByPipes(line);
        int cellNodesAdded = 0;
        int n = ((Collection)cells).size();
        for (int i = 0; i < n; ++i) {
            StringSlice cell;
            block7: {
                block6: {
                    cell = cells.get(i);
                    if (!StringsKt.isBlank((CharSequence)((CharSequence)cell))) break block6;
                    boolean bl = 1 <= i ? i <= CollectionsKt.getLastIndex(cells) - 1 : false;
                    if (!bl) break block7;
                }
                result.add(new SequentialParser.Node(new IntRange(offset, offset + cell.length()), GFMTokenTypes.CELL));
                ++cellNodesAdded;
            }
            offset += cell.length();
            if (i < CollectionsKt.getLastIndex(cells)) {
                result.add(new SequentialParser.Node(new IntRange(offset, offset + 1), GFMTokenTypes.TABLE_SEPARATOR));
            }
            ++offset;
            if (cellNodesAdded < this.tableColumnsNumber) continue;
            if (offset >= pos.getNextLineOrEofOffset()) break;
            result.add(new SequentialParser.Node(new IntRange(offset, pos.getNextLineOrEofOffset()), GFMTokenTypes.TABLE_SEPARATOR));
            break;
        }
        return result;
    }

    private final boolean isProbablyTableLine(CharSequence line) {
        return StringsKt.contains$default((CharSequence)line, (char)'|', (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerBlock$Companion;", "", "<init>", "()V", "splitByPipes", "", "Lkala/text/StringSlice;", "text", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<StringSlice> splitByPipes(@NotNull StringSlice text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            ArrayList<StringSlice> result = new ArrayList<StringSlice>();
            int startIndex = 0;
            int n = ((CharSequence)text).length();
            for (int index = 0; index < n; ++index) {
                StringSlice substring;
                char charBefore;
                char c = text.charAt(index);
                if (c != '|' || (charBefore = text.charAt(RangesKt.coerceAtLeast((int)(index - 1), (int)0))) == '\\') continue;
                Intrinsics.checkNotNullExpressionValue((Object)text.substring(startIndex, index), (String)"substring(...)");
                result.add(substring);
                startIndex = index + 1;
            }
            result.add(text.substring(startIndex));
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

