/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineLinkGeneratingProvider;
import org.intellij.markdown.html.LinkGeneratingProvider;
import org.intellij.markdown.html.ReferenceLinksGeneratingProvider;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J,\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/intellij/markdown/html/ImageGeneratingProvider;", "Lorg/intellij/markdown/html/LinkGeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "<init>", "(Lorg/intellij/markdown/parser/LinkMap;Ljava/net/URI;)V", "referenceLinkProvider", "Lorg/intellij/markdown/html/ReferenceLinksGeneratingProvider;", "getReferenceLinkProvider", "()Lorg/intellij/markdown/html/ReferenceLinksGeneratingProvider;", "inlineLinkProvider", "Lorg/intellij/markdown/html/InlineLinkGeneratingProvider;", "getInlineLinkProvider", "()Lorg/intellij/markdown/html/InlineLinkGeneratingProvider;", "getRenderInfo", "Lorg/intellij/markdown/html/LinkGeneratingProvider$RenderInfo;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "renderLink", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "info", "getPlainTextFrom", "", "Companion", "jb-md"})
@SourceDebugExtension(value={"SMAP\nGeneratingProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneratingProviders.kt\norg/intellij/markdown/html/ImageGeneratingProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n1#2:338\n*E\n"})
public class ImageGeneratingProvider
extends LinkGeneratingProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReferenceLinksGeneratingProvider referenceLinkProvider;
    @NotNull
    private final InlineLinkGeneratingProvider inlineLinkProvider;
    @NotNull
    private static final Regex REGEX = new Regex("[^a-zA-Z0-9 ]");

    public ImageGeneratingProvider(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        super(baseURI, false, 2, null);
        this.referenceLinkProvider = new ReferenceLinksGeneratingProvider(linkMap, baseURI, false, 4, null);
        this.inlineLinkProvider = new InlineLinkGeneratingProvider(baseURI, false, 2, null);
    }

    @NotNull
    protected final ReferenceLinksGeneratingProvider getReferenceLinkProvider() {
        return this.referenceLinkProvider;
    }

    @NotNull
    protected final InlineLinkGeneratingProvider getInlineLinkProvider() {
        return this.inlineLinkProvider;
    }

    @Override
    @Nullable
    public LinkGeneratingProvider.RenderInfo getRenderInfo(@NotNull String text, @NotNull ASTNode node) {
        ASTNode aSTNode;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode aSTNode2 = node.findChildOfType(MarkdownElementTypes.INLINE_LINK);
        if (aSTNode2 != null) {
            ASTNode linkNode = aSTNode2;
            boolean bl = false;
            return this.inlineLinkProvider.getRenderInfo(text, linkNode);
        }
        ASTNode aSTNode3 = node.findChildOfType(MarkdownElementTypes.FULL_REFERENCE_LINK);
        if (aSTNode3 == null) {
            aSTNode3 = node.findChildOfType(MarkdownElementTypes.SHORT_REFERENCE_LINK);
        }
        if ((aSTNode = aSTNode3) != null) {
            ASTNode linkNode = aSTNode;
            boolean bl = false;
            return this.referenceLinkProvider.getRenderInfo(text, linkNode);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renderLink(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node, @NotNull LinkGeneratingProvider.RenderInfo info) {
        String string;
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor = visitor;
        ASTNode aSTNode = node;
        CharSequence charSequence = "img";
        CharSequence[] charSequenceArray = new CharSequence[3];
        charSequenceArray[0] = "src=\"" + this.makeAbsoluteUrl(info.getDestination()) + "\"";
        charSequenceArray[1] = "alt=\"" + this.getPlainTextFrom(info.getLabel(), text) + "\"";
        CharSequence[] charSequenceArray2 = charSequenceArray;
        int n = 2;
        CharSequence charSequence2 = info.getTitle();
        if (charSequence2 != null) {
            void it;
            CharSequence charSequence3 = charSequence2;
            int n2 = n;
            CharSequence[] charSequenceArray3 = charSequenceArray2;
            CharSequence charSequence4 = charSequence;
            ASTNode aSTNode2 = aSTNode;
            HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor2 = htmlGeneratingVisitor;
            boolean bl = false;
            String string2 = "title=\"" + (CharSequence)it + "\"";
            htmlGeneratingVisitor = htmlGeneratingVisitor2;
            aSTNode = aSTNode2;
            charSequence = charSequence4;
            charSequenceArray2 = charSequenceArray3;
            n = n2;
            string = string2;
        } else {
            string = null;
        }
        charSequenceArray2[n] = string;
        htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray, true);
    }

    private final CharSequence getPlainTextFrom(ASTNode node, String text) {
        return REGEX.replace((CharSequence)ASTUtilKt.getTextInNode(node, text), "");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/markdown/html/ImageGeneratingProvider$Companion;", "", "<init>", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

