package org.intellij.markdown

import com.intellij.lang.Language
import com.intellij.psi.tree.IElementType

object MarkdownLanguage : Language("Markdown", "text/x-markdown") {
  override fun getDisplayName() = "Markdown"
}

open class MarkdownElementType(name: String, val isToken: Boolean = false)
  : IElementType(name, MarkdownLanguage) {

  override fun toString(): String {
    return "Markdown:" + super.toString()
  }
}
