/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kala.collection.Seq;
import kala.collection.mutable.MutableArrayList;
import kala.collection.mutable.MutableList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.ExperimentalApi;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.CancellationToken;
import org.intellij.markdown.parser.TreeBuilder;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0014J(\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J6\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/intellij/markdown/parser/InlineBuilder;", "Lorg/intellij/markdown/parser/TreeBuilder;", "nodeBuilder", "Lorg/intellij/markdown/ast/ASTNodeBuilder;", "tokensCache", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "cancellationToken", "Lorg/intellij/markdown/parser/CancellationToken;", "<init>", "(Lorg/intellij/markdown/ast/ASTNodeBuilder;Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;Lorg/intellij/markdown/parser/CancellationToken;)V", "(Lorg/intellij/markdown/ast/ASTNodeBuilder;Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;)V", "currentTokenPosition", "", "flushEverythingBeforeEvent", "", "event", "Lorg/intellij/markdown/parser/TreeBuilder$MyEvent;", "currentNodeChildren", "", "Lorg/intellij/markdown/parser/TreeBuilder$MyASTNodeWrapper;", "flushOneTokenToTree", "createASTNodeOnClosingEvent", "", "isTopmostNode", "", "addRawTokens", "childrenWithWhitespaces", "Lkala/collection/mutable/MutableList;", "Lorg/intellij/markdown/ast/ASTNode;", "from", "dx", "exitOffset", "jb-md"})
@SourceDebugExtension(value={"SMAP\nInlineBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineBuilder.kt\norg/intellij/markdown/parser/InlineBuilder\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,88:1\n107#2,3:89\n111#2:93\n107#3:92\n*S KotlinDebug\n*F\n+ 1 InlineBuilder.kt\norg/intellij/markdown/parser/InlineBuilder\n*L\n35#1:89,3\n35#1:93\n35#1:92\n*E\n"})
public final class InlineBuilder
extends TreeBuilder {
    @NotNull
    private final TokensCache tokensCache;
    private int currentTokenPosition;

    @ExperimentalApi
    public InlineBuilder(@NotNull ASTNodeBuilder nodeBuilder, @NotNull TokensCache tokensCache, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter((Object)nodeBuilder, (String)"nodeBuilder");
        Intrinsics.checkNotNullParameter((Object)tokensCache, (String)"tokensCache");
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        super(nodeBuilder, cancellationToken);
        this.tokensCache = tokensCache;
        this.currentTokenPosition = -1;
    }

    public InlineBuilder(@NotNull ASTNodeBuilder nodeBuilder, @NotNull TokensCache tokensCache) {
        Intrinsics.checkNotNullParameter((Object)nodeBuilder, (String)"nodeBuilder");
        Intrinsics.checkNotNullParameter((Object)tokensCache, (String)"tokensCache");
        this(nodeBuilder, tokensCache, CancellationToken.NonCancellable.INSTANCE);
    }

    @Override
    protected void flushEverythingBeforeEvent(@NotNull TreeBuilder.MyEvent event, @Nullable List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.currentTokenPosition == -1) {
            this.currentTokenPosition = event.getPosition();
        }
        while (this.currentTokenPosition < event.getPosition()) {
            this.flushOneTokenToTree(this.tokensCache, currentNodeChildren, this.currentTokenPosition);
            int n = this.currentTokenPosition;
            this.currentTokenPosition = n + 1;
        }
    }

    private final void flushOneTokenToTree(TokensCache tokensCache, List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren, int currentTokenPosition) {
        TokensCache.Iterator iterator = new TokensCache.Iterator(tokensCache, currentTokenPosition);
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = iterator.getType() != null;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        ASTNodeBuilder aSTNodeBuilder = this.getNodeBuilder();
        IElementType iElementType = iterator.getType();
        Intrinsics.checkNotNull((Object)iElementType);
        Seq<ASTNode> nodes = aSTNodeBuilder.createLeafNodes(iElementType, iterator.getStart(), iterator.getEnd());
        Iterator iterator2 = nodes.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ASTNode node = (ASTNode)iterator3.next();
            List<TreeBuilder.MyASTNodeWrapper> list = currentNodeChildren;
            if (list == null) continue;
            Intrinsics.checkNotNull((Object)node);
            list.add(new TreeBuilder.MyASTNodeWrapper(node, iterator.getIndex(), iterator.getIndex() + 1));
        }
    }

    @Override
    @NotNull
    protected TreeBuilder.MyASTNodeWrapper createASTNodeOnClosingEvent(@NotNull TreeBuilder.MyEvent event, @NotNull List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren, boolean isTopmostNode) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(currentNodeChildren, (String)"currentNodeChildren");
        ASTNode newNode = null;
        IElementType type = event.getInfo().getType();
        int startTokenId = event.getInfo().getRange().getFirst();
        int endTokenId = event.getInfo().getRange().getLast();
        MutableArrayList childrenWithWhitespaces = new MutableArrayList(currentNodeChildren.size());
        if (isTopmostNode) {
            this.addRawTokens(this.tokensCache, (MutableList<ASTNode>)((MutableList)childrenWithWhitespaces), startTokenId, -1, -1);
        }
        int n = currentNodeChildren.size();
        for (int index = 1; index < n; ++index) {
            TreeBuilder.MyASTNodeWrapper prev = currentNodeChildren.get(index - 1);
            TreeBuilder.MyASTNodeWrapper next = currentNodeChildren.get(index);
            childrenWithWhitespaces.append((Object)prev.getAstNode());
            this.addRawTokens(this.tokensCache, (MutableList<ASTNode>)((MutableList)childrenWithWhitespaces), prev.getEndTokenIndex() - 1, 1, new TokensCache.Iterator(this.tokensCache, next.getStartTokenIndex()).getStart());
        }
        if (!((Collection)currentNodeChildren).isEmpty()) {
            childrenWithWhitespaces.append((Object)((TreeBuilder.MyASTNodeWrapper)CollectionsKt.last(currentNodeChildren)).getAstNode());
        }
        if (isTopmostNode) {
            this.addRawTokens(this.tokensCache, (MutableList<ASTNode>)((MutableList)childrenWithWhitespaces), endTokenId - 1, 1, new TokensCache.Iterator(this.tokensCache, endTokenId).getStart());
        }
        newNode = this.getNodeBuilder().createCompositeNode(type, (Seq<ASTNode>)((Seq)childrenWithWhitespaces));
        return new TreeBuilder.MyASTNodeWrapper(newNode, startTokenId, endTokenId);
    }

    private final void addRawTokens(TokensCache tokensCache, MutableList<ASTNode> childrenWithWhitespaces, int from, int dx, int exitOffset) {
        TokensCache.Iterator iterator = new TokensCache.Iterator(tokensCache, from);
        int rawIdx = 0;
        while (iterator.rawLookup(rawIdx + dx) != null && iterator.rawStart(rawIdx + dx) != exitOffset) {
            rawIdx += dx;
        }
        while (rawIdx != 0) {
            IElementType rawType;
            Intrinsics.checkNotNull((Object)iterator.rawLookup(rawIdx));
            childrenWithWhitespaces.appendAll((Iterable)this.getNodeBuilder().createLeafNodes(rawType, iterator.rawStart(rawIdx), iterator.rawStart(rawIdx + 1)));
            rawIdx -= dx;
        }
    }
}

