/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.ParagraphMarkerBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001=B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001c0\rH$J\u0014\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060$R\u00020%H$J$\u0010&\u001a\u00020\"2\n\u0010#\u001a\u00060$R\u00020%2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H$J\"\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010#\u001a\u00060$R\u00020%2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010.\u001a\b\u0018\u00010$R\u00020%2\n\u0010#\u001a\u00060$R\u00020%J\u0014\u0010/\u001a\u00020)2\n\u0010#\u001a\u00060$R\u00020%H\u0002J\u000e\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020\u000eJ\u0006\u00102\u001a\u00020\"J\u0014\u00103\u001a\u00020,2\n\u0010#\u001a\u00060$R\u00020%H\u0002J \u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u000208H\u0002J\u0018\u00109\u001a\u00020\"2\u0006\u00105\u001a\u00020)2\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00028\u0000X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR#\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001c0\r\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u0010R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010*\u001a\u0018\u0012\b\u0012\u00060$R\u00020%\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/intellij/markdown/parser/MarkerProcessor;", "T", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "startConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "<init>", "(Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "getStartConstraints", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "NO_BLOCKS", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "getNO_BLOCKS", "()Ljava/util/List;", "markersStack", "", "getMarkersStack", "topBlockConstraints", "getTopBlockConstraints", "setTopBlockConstraints", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "stateInfo", "getStateInfo", "()Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "initMarkerBlockProviders", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "markerBlockProviders", "getMarkerBlockProviders$annotations", "()V", "getMarkerBlockProviders", "updateStateInfo", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "populateConstraintsTokens", "constraints", "nextInterestingPosForExistingMarkers", "", "interruptsParagraph", "Lkotlin/Function2;", "", "createNewMarkerBlocks", "processPosition", "calculateNextPosForExistingMarkers", "addNewMarkerBlock", "newMarkerBlock", "flushMarkers", "processMarkers", "applyProcessingResult", "index", "markerBlock", "processingResult", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "closeChildren", "childrenAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "relaxTopConstraints", "StateInfo", "jb-md"})
@SourceDebugExtension(value={"SMAP\nMarkerProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerProcessor.kt\norg/intellij/markdown/parser/MarkerProcessor\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,210:1\n107#2,3:211\n111#2:215\n108#2,4:216\n107#3:214\n*S KotlinDebug\n*F\n+ 1 MarkerProcessor.kt\norg/intellij/markdown/parser/MarkerProcessor\n*L\n52#1:211,3\n52#1:215\n167#1:216,4\n52#1:214\n*E\n"})
public abstract class MarkerProcessor<T extends StateInfo> {
    @NotNull
    private final ProductionHolder productionHolder;
    @NotNull
    private final MarkdownConstraints startConstraints;
    @NotNull
    private final List<MarkerBlock> NO_BLOCKS;
    @NotNull
    private final List<MarkerBlock> markersStack;
    @NotNull
    private MarkdownConstraints topBlockConstraints;
    @NotNull
    private final List<MarkerBlockProvider<T>> markerBlockProviders;
    private int nextInterestingPosForExistingMarkers;
    @NotNull
    private final Function2<LookaheadText.Position, MarkdownConstraints, Boolean> interruptsParagraph;

    public MarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull MarkdownConstraints startConstraints) {
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)startConstraints, (String)"startConstraints");
        this.productionHolder = productionHolder;
        this.startConstraints = startConstraints;
        this.NO_BLOCKS = CollectionsKt.emptyList();
        this.markersStack = new ArrayList();
        this.topBlockConstraints = this.startConstraints;
        this.markerBlockProviders = this.initMarkerBlockProviders();
        this.nextInterestingPosForExistingMarkers = -1;
        this.interruptsParagraph = (arg_0, arg_1) -> MarkerProcessor.interruptsParagraph$lambda$0(this, arg_0, arg_1);
    }

    @NotNull
    protected final MarkdownConstraints getStartConstraints() {
        return this.startConstraints;
    }

    @NotNull
    protected final List<MarkerBlock> getNO_BLOCKS() {
        return this.NO_BLOCKS;
    }

    @NotNull
    protected final List<MarkerBlock> getMarkersStack() {
        return this.markersStack;
    }

    @NotNull
    protected final MarkdownConstraints getTopBlockConstraints() {
        return this.topBlockConstraints;
    }

    protected final void setTopBlockConstraints(@NotNull MarkdownConstraints markdownConstraints) {
        Intrinsics.checkNotNullParameter((Object)markdownConstraints, (String)"<set-?>");
        this.topBlockConstraints = markdownConstraints;
    }

    @NotNull
    protected abstract T getStateInfo();

    @NotNull
    protected abstract List<MarkerBlockProvider<T>> initMarkerBlockProviders();

    @NotNull
    public final List<MarkerBlockProvider<T>> getMarkerBlockProviders() {
        return this.markerBlockProviders;
    }

    public static /* synthetic */ void getMarkerBlockProviders$annotations() {
    }

    protected abstract void updateStateInfo(@NotNull LookaheadText.Position var1);

    protected abstract void populateConstraintsTokens(@NotNull LookaheadText.Position var1, @NotNull MarkdownConstraints var2, @NotNull ProductionHolder var3);

    @NotNull
    public List<MarkerBlock> createNewMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Compat compat = Compat.INSTANCE;
        boolean bl = MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints());
        boolean $i$f$assert = false;
        if (!bl) {
            boolean bl2 = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        for (MarkerBlockProvider markerBlockProvider : this.markerBlockProviders) {
            List<MarkerBlock> list = markerBlockProvider.createMarkerBlocks(pos, productionHolder, this.getStateInfo());
            if (!(!((Collection)list).isEmpty())) continue;
            return list;
        }
        if (pos.getOffsetInCurrentLine() >= MarkdownConstraintsKt.getCharsEaten(((StateInfo)this.getStateInfo()).getNextConstraints(), pos.getCurrentLine()) && pos.charsToNonWhitespace() != null) {
            return CollectionsKt.listOf((Object)new ParagraphMarkerBlock(((StateInfo)this.getStateInfo()).getCurrentConstraints(), productionHolder.mark(), this.interruptsParagraph));
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public final LookaheadText.Position processPosition(@NotNull LookaheadText.Position pos) {
        int delta;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.updateStateInfo(pos);
        boolean shouldRecalcNextPos = false;
        if (pos.getOffset() >= this.nextInterestingPosForExistingMarkers) {
            this.processMarkers(pos);
            shouldRecalcNextPos = true;
        }
        if (MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())) {
            MarkerBlock markerBlock = (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
            if (!(markerBlock != null ? !markerBlock.allowsSubBlocks() : false)) {
                List<MarkerBlock> newMarkerBlocks = this.createNewMarkerBlocks(pos, this.productionHolder);
                for (MarkerBlock newMarkerBlock : newMarkerBlocks) {
                    this.addNewMarkerBlock(newMarkerBlock);
                    shouldRecalcNextPos = true;
                }
            }
        }
        if (shouldRecalcNextPos) {
            this.nextInterestingPosForExistingMarkers = this.calculateNextPosForExistingMarkers(pos);
        }
        if ((pos.getOffsetInCurrentLine() == -1 || MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())) && (delta = MarkdownConstraintsKt.getCharsEaten(((StateInfo)this.getStateInfo()).getNextConstraints(), pos.getCurrentLine()) - pos.getOffsetInCurrentLine()) > 0) {
            if (pos.getOffsetInCurrentLine() != -1 && ((StateInfo)this.getStateInfo()).getNextConstraints().getIndent() <= this.topBlockConstraints.getIndent()) {
                this.populateConstraintsTokens(pos, ((StateInfo)this.getStateInfo()).getNextConstraints(), this.productionHolder);
            }
            return pos.nextPosition(delta);
        }
        return pos.nextPosition(this.nextInterestingPosForExistingMarkers - pos.getOffset());
    }

    private final int calculateNextPosForExistingMarkers(LookaheadText.Position pos) {
        MarkerBlock markerBlock = (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
        int result = markerBlock != null ? markerBlock.getNextInterestingOffset(pos) : pos.getNextLineOrEofOffset();
        return result == -1 ? Integer.MAX_VALUE : result;
    }

    public final void addNewMarkerBlock(@NotNull MarkerBlock newMarkerBlock) {
        Intrinsics.checkNotNullParameter((Object)newMarkerBlock, (String)"newMarkerBlock");
        this.markersStack.add(newMarkerBlock);
        this.relaxTopConstraints();
    }

    public final void flushMarkers() {
        this.closeChildren(-1, MarkerBlock.ClosingAction.DEFAULT);
    }

    private final boolean processMarkers(LookaheadText.Position pos) {
        int index = this.markersStack.size();
        while (index > 0) {
            MarkerBlock markerBlock;
            MarkerBlock.ProcessingResult processingResult;
            if (--index >= this.markersStack.size() || Intrinsics.areEqual((Object)(processingResult = (markerBlock = this.markersStack.get(index)).processToken(pos, ((StateInfo)this.getStateInfo()).getCurrentConstraints())), (Object)MarkerBlock.ProcessingResult.Companion.getPASS())) continue;
            this.applyProcessingResult(index, markerBlock, processingResult);
            if (processingResult.getEventAction() != MarkerBlock.EventAction.CANCEL) continue;
            return true;
        }
        return false;
    }

    private final void applyProcessingResult(int index, MarkerBlock markerBlock, MarkerBlock.ProcessingResult processingResult) {
        this.closeChildren(index, processingResult.getChildrenAction());
        if (markerBlock.acceptAction(processingResult.getSelfAction())) {
            this.markersStack.remove(index);
            this.relaxTopConstraints();
        }
    }

    private final void closeChildren(int index, MarkerBlock.ClosingAction childrenAction) {
        if (childrenAction != MarkerBlock.ClosingAction.NOTHING) {
            for (int latterIndex = this.markersStack.size() - 1; latterIndex > index; --latterIndex) {
                boolean result = this.markersStack.get(latterIndex).acceptAction(childrenAction);
                Compat this_$iv = Compat.INSTANCE;
                boolean $i$f$assert = false;
                if (!result) {
                    boolean bl = false;
                    String string = "If closing action is not NOTHING, marker should be gone";
                    throw new MarkdownParsingException(string);
                }
                this.markersStack.remove(latterIndex);
            }
            this.relaxTopConstraints();
        }
    }

    private final void relaxTopConstraints() {
        this.topBlockConstraints = this.markersStack.isEmpty() ? this.startConstraints : ((MarkerBlock)CollectionsKt.last(this.markersStack)).getBlockConstraints();
    }

    private static final boolean interruptsParagraph$lambda$0(MarkerProcessor this$0, LookaheadText.Position position, MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        boolean result = false;
        for (MarkerBlockProvider provider : this$0.markerBlockProviders) {
            if (!provider.interruptsParagraph(position, constraints)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "", "currentConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "nextConstraints", "markersStack", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "<init>", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Ljava/util/List;)V", "getCurrentConstraints", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "getNextConstraints", "paragraphBlock", "Lorg/intellij/markdown/parser/markerblocks/impl/ParagraphMarkerBlock;", "getParagraphBlock", "()Lorg/intellij/markdown/parser/markerblocks/impl/ParagraphMarkerBlock;", "lastBlock", "getLastBlock", "()Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "equals", "", "other", "hashCode", "", "jb-md"})
    @SourceDebugExtension(value={"SMAP\nMarkerProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerProcessor.kt\norg/intellij/markdown/parser/MarkerProcessor$StateInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n295#2,2:211\n*S KotlinDebug\n*F\n+ 1 MarkerProcessor.kt\norg/intellij/markdown/parser/MarkerProcessor$StateInfo\n*L\n190#1:211,2\n*E\n"})
    public static class StateInfo {
        @NotNull
        private final MarkdownConstraints currentConstraints;
        @NotNull
        private final MarkdownConstraints nextConstraints;
        @NotNull
        private final List<MarkerBlock> markersStack;

        public StateInfo(@NotNull MarkdownConstraints currentConstraints, @NotNull MarkdownConstraints nextConstraints, @NotNull List<? extends MarkerBlock> markersStack) {
            Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
            Intrinsics.checkNotNullParameter((Object)nextConstraints, (String)"nextConstraints");
            Intrinsics.checkNotNullParameter(markersStack, (String)"markersStack");
            this.currentConstraints = currentConstraints;
            this.nextConstraints = nextConstraints;
            this.markersStack = markersStack;
        }

        @NotNull
        public final MarkdownConstraints getCurrentConstraints() {
            return this.currentConstraints;
        }

        @NotNull
        public final MarkdownConstraints getNextConstraints() {
            return this.nextConstraints;
        }

        @Nullable
        public final ParagraphMarkerBlock getParagraphBlock() {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = this.markersStack;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MarkerBlock block = (MarkerBlock)element$iv;
                    boolean bl = false;
                    if (!(block instanceof ParagraphMarkerBlock)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final MarkerBlock getLastBlock() {
            return (MarkerBlock)CollectionsKt.lastOrNull(this.markersStack);
        }

        public boolean equals(@Nullable Object other) {
            StateInfo stateInfo = other instanceof StateInfo ? (StateInfo)other : null;
            if (stateInfo == null) {
                return false;
            }
            StateInfo otherStateInfo = stateInfo;
            return Intrinsics.areEqual((Object)this.currentConstraints, (Object)otherStateInfo.currentConstraints) && Intrinsics.areEqual((Object)this.nextConstraints, (Object)otherStateInfo.nextConstraints) && Intrinsics.areEqual(this.markersStack, otherStateInfo.markersStack);
        }

        public int hashCode() {
            int result = this.currentConstraints.hashCode();
            result = result * 37 + this.nextConstraints.hashCode();
            result = result * 37 + ((Object)this.markersStack).hashCode();
            return result;
        }
    }
}

