/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import com.intellij.psi.tree.IElementType;
import kala.text.StringSlice;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\u000b2\n\u0010\r\u001a\u00060\u000eR\u00020\u000fH\u0016J\u0014\u0010\u0014\u001a\u00020\u00132\n\u0010\r\u001a\u00060\u000eR\u00020\u000fH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\r\u001a\u00060\u000eR\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0003H\u0014J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/intellij/markdown/parser/markerblocks/impl/CodeFenceMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "fenceStart", "", "<init>", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Ljava/lang/String;)V", "allowsSubBlocks", "", "isInterestingOffset", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "endLineRegex", "Lkotlin/text/Regex;", "realInterestingOffset", "", "calcNextInterestingOffset", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "endsThisFence", "line", "", "getDefaultNodeType", "Lcom/intellij/psi/tree/IElementType;", "jb-md"})
@SourceDebugExtension(value={"SMAP\nCodeFenceMarkerBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFenceMarkerBlock.kt\norg/intellij/markdown/parser/markerblocks/impl/CodeFenceMarkerBlock\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,94:1\n107#2,3:95\n111#2:99\n107#3:98\n*S KotlinDebug\n*F\n+ 1 CodeFenceMarkerBlock.kt\norg/intellij/markdown/parser/markerblocks/impl/CodeFenceMarkerBlock\n*L\n49#1:95,3\n49#1:99\n49#1:98\n*E\n"})
public final class CodeFenceMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final ProductionHolder productionHolder;
    @NotNull
    private final String fenceStart;
    @NotNull
    private final Regex endLineRegex;
    private int realInterestingOffset;

    public CodeFenceMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull String fenceStart) {
        Intrinsics.checkNotNullParameter((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)fenceStart, (String)"fenceStart");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.fenceStart = fenceStart;
        this.endLineRegex = new Regex("^ {0,3}" + this.fenceStart + "+ *$");
        this.realInterestingOffset = -1;
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        int nextLineOffset;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffset() < this.realInterestingOffset) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = pos.getOffsetInCurrentLine() == -1;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        MarkdownConstraints nextLineConstraints = MarkdownConstraintsKt.applyToNextLineAndAddModifiers(this.getConstraints(), pos);
        if (!MarkdownConstraintsKt.extendsPrev(nextLineConstraints, this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        this.realInterestingOffset = nextLineOffset = pos.getNextLineOrEofOffset();
        StringSlice currentLine = MarkdownConstraintsKt.eatItselfFromString(nextLineConstraints, pos.getCurrentLine());
        if (this.endsThisFence((CharSequence)currentLine)) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset() + 1, pos.getNextLineOrEofOffset()), MarkdownTokenTypes.CODE_FENCE_END)));
            this.scheduleProcessingResult(nextLineOffset, MarkerBlock.ProcessingResult.Companion.getDEFAULT());
        } else {
            IntRange contentRange = new IntRange(Math.min(pos.getOffset() + 1 + MarkdownConstraintsKt.getCharsEaten(this.getConstraints(), pos.getCurrentLine()), nextLineOffset), nextLineOffset);
            if (contentRange.getFirst() < contentRange.getLast()) {
                this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(contentRange, MarkdownTokenTypes.CODE_FENCE_CONTENT)));
            }
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    private final boolean endsThisFence(CharSequence line) {
        return this.endLineRegex.matches(line);
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.CODE_FENCE;
    }
}

