/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J,\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u00122\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0013\u001a\u00060\u0014R\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\u00162\u0016\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0002R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/EmphasisLikeParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "parsers", "", "Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser;", "<init>", "([Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser;)V", "[Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser;", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "collectDelimiters", "Ljava/util/ArrayList;", "Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser$Info;", "Lkotlin/collections/ArrayList;", "iterator", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "balanceDelimiters", "", "delimiters", "violatesRuleOfThree", "", "opener", "closer", "jb-md"})
public final class EmphasisLikeParser
implements SequentialParser {
    @NotNull
    private final DelimiterParser[] parsers;

    public EmphasisLikeParser(DelimiterParser ... parsers) {
        Intrinsics.checkNotNullParameter((Object)parsers, (String)"parsers");
        this.parsers = parsers;
    }

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result = new SequentialParser.ParsingResultBuilder();
        TokensCache.RangesListIterator iterator = new TokensCache.RangesListIterator(tokens, rangesToGlue);
        ArrayList<DelimiterParser.Info> delimiters = this.collectDelimiters(tokens, iterator);
        this.balanceDelimiters(delimiters);
        for (DelimiterParser parser : this.parsers) {
            parser.process(tokens, iterator, (List<DelimiterParser.Info>)delimiters, result);
        }
        return result;
    }

    private final ArrayList<DelimiterParser.Info> collectDelimiters(TokensCache tokens, TokensCache.Iterator iterator) {
        ArrayList<DelimiterParser.Info> delimiters = new ArrayList<DelimiterParser.Info>();
        TokensCache.Iterator position = iterator;
        block0: while (position.getType() != null) {
            int iteratorMoved = 0;
            for (DelimiterParser parser : this.parsers) {
                int steps = parser.scan(tokens, position, (List<DelimiterParser.Info>)delimiters);
                iteratorMoved += steps;
                for (int step = 0; step < steps; ++step) {
                    if (position.getType() == null) break block0;
                    position = position.advance();
                }
            }
            if (iteratorMoved != 0) continue;
            position = position.advance();
        }
        return delimiters;
    }

    private final void balanceDelimiters(ArrayList<DelimiterParser.Info> delimiters) {
        int runStartIndex = 0;
        int previousDelimiterIndex = -2;
        int n = 0;
        int n2 = delimiters.size();
        Integer[] integerArray = new Integer[n2];
        while (n < n2) {
            int n3 = n++;
            integerArray[n3] = 0;
        }
        Integer[] openersIndices = integerArray;
        HashMap openersBottom = new HashMap();
        Iterator iterator = ((Iterable)delimiters).iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            int openerIndex;
            int closerIndex = n4++;
            DelimiterParser.Info closer = (DelimiterParser.Info)iterator.next();
            if (delimiters.get(runStartIndex).getMarker() != closer.getMarker() || previousDelimiterIndex != closer.getPosition() - 1) {
                runStartIndex = closerIndex;
            }
            previousDelimiterIndex = closer.getPosition();
            if (!closer.getCanClose()) continue;
            if (!openersBottom.containsKey(Character.valueOf(closer.getMarker()))) {
                Map map = openersBottom;
                Character c = Character.valueOf(closer.getMarker());
                Integer[] integerArray2 = new Integer[]{-1, -1, -1, -1, -1, -1};
                map.put(c, integerArray2);
            }
            Object v = openersBottom.get(Character.valueOf(closer.getMarker()));
            Intrinsics.checkNotNull(v);
            int minOpenerIndex = ((Integer[])v)[(closer.getCanOpen() ? 3 : 0) + closer.getLength() % 3];
            int newMinOpenerIndex = openerIndex = runStartIndex - openersIndices[runStartIndex] - 1;
            while (openerIndex > minOpenerIndex) {
                DelimiterParser.Info opener;
                Intrinsics.checkNotNullExpressionValue((Object)delimiters.get(openerIndex), (String)"get(...)");
                if (opener.getMarker() != closer.getMarker()) {
                    openerIndex -= openersIndices[openerIndex] + 1;
                    continue;
                }
                if (opener.getCanOpen() && opener.getCloserIndex() < 0 && !this.violatesRuleOfThree(opener, closer)) {
                    int lastIndex = openerIndex > 0 && !delimiters.get(openerIndex - 1).getCanOpen() ? openersIndices[openerIndex - 1] + 1 : 0;
                    openersIndices[openerIndex] = lastIndex;
                    openersIndices[closerIndex] = closerIndex - openerIndex + lastIndex;
                    closer.setCanOpen(false);
                    opener.setCloserIndex(closerIndex);
                    opener.setCanClose(false);
                    newMinOpenerIndex = -1;
                    previousDelimiterIndex = -2;
                    break;
                }
                openerIndex -= openersIndices[openerIndex] + 1;
            }
            if (newMinOpenerIndex == -1) continue;
            Object v2 = openersBottom.get(Character.valueOf(closer.getMarker()));
            Intrinsics.checkNotNull(v2);
            ((Integer[])v2)[(closer.getCanOpen() ? 3 : 0) + closer.getLength() % 3] = newMinOpenerIndex;
        }
    }

    private final boolean violatesRuleOfThree(DelimiterParser.Info opener, DelimiterParser.Info closer) {
        return !(!opener.getCanClose() && !closer.getCanOpen() || (opener.getLength() + closer.getLength()) % 3 != 0 || opener.getLength() % 3 == 0 && closer.getLength() % 3 == 0);
    }
}

