/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.ast.impl;

import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import kala.collection.Seq;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.CompositeASTNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\nH\u0002R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/intellij/markdown/ast/impl/ListCompositeNode;", "Lorg/intellij/markdown/ast/CompositeASTNode;", "type", "Lcom/intellij/psi/tree/IElementType;", "children", "Lkala/collection/Seq;", "Lorg/intellij/markdown/ast/ASTNode;", "<init>", "(Lcom/intellij/psi/tree/IElementType;Lkala/collection/Seq;)V", "loose", "", "getLoose", "()Z", "loose$delegate", "Lkotlin/Lazy;", "isLoose", "Companion", "jb-md"})
public final class ListCompositeNode
extends CompositeASTNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy loose$delegate;

    public ListCompositeNode(@NotNull IElementType type, @NotNull Seq<ASTNode> children) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        super(type, children);
        this.loose$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> ListCompositeNode.loose_delegate$lambda$0(this));
    }

    public final boolean getLoose() {
        Lazy lazy = this.loose$delegate;
        return (Boolean)lazy.getValue();
    }

    private final boolean isLoose() {
        if (ListCompositeNode.Companion.hasLooseContent(this)) {
            return true;
        }
        Iterator iterator = this.getChildren().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ASTNode child = (ASTNode)iterator2.next();
            if (!Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownElementTypes.LIST_ITEM)) continue;
            Intrinsics.checkNotNull((Object)child);
            if (!ListCompositeNode.Companion.hasLooseContent(child)) continue;
            return true;
        }
        return false;
    }

    private static final boolean loose_delegate$lambda$0(ListCompositeNode this$0) {
        return this$0.isLoose();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/intellij/markdown/ast/impl/ListCompositeNode$Companion;", "", "<init>", "()V", "hasLooseContent", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasLooseContent(ASTNode node) {
            int newlines = 0;
            boolean seenNonWhitespace = false;
            Iterator iterator = node.getChildren().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                ASTNode child = (ASTNode)iterator2.next();
                IElementType iElementType = child.getType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
                    ++newlines;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LIST_BULLET) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LIST_NUMBER) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE)) continue;
                if (seenNonWhitespace && newlines > 1) {
                    return true;
                }
                seenNonWhitespace = true;
                newlines = 0;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

