/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\f\u001a\u00020\t2\n\u0010\r\u001a\u00060\u000eR\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\r\u001a\u00060\u000eR\u00020\u000fH\u0014J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\r\u001a\u00060\u000eR\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0003H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/markdown/parser/markerblocks/impl/SetextHeaderMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "<init>", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;)V", "allowsSubBlocks", "", "contentMarker", "Lorg/intellij/markdown/parser/ProductionHolder$Marker;", "isInterestingOffset", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "calcNextInterestingOffset", "", "nodeType", "Lcom/intellij/psi/tree/IElementType;", "getDefaultNodeType", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "jb-md"})
public final class SetextHeaderMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final ProductionHolder productionHolder;
    @NotNull
    private final ProductionHolder.Marker contentMarker;
    @NotNull
    private IElementType nodeType;

    public SetextHeaderMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkNotNullParameter((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.contentMarker = this.productionHolder.mark();
        this.nodeType = MarkdownElementTypes.SETEXT_1;
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getOffsetInCurrentLine() == -1;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.nodeType;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        LookaheadText.Position setextMarkerStart;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        Integer n = pos.charsToNonWhitespace();
        if (n == null) {
            return new MarkerBlock.ProcessingResult(MarkerBlock.ClosingAction.DROP, MarkerBlock.ClosingAction.DROP, MarkerBlock.EventAction.PROPAGATE);
        }
        int startSpaces = n;
        LookaheadText.Position position = setextMarkerStart = pos.nextPosition(startSpaces);
        boolean bl = position != null ? position.getChar() == '-' : false;
        if (bl) {
            this.nodeType = MarkdownElementTypes.SETEXT_2;
        }
        LookaheadText.Position position2 = setextMarkerStart;
        int setextMarkerStartOffset = position2 != null ? position2.getOffset() : pos.getOffset();
        IElementType markerNodeType = Intrinsics.areEqual((Object)this.nodeType, (Object)MarkdownElementTypes.SETEXT_2) ? MarkdownTokenTypes.SETEXT_2 : MarkdownTokenTypes.SETEXT_1;
        this.contentMarker.done(MarkdownTokenTypes.SETEXT_CONTENT);
        this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(setextMarkerStartOffset, pos.getNextLineOrEofOffset()), markerNodeType)));
        this.scheduleProcessingResult(pos.getNextLineOrEofOffset(), MarkerBlock.ProcessingResult.Companion.getDEFAULT());
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }
}

