package org.intellij.markdown.flavours.commonmark

import kala.collection.Seq
import org.intellij.markdown.MarkdownTokenTypes
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor
import org.intellij.markdown.lexer.MarkdownLexer
import org.intellij.markdown.lexer._MarkdownLexer
import org.intellij.markdown.parser.MarkerProcessorFactory
import org.intellij.markdown.parser.sequentialparsers.EmphasisLikeParser
import org.intellij.markdown.parser.sequentialparsers.SequentialParser
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager
import org.intellij.markdown.parser.sequentialparsers.impl.*

/**
 * CommonMark spec based flavour, to be used as a base for other flavours
 *
 * @param absolutizeAnchorLinks `true` if anchor links (e.g. `#foo`) should be resolved against `baseURI` and
 * `false` otherwise
 */
open class CommonMarkFlavourDescriptor(
  protected val absolutizeAnchorLinks: Boolean = false,
) : MarkdownFlavourDescriptor {
  override val markerProcessorFactory: MarkerProcessorFactory = CommonMarkMarkerProcessor.Factory

  override fun createInlinesLexer(): MarkdownLexer {
    return MarkdownLexer(_MarkdownLexer())
  }

  override val sequentialParserManager = object : SequentialParserManager() {
    override fun getParserSequence(): Seq<SequentialParser> {
      return Seq.of(
        AutolinkParser(Seq.of(MarkdownTokenTypes.AUTOLINK)),
        BacktickParser(),
        ImageParser(),
        InlineLinkParser(),
        ReferenceLinkParser(),
        EmphasisLikeParser(EmphStrongDelimiterParser()),
      )
    }
  }
}
