/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.constraints;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 (2\u00020\u0001:\u0002'(B)\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ(\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00002\f\u0010\u001d\u001a\b\u0018\u00010\u001eR\u00020\u001fH\u0016J\u0016\u0010 \u001a\u00020\u00002\f\u0010\u001d\u001a\b\u0018\u00010\u001eR\u00020\u001fH\u0016J\u0016\u0010!\u001a\u0004\u0018\u00010\"2\n\u0010\u001d\u001a\u00060\u001eR\u00020\u001fH\u0014J\u0016\u0010#\u001a\u0004\u0018\u00010\u00002\n\u0010\u001d\u001a\u00060\u001eR\u00020\u001fH\u0002J\u0016\u0010$\u001a\u0004\u0018\u00010\u00002\n\u0010\u001d\u001a\u00060\u001eR\u00020\u001fH\u0002J\b\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006)"}, d2={"Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "indents", "", "types", "", "isExplicit", "", "charsEaten", "", "<init>", "([I[C[ZI)V", "getTypes", "()[C", "()[Z", "getCharsEaten", "()I", "base", "getBase", "()Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "createNewConstraints", "indent", "getIndent", "startsWith", "", "other", "containsListMarkers", "upToIndex", "addModifierIfNeeded", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "applyToNextLine", "fetchListMarker", "Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints$ListMarkerInfo;", "tryAddListItem", "tryAddBlockQuote", "toString", "", "ListMarkerInfo", "Companion", "jb-md"})
@SourceDebugExtension(value={"SMAP\nCommonMarkdownConstraints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonMarkdownConstraints.kt\norg/intellij/markdown/parser/constraints/CommonMarkdownConstraints\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat\n*L\n1#1,303:1\n2746#2,3:304\n1761#2,3:307\n108#3,4:310\n*S KotlinDebug\n*F\n+ 1 CommonMarkdownConstraints.kt\norg/intellij/markdown/parser/constraints/CommonMarkdownConstraints\n*L\n37#1:304,3\n41#1:307,3\n57#1:310,4\n*E\n"})
public class CommonMarkdownConstraints
implements MarkdownConstraints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] indents;
    @NotNull
    private final char[] types;
    @NotNull
    private final boolean[] isExplicit;
    private final int charsEaten;
    @NotNull
    private static final CommonMarkdownConstraints BASE = new CommonMarkdownConstraints(new int[0], new char[0], new boolean[0], 0);
    public static final char BQ_CHAR = '>';

    protected CommonMarkdownConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkNotNullParameter((Object)indents, (String)"indents");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)isExplicit, (String)"isExplicit");
        this.indents = indents;
        this.types = types;
        this.isExplicit = isExplicit;
        this.charsEaten = charsEaten;
    }

    @Override
    @NotNull
    public char[] getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public boolean[] isExplicit() {
        return this.isExplicit;
    }

    @Override
    public int getCharsEaten() {
        return this.charsEaten;
    }

    @NotNull
    protected CommonMarkdownConstraints getBase() {
        return BASE;
    }

    @NotNull
    protected CommonMarkdownConstraints createNewConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkNotNullParameter((Object)indents, (String)"indents");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)isExplicit, (String)"isExplicit");
        return new CommonMarkdownConstraints(indents, types, isExplicit, charsEaten);
    }

    @Override
    public int getIndent() {
        Integer n = ArraysKt.lastOrNull((int[])this.indents);
        return n != null ? n : 0;
    }

    @Override
    public boolean startsWith(@NotNull MarkdownConstraints other) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!(other instanceof CommonMarkdownConstraints)) {
                return false;
            }
            int n = this.indents.length;
            int m = ((CommonMarkdownConstraints)other).indents.length;
            if (n < m) {
                return false;
            }
            Iterable $this$none$iv = (Iterable)RangesKt.until((int)0, (int)m);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$none$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(this.getTypes()[it] != ((CommonMarkdownConstraints)other).getTypes()[it])) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean containsListMarkers(int upToIndex) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)upToIndex);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(this.getTypes()[it] != '>' && this.isExplicit()[it])) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public CommonMarkdownConstraints addModifierIfNeeded(@Nullable LookaheadText.Position pos) {
        if (pos == null || pos.getOffsetInCurrentLine() == -1) {
            return null;
        }
        if (HorizontalRuleProvider.Companion.isHorizontalRule(pos.getCurrentLine(), pos.getOffsetInCurrentLine())) {
            return null;
        }
        CommonMarkdownConstraints commonMarkdownConstraints = this.tryAddListItem(pos);
        if (commonMarkdownConstraints == null) {
            commonMarkdownConstraints = this.tryAddBlockQuote(pos);
        }
        return commonMarkdownConstraints;
    }

    @Override
    @NotNull
    public CommonMarkdownConstraints applyToNextLine(@Nullable LookaheadText.Position pos) {
        if (pos == null) {
            return this.getBase();
        }
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = pos.getOffsetInCurrentLine() == -1;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "given " + pos;
            throw new MarkdownParsingException(string);
        }
        String line = pos.getCurrentLine();
        int prevN = this.indents.length;
        Ref.IntRef indexPrev = new Ref.IntRef();
        Function1 getBlockQuoteIndent = arg_0 -> CommonMarkdownConstraints.applyToNextLine$lambda$3(line, arg_0);
        Function1 fillMaybeBlockquoteAndListIndents = arg_0 -> CommonMarkdownConstraints.applyToNextLine$lambda$5(indexPrev, prevN, line, this, getBlockQuoteIndent, arg_0);
        CommonMarkdownConstraints result = this.getBase();
        CommonMarkdownConstraints nextConstraints;
        while (!Intrinsics.areEqual((Object)(nextConstraints = (CommonMarkdownConstraints)fillMaybeBlockquoteAndListIndents.invoke((Object)result)), (Object)result)) {
            result = nextConstraints;
        }
        return result;
    }

    @Nullable
    protected ListMarkerInfo fetchListMarker(@NotNull LookaheadText.Position pos) {
        int offset;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        char c = pos.getChar();
        switch (c) {
            case '*': 
            case '+': 
            case '-': {
                return new ListMarkerInfo(1, c, 1);
            }
        }
        String line = pos.getCurrentLine();
        for (offset = pos.getOffsetInCurrentLine(); offset < line.length(); ++offset) {
            char c2 = line.charAt(offset);
            boolean bl = '0' <= c2 ? c2 < ':' : false;
            if (!bl) break;
        }
        return offset > pos.getOffsetInCurrentLine() && offset - pos.getOffsetInCurrentLine() <= 9 && offset < line.length() && (line.charAt(offset) == '.' || line.charAt(offset) == ')') ? new ListMarkerInfo(offset + 1 - pos.getOffsetInCurrentLine(), line.charAt(offset), offset + 1 - pos.getOffsetInCurrentLine()) : null;
    }

    private final CommonMarkdownConstraints tryAddListItem(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        int n = spacesBefore = offset > 0 && line.charAt(offset - 1) == '\t' ? (4 - this.getIndent() % 4) % 4 : 0;
        while (offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3) {
            ++spacesBefore;
            ++offset;
        }
        if (offset == line.length()) {
            return null;
        }
        LookaheadText.Position position = pos.nextPosition(offset - pos.getOffsetInCurrentLine());
        Intrinsics.checkNotNull((Object)position);
        ListMarkerInfo listMarkerInfo = this.fetchListMarker(position);
        if (listMarkerInfo == null) {
            return null;
        }
        ListMarkerInfo markerInfo = listMarkerInfo;
        int spacesAfter = 0;
        int markerEndOffset = offset += markerInfo.getMarkerLength();
        block5: while (offset < line.length()) {
            switch (line.charAt(offset)) {
                case ' ': {
                    ++spacesAfter;
                    break;
                }
                case '\t': {
                    spacesAfter += 4 - spacesAfter % 4;
                    break;
                }
                default: {
                    break block5;
                }
            }
            ++offset;
        }
        boolean bl = 1 <= spacesAfter ? spacesAfter < 5 : false;
        if (bl && offset < line.length()) {
            return CommonMarkdownConstraints.Companion.create(this, spacesBefore + markerInfo.getMarkerIndent() + spacesAfter, markerInfo.getMarkerType(), true, offset);
        }
        if (spacesAfter >= 5 && offset < line.length() || offset == line.length()) {
            return CommonMarkdownConstraints.Companion.create(this, spacesBefore + markerInfo.getMarkerIndent() + 1, markerInfo.getMarkerType(), true, Math.min(offset, markerEndOffset + 1));
        }
        return null;
    }

    private final CommonMarkdownConstraints tryAddBlockQuote(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        for (spacesBefore = 0; offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3; ++spacesBefore, ++offset) {
        }
        if (offset == line.length() || line.charAt(offset) != '>') {
            return null;
        }
        int spacesAfter = 0;
        if (++offset >= line.length() || line.charAt(offset) == ' ' || line.charAt(offset) == '\t') {
            spacesAfter = 1;
            if (offset < line.length()) {
                ++offset;
            }
        }
        return CommonMarkdownConstraints.Companion.create(this, spacesBefore + 1 + spacesAfter, '>', true, offset);
    }

    @NotNull
    public String toString() {
        return "MdConstraints: " + StringsKt.concatToString((char[])this.getTypes()) + "(" + this.getIndent() + ")";
    }

    private static final Integer applyToNextLine$lambda$3(String $line, int startOffset) {
        int blockQuoteIndent;
        int offset = startOffset;
        for (blockQuoteIndent = 0; blockQuoteIndent < 3 && offset < $line.length() && $line.charAt(offset) == ' '; ++blockQuoteIndent, ++offset) {
        }
        return offset < $line.length() && $line.charAt(offset) == '>' ? Integer.valueOf(blockQuoteIndent + 1) : null;
    }

    private static final boolean applyToNextLine$lambda$5$lambda$4(Ref.IntRef $spacesSeen, Ref.IntRef $offset, String $line, Ref.IntRef $totalSpaces, int k) {
        boolean bl;
        int oldSpacesSeen = $spacesSeen.element;
        int oldOffset = $offset.element;
        block4: while ($spacesSeen.element < k && $offset.element < $line.length()) {
            int n;
            switch ($line.charAt($offset.element)) {
                case ' ': {
                    n = 1;
                    break;
                }
                case '\t': {
                    n = 4 - $totalSpaces.element % 4;
                    break;
                }
                default: {
                    break block4;
                }
            }
            int deltaSpaces = n;
            $spacesSeen.element += deltaSpaces;
            $totalSpaces.element += deltaSpaces;
            int n2 = $offset.element;
            $offset.element = n2 + 1;
        }
        if ($offset.element == $line.length()) {
            $spacesSeen.element = Integer.MAX_VALUE;
        }
        if (k <= $spacesSeen.element) {
            $spacesSeen.element -= k;
            bl = true;
        } else {
            $offset.element = oldOffset;
            $spacesSeen.element = oldSpacesSeen;
            bl = false;
        }
        return bl;
    }

    private static final CommonMarkdownConstraints applyToNextLine$lambda$5(Ref.IntRef indexPrev, int prevN, String line, CommonMarkdownConstraints this$0, Function1<? super Integer, Integer> getBlockQuoteIndent, CommonMarkdownConstraints constraints) {
        int deltaIndent;
        if (indexPrev.element >= prevN) {
            return constraints;
        }
        Ref.IntRef offset = new Ref.IntRef();
        offset.element = MarkdownConstraintsKt.getCharsEaten(constraints, line);
        Ref.IntRef totalSpaces = new Ref.IntRef();
        Ref.IntRef spacesSeen = new Ref.IntRef();
        Function1 hasKMoreSpaces = arg_0 -> CommonMarkdownConstraints.applyToNextLine$lambda$5$lambda$4(spacesSeen, offset, line, totalSpaces, arg_0);
        Integer bqIndent = null;
        if (this$0.getTypes()[indexPrev.element] == '>') {
            Integer n = (Integer)getBlockQuoteIndent.invoke((Object)offset.element);
            if (n == null) {
                return constraints;
            }
            bqIndent = n;
            offset.element += bqIndent.intValue();
            int n2 = indexPrev.element;
            indexPrev.element = n2 + 1;
        } else {
            bqIndent = null;
        }
        int oldIndexPrev = indexPrev.element;
        while (indexPrev.element < prevN && this$0.getTypes()[indexPrev.element] != '>' && ((Boolean)hasKMoreSpaces.invoke((Object)(deltaIndent = this$0.indents[indexPrev.element] - (indexPrev.element == 0 ? 0 : this$0.indents[indexPrev.element - 1])))).booleanValue()) {
            int n = indexPrev.element;
            indexPrev.element = n + 1;
        }
        CommonMarkdownConstraints result = constraints;
        if (bqIndent != null) {
            int bonusForTheBlockquote = (Boolean)hasKMoreSpaces.invoke((Object)1) != false ? 1 : 0;
            result = CommonMarkdownConstraints.Companion.create(result, bqIndent + bonusForTheBlockquote, '>', true, offset.element);
        }
        int n = indexPrev.element;
        for (int index = oldIndexPrev; index < n; ++index) {
            int deltaIndent2 = this$0.indents[index] - (index == 0 ? 0 : this$0.indents[index - 1]);
            result = CommonMarkdownConstraints.Companion.create(result, deltaIndent2, this$0.getTypes()[index], false, offset.element);
        }
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints$Companion;", "", "<init>", "()V", "BASE", "Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "getBASE", "()Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "BQ_CHAR", "", "create", "parent", "newIndentDelta", "", "newType", "newExplicit", "", "newOffset", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommonMarkdownConstraints getBASE() {
            return BASE;
        }

        private final CommonMarkdownConstraints create(CommonMarkdownConstraints parent, int newIndentDelta, char newType, boolean newExplicit, int newOffset) {
            int n = parent.indents.length;
            int[] nArray = Arrays.copyOf(parent.indents, n + 1);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            int[] indents = nArray;
            char[] cArray = Arrays.copyOf(parent.getTypes(), n + 1);
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(...)");
            char[] types = cArray;
            boolean[] blArray = Arrays.copyOf(parent.isExplicit(), n + 1);
            Intrinsics.checkNotNullExpressionValue((Object)blArray, (String)"copyOf(...)");
            boolean[] isExplicit = blArray;
            indents[n] = parent.getIndent() + newIndentDelta;
            types[n] = newType;
            isExplicit[n] = newExplicit;
            return parent.createNewConstraints(indents, types, isExplicit, newOffset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints$ListMarkerInfo;", "", "markerLength", "", "markerType", "", "markerIndent", "<init>", "(ICI)V", "getMarkerLength", "()I", "getMarkerType", "()C", "getMarkerIndent", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "jb-md"})
    protected static final class ListMarkerInfo {
        private final int markerLength;
        private final char markerType;
        private final int markerIndent;

        public ListMarkerInfo(int markerLength, char markerType, int markerIndent) {
            this.markerLength = markerLength;
            this.markerType = markerType;
            this.markerIndent = markerIndent;
        }

        public final int getMarkerLength() {
            return this.markerLength;
        }

        public final char getMarkerType() {
            return this.markerType;
        }

        public final int getMarkerIndent() {
            return this.markerIndent;
        }

        public final int component1() {
            return this.markerLength;
        }

        public final char component2() {
            return this.markerType;
        }

        public final int component3() {
            return this.markerIndent;
        }

        @NotNull
        public final ListMarkerInfo copy(int markerLength, char markerType, int markerIndent) {
            return new ListMarkerInfo(markerLength, markerType, markerIndent);
        }

        public static /* synthetic */ ListMarkerInfo copy$default(ListMarkerInfo listMarkerInfo, int n, char c, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = listMarkerInfo.markerLength;
            }
            if ((n3 & 2) != 0) {
                c = listMarkerInfo.markerType;
            }
            if ((n3 & 4) != 0) {
                n2 = listMarkerInfo.markerIndent;
            }
            return listMarkerInfo.copy(n, c, n2);
        }

        @NotNull
        public String toString() {
            return "ListMarkerInfo(markerLength=" + this.markerLength + ", markerType=" + this.markerType + ", markerIndent=" + this.markerIndent + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.markerLength);
            result = result * 31 + Character.hashCode(this.markerType);
            result = result * 31 + Integer.hashCode(this.markerIndent);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ListMarkerInfo)) {
                return false;
            }
            ListMarkerInfo listMarkerInfo = (ListMarkerInfo)other;
            if (this.markerLength != listMarkerInfo.markerLength) {
                return false;
            }
            if (this.markerType != listMarkerInfo.markerType) {
                return false;
            }
            return this.markerIndent == listMarkerInfo.markerIndent;
        }
    }
}

