/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kala.text.StringSlice;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.HtmlBlockMarkerBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "<init>", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "", "Companion", "jb-md"})
@SourceDebugExtension(value={"SMAP\nHtmlBlockProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlBlockProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n*L\n1#1,93:1\n108#2,4:94\n108#2,4:98\n*S KotlinDebug\n*F\n+ 1 HtmlBlockProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider\n*L\n37#1:94,4\n43#1:98,4\n*E\n"})
public final class HtmlBlockProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG_NAMES = "address, article, aside, base, basefont, blockquote, body, caption, center, col, colgroup, dd, details, dialog, dir, div, dl, dt, fieldset, figcaption, figure, footer, form, frame, frameset, h1, head, header, hr, html, legend, li, link, main, menu, menuitem, meta, nav, noframes, ol, optgroup, option, p, param, pre, section, source, title, summary, table, tbody, td, tfoot, th, thead, title, tr, track, ul";
    @NotNull
    private static final String TAG_NAME = "[a-zA-Z][a-zA-Z0-9-]*";
    @NotNull
    private static final String ATTR_NAME = "[A-Za-z:_][A-Za-z0-9_.:-]*";
    @NotNull
    private static final String ATTR_VALUE = "\\s*=\\s*(?:[^ \"'=<>`]+|'[^']*'|\"[^\"]*\")";
    @NotNull
    private static final String ATTRIBUTE = "\\s+" + ATTR_NAME + "(?:" + ATTR_VALUE + ")?";
    @NotNull
    private static final String OPEN_TAG = "<" + TAG_NAME + "(?:" + ATTRIBUTE + ")*\\s*/?>";
    @NotNull
    private static final String CLOSE_TAG = "</" + TAG_NAME + "\\s*>";
    @NotNull
    private static final List<Pair<Regex, Regex>> OPEN_CLOSE_REGEXES;
    @NotNull
    private static final Regex FIND_START_REGEX;

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        int matchingGroup = this.matches(pos, stateInfo.getCurrentConstraints());
        if (matchingGroup != -1) {
            return CollectionsKt.listOf((Object)new HtmlBlockMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, (Regex)OPEN_CLOSE_REGEXES.get(matchingGroup).getSecond(), pos));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        int n = this.matches(pos, constraints);
        return 0 <= n ? n < 6 : false;
    }

    private final int matches(LookaheadText.Position pos, MarkdownConstraints constraints) {
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return -1;
        }
        StringSlice text = pos.getCurrentLineFromPosition();
        int offset = MarkerBlockProvider.Companion.passSmallIndent$default(MarkerBlockProvider.Companion, (CharSequence)text, 0, 2, null);
        if (offset >= text.length() || text.charAt(offset) != '<') {
            return -1;
        }
        StringSlice stringSlice = text.substring(offset);
        Intrinsics.checkNotNullExpressionValue((Object)stringSlice, (String)"substring(...)");
        MatchResult matchResult = Regex.find$default((Regex)FIND_START_REGEX, (CharSequence)((CharSequence)stringSlice), (int)0, (int)2, null);
        if (matchResult == null) {
            return -1;
        }
        MatchResult matchResult2 = matchResult;
        Compat compat = Compat.INSTANCE;
        int condition$iv = matchResult2.getGroups().size() == OPEN_CLOSE_REGEXES.size() + 2 ? 1 : 0;
        boolean $i$f$assert = false;
        if (condition$iv == 0) {
            boolean bl = false;
            String string = "There are some excess capturing groups probably!";
            throw new MarkdownParsingException(string);
        }
        condition$iv = OPEN_CLOSE_REGEXES.size();
        for (int i = 0; i < condition$iv; ++i) {
            if (matchResult2.getGroups().get(i + 2) == null) continue;
            return i;
        }
        Compat i = Compat.INSTANCE;
        condition$iv = 0;
        $i$f$assert = false;
        boolean bl = false;
        String string = "Match found but all groups are empty!";
        throw new MarkdownParsingException(string);
    }

    private static final CharSequence FIND_START_REGEX$lambda$2(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "(" + ((Regex)it.getFirst()).getPattern() + ")";
    }

    static {
        Object[] objectArray = new Pair[]{new Pair((Object)new Regex("<(?:script|pre|style)(?: |>|$)", RegexOption.IGNORE_CASE), (Object)new Regex("</(?:script|style|pre)>", RegexOption.IGNORE_CASE)), new Pair((Object)new Regex("<!--"), (Object)new Regex("-->")), new Pair((Object)new Regex("<\\?"), (Object)new Regex("\\?>")), new Pair((Object)new Regex("<![A-Z]"), (Object)new Regex(">")), new Pair((Object)new Regex("<!\\[CDATA\\["), (Object)new Regex("\\]\\]>")), new Pair((Object)new Regex("</?(?:" + StringsKt.replace$default((String)TAG_NAMES, (String)", ", (String)"|", (boolean)false, (int)4, null) + ")(?: |/?>|$)", RegexOption.IGNORE_CASE), null), new Pair((Object)new Regex("(?:" + OPEN_TAG + "|" + CLOSE_TAG + ")(?: |$)"), null)};
        OPEN_CLOSE_REGEXES = CollectionsKt.listOf((Object[])objectArray);
        FIND_START_REGEX = new Regex("^(" + CollectionsKt.joinToString$default((Iterable)OPEN_CLOSE_REGEXES, (CharSequence)"|", null, null, (int)0, null, HtmlBlockProvider::FIND_START_REGEX$lambda$2, (int)30, null) + ")");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R%\u0010\u0014\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider$Companion;", "", "<init>", "()V", "TAG_NAMES", "", "getTAG_NAMES", "()Ljava/lang/String;", "TAG_NAME", "getTAG_NAME", "ATTR_NAME", "getATTR_NAME", "ATTR_VALUE", "getATTR_VALUE", "ATTRIBUTE", "getATTRIBUTE", "OPEN_TAG", "getOPEN_TAG", "CLOSE_TAG", "getCLOSE_TAG", "OPEN_CLOSE_REGEXES", "", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "getOPEN_CLOSE_REGEXES", "()Ljava/util/List;", "FIND_START_REGEX", "getFIND_START_REGEX", "()Lkotlin/text/Regex;", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG_NAMES() {
            return TAG_NAMES;
        }

        @NotNull
        public final String getTAG_NAME() {
            return TAG_NAME;
        }

        @NotNull
        public final String getATTR_NAME() {
            return ATTR_NAME;
        }

        @NotNull
        public final String getATTR_VALUE() {
            return ATTR_VALUE;
        }

        @NotNull
        public final String getATTRIBUTE() {
            return ATTRIBUTE;
        }

        @NotNull
        public final String getOPEN_TAG() {
            return OPEN_TAG;
        }

        @NotNull
        public final String getCLOSE_TAG() {
            return CLOSE_TAG;
        }

        @NotNull
        public final List<Pair<Regex, Regex>> getOPEN_CLOSE_REGEXES() {
            return OPEN_CLOSE_REGEXES;
        }

        @NotNull
        public final Regex getFIND_START_REGEX() {
            return FIND_START_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

