/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.LinkReferenceDefinitionMarkerBlock;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "<init>", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "Companion", "jb-md"})
public final class LinkReferenceDefinitionProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> list = Companion.matchLinkDefinition(pos.getOriginalText(), pos.getOffset());
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List<IntRange> matchResult = list;
        Iterator iterator = ((Iterable)matchResult).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            IntRange range = (IntRange)iterator.next();
            IntRange intRange = Companion.addToRangeAndWiden(range, 0);
            productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(intRange, switch (i) {
                case 0 -> MarkdownElementTypes.LINK_LABEL;
                case 1 -> MarkdownElementTypes.LINK_DESTINATION;
                case 2 -> MarkdownElementTypes.LINK_TITLE;
                default -> throw new AssertionError((Object)"There are no more than three groups in this regex");
            })));
        }
        int matchLength = ((IntRange)CollectionsKt.last(matchResult)).getLast() - pos.getOffset() + 1;
        LookaheadText.Position endPosition = pos.nextPosition(matchLength);
        if (endPosition != null && !Companion.isEndOfLine(endPosition)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new LinkReferenceDefinitionMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark(), pos.getOffset() + matchLength));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return false;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fR\u00020\rJ\u001e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\bJ\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\bJ\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\bJ\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/LinkReferenceDefinitionProvider$Companion;", "", "<init>", "()V", "addToRangeAndWiden", "Lkotlin/ranges/IntRange;", "range", "t", "", "isEndOfLine", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "matchLinkDefinition", "", "text", "", "startOffset", "matchLinkDestination", "start", "matchLinkTitle", "matchLinkLabel", "passOneNewline", "isSpace", "c", "", "isSpaceOrNewline", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntRange addToRangeAndWiden(@NotNull IntRange range, int t) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new IntRange(range.getFirst() + t, range.getLast() + t + 1);
        }

        public final boolean isEndOfLine(@NotNull LookaheadText.Position pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return pos.getOffsetInCurrentLine() == -1 || pos.charsToNonWhitespace() == null;
        }

        @Nullable
        public final List<IntRange> matchLinkDefinition(@NotNull CharSequence text, int startOffset) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int offset = MarkerBlockProvider.Companion.passSmallIndent(text, startOffset);
            IntRange intRange = this.matchLinkLabel(text, offset);
            if (intRange == null) {
                return null;
            }
            IntRange linkLabel = intRange;
            offset = linkLabel.getLast() + 1;
            if (offset >= text.length() || text.charAt(offset) != ':') {
                return null;
            }
            ++offset;
            offset = this.passOneNewline(text, offset);
            IntRange intRange2 = this.matchLinkDestination(text, offset);
            if (intRange2 == null) {
                return null;
            }
            IntRange destination = intRange2;
            offset = destination.getLast() + 1;
            offset = this.passOneNewline(text, offset);
            IntRange title = this.matchLinkTitle(text, offset);
            ArrayList<IntRange> result = new ArrayList<IntRange>();
            result.add(linkLabel);
            result.add(destination);
            if (title != null) {
                for (offset = title.getLast() + 1; offset < text.length() && this.isSpace(text.charAt(offset)); ++offset) {
                }
                if (offset >= text.length() || text.charAt(offset) == '\n') {
                    result.add(title);
                }
            }
            return result;
        }

        @Nullable
        public final IntRange matchLinkDestination(@NotNull CharSequence text, int start) {
            char c;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (start >= text.length()) {
                return null;
            }
            int offset = start;
            if (text.charAt(offset) == '<') {
                ++offset;
                while (offset < text.length()) {
                    char c2 = text.charAt(offset);
                    if (c2 == '>') {
                        return new IntRange(start, offset);
                    }
                    if (c2 == '<' || c2 == '>' || this.isSpaceOrNewline(c2)) {
                        return null;
                    }
                    if (c2 == '\\' && offset + 1 < text.length() && !this.isSpaceOrNewline(text.charAt(offset + 1))) {
                        ++offset;
                    }
                    ++offset;
                }
                return null;
            }
            boolean hasParens = false;
            while (offset < text.length() && !this.isSpaceOrNewline(c = text.charAt(offset)) && c > '\u001b') {
                if (c == '(') {
                    if (hasParens) break;
                    hasParens = true;
                } else if (c == ')') {
                    if (!hasParens) break;
                    hasParens = false;
                } else if (c == '\\' && offset + 1 < text.length() && !this.isSpaceOrNewline(text.charAt(offset + 1))) {
                    ++offset;
                }
                ++offset;
            }
            if (start == offset) {
                return null;
            }
            return new IntRange(start, offset - 1);
        }

        @Nullable
        public final IntRange matchLinkTitle(@NotNull CharSequence text, int start) {
            char c;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (start >= text.length()) {
                return null;
            }
            switch (text.charAt(start)) {
                case '\'': {
                    c = '\'';
                    break;
                }
                case '\"': {
                    c = '\"';
                    break;
                }
                case '(': {
                    c = ')';
                    break;
                }
                default: {
                    return null;
                }
            }
            char endDelim = c;
            boolean isBlank = false;
            for (int offset = start + 1; offset < text.length(); ++offset) {
                char c2 = text.charAt(offset);
                if (c2 == endDelim) {
                    return new IntRange(start, offset);
                }
                if (c2 == '\n') {
                    if (isBlank) {
                        return null;
                    }
                    isBlank = true;
                } else if (!this.isSpace(c2)) {
                    isBlank = false;
                }
                if (c2 != '\\' || offset + 1 >= text.length() || this.isSpaceOrNewline(text.charAt(offset + 1))) continue;
                ++offset;
            }
            return null;
        }

        @Nullable
        public final IntRange matchLinkLabel(@NotNull CharSequence text, int start) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int offset = start;
            if (offset >= text.length() || text.charAt(offset) != '[') {
                return null;
            }
            ++offset;
            boolean seenNonWhitespace = false;
            block3: for (int i = 1; i < 1000; ++i) {
                if (offset >= text.length()) {
                    return null;
                }
                char c = text.charAt(offset);
                switch (c) {
                    case '[': 
                    case ']': {
                        break block3;
                    }
                    default: {
                        if (c == '\\') {
                            if (++offset >= text.length()) {
                                return null;
                            }
                            c = text.charAt(offset);
                        }
                        if (!CharsKt.isWhitespace((char)c)) {
                            seenNonWhitespace = true;
                        }
                        ++offset;
                        continue block3;
                    }
                }
            }
            if (!seenNonWhitespace || offset >= text.length() || text.charAt(offset) != ']') {
                return null;
            }
            return new IntRange(start, offset);
        }

        private final int passOneNewline(CharSequence text, int start) {
            int offset;
            for (offset = start; offset < text.length() && this.isSpace(text.charAt(offset)); ++offset) {
            }
            if (offset < text.length() && text.charAt(offset) == '\n') {
                ++offset;
                while (offset < text.length() && this.isSpace(text.charAt(offset))) {
                    ++offset;
                }
            }
            return offset;
        }

        private final boolean isSpace(char c) {
            return c == ' ' || c == '\t';
        }

        private final boolean isSpaceOrNewline(char c) {
            return this.isSpace(c) || c == '\n';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

