/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.lexer.TokenInfo;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/LexerBasedTokensCache;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "lexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "<init>", "(Lorg/intellij/markdown/lexer/MarkdownLexer;)V", "cachedTokens", "", "Lorg/intellij/markdown/lexer/TokenInfo;", "getCachedTokens", "()Ljava/util/List;", "filteredTokens", "getFilteredTokens", "originalText", "", "getOriginalText", "()Ljava/lang/CharSequence;", "originalTextRange", "Lkotlin/ranges/IntRange;", "getOriginalTextRange", "()Lkotlin/ranges/IntRange;", "Companion", "jb-md"})
public final class LexerBasedTokensCache
extends TokensCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TokenInfo> cachedTokens;
    @NotNull
    private final List<TokenInfo> filteredTokens;
    @NotNull
    private final CharSequence originalText;
    @NotNull
    private final IntRange originalTextRange;

    public LexerBasedTokensCache(@NotNull MarkdownLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        Companion.ResultOfCaching resultOfCaching = LexerBasedTokensCache.Companion.cacheTokens(lexer);
        List<TokenInfo> _cachedTokens = resultOfCaching.component1();
        List<TokenInfo> _filteredTokens = resultOfCaching.component2();
        this.cachedTokens = _cachedTokens;
        this.filteredTokens = _filteredTokens;
        this.originalText = lexer.getOriginalText();
        this.originalTextRange = RangesKt.until((int)lexer.getBufferStart(), (int)lexer.getBufferEnd());
        this.verify();
    }

    @Override
    @NotNull
    public List<TokenInfo> getCachedTokens() {
        return this.cachedTokens;
    }

    @Override
    @NotNull
    public List<TokenInfo> getFilteredTokens() {
        return this.filteredTokens;
    }

    @Override
    @NotNull
    public CharSequence getOriginalText() {
        return this.originalText;
    }

    @Override
    @NotNull
    public IntRange getOriginalTextRange() {
        return this.originalTextRange;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/LexerBasedTokensCache$Companion;", "", "<init>", "()V", "isWhitespace", "", "elementType", "Lcom/intellij/psi/tree/IElementType;", "cacheTokens", "Lorg/intellij/markdown/parser/sequentialparsers/LexerBasedTokensCache$Companion$ResultOfCaching;", "lexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "ResultOfCaching", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isWhitespace(IElementType elementType) {
            return Intrinsics.areEqual((Object)elementType, (Object)MarkdownTokenTypes.WHITE_SPACE);
        }

        private final ResultOfCaching cacheTokens(MarkdownLexer lexer) {
            ArrayList<TokenInfo> cachedTokens = new ArrayList<TokenInfo>();
            ArrayList<TokenInfo> filteredTokens = new ArrayList<TokenInfo>();
            while (lexer.getType() != null) {
                boolean isWhitespace = this.isWhitespace(lexer.getType());
                TokenInfo info = new TokenInfo(lexer.getType(), lexer.getTokenStart(), lexer.getTokenEnd(), cachedTokens.size(), isWhitespace ? -1 : filteredTokens.size());
                cachedTokens.add(info);
                if (!isWhitespace) {
                    filteredTokens.add(info);
                }
                lexer.advance();
            }
            return new ResultOfCaching((List<TokenInfo>)cachedTokens, (List<TokenInfo>)filteredTokens);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/LexerBasedTokensCache$Companion$ResultOfCaching;", "", "cachedTokens", "", "Lorg/intellij/markdown/lexer/TokenInfo;", "filteredTokens", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getCachedTokens", "()Ljava/util/List;", "getFilteredTokens", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jb-md"})
        public static final class ResultOfCaching {
            @NotNull
            private final List<TokenInfo> cachedTokens;
            @NotNull
            private final List<TokenInfo> filteredTokens;

            public ResultOfCaching(@NotNull List<TokenInfo> cachedTokens, @NotNull List<TokenInfo> filteredTokens) {
                Intrinsics.checkNotNullParameter(cachedTokens, (String)"cachedTokens");
                Intrinsics.checkNotNullParameter(filteredTokens, (String)"filteredTokens");
                this.cachedTokens = cachedTokens;
                this.filteredTokens = filteredTokens;
            }

            @NotNull
            public final List<TokenInfo> getCachedTokens() {
                return this.cachedTokens;
            }

            @NotNull
            public final List<TokenInfo> getFilteredTokens() {
                return this.filteredTokens;
            }

            @NotNull
            public final List<TokenInfo> component1() {
                return this.cachedTokens;
            }

            @NotNull
            public final List<TokenInfo> component2() {
                return this.filteredTokens;
            }

            @NotNull
            public final ResultOfCaching copy(@NotNull List<TokenInfo> cachedTokens, @NotNull List<TokenInfo> filteredTokens) {
                Intrinsics.checkNotNullParameter(cachedTokens, (String)"cachedTokens");
                Intrinsics.checkNotNullParameter(filteredTokens, (String)"filteredTokens");
                return new ResultOfCaching(cachedTokens, filteredTokens);
            }

            public static /* synthetic */ ResultOfCaching copy$default(ResultOfCaching resultOfCaching, List list, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    list = resultOfCaching.cachedTokens;
                }
                if ((n & 2) != 0) {
                    list2 = resultOfCaching.filteredTokens;
                }
                return resultOfCaching.copy(list, list2);
            }

            @NotNull
            public String toString() {
                return "ResultOfCaching(cachedTokens=" + this.cachedTokens + ", filteredTokens=" + this.filteredTokens + ")";
            }

            public int hashCode() {
                int result = ((Object)this.cachedTokens).hashCode();
                result = result * 31 + ((Object)this.filteredTokens).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ResultOfCaching)) {
                    return false;
                }
                ResultOfCaching resultOfCaching = (ResultOfCaching)other;
                if (!Intrinsics.areEqual(this.cachedTokens, resultOfCaching.cachedTokens)) {
                    return false;
                }
                return Intrinsics.areEqual(this.filteredTokens, resultOfCaching.filteredTokens);
            }
        }
    }
}

