/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.ast;

import com.intellij.psi.tree.IElementType;
import kala.collection.Seq;
import kala.collection.mutable.MutableList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.ExperimentalApi;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.parser.CancellationToken;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/intellij/markdown/ast/ASTNodeBuilder;", "", "text", "", "cancellationToken", "Lorg/intellij/markdown/parser/CancellationToken;", "<init>", "(Ljava/lang/CharSequence;Lorg/intellij/markdown/parser/CancellationToken;)V", "(Ljava/lang/CharSequence;)V", "getText", "()Ljava/lang/CharSequence;", "getCancellationToken", "()Lorg/intellij/markdown/parser/CancellationToken;", "createLeafNodes", "Lkala/collection/Seq;", "Lorg/intellij/markdown/ast/ASTNode;", "type", "Lcom/intellij/psi/tree/IElementType;", "startOffset", "", "endOffset", "createCompositeNode", "Lorg/intellij/markdown/ast/CompositeASTNode;", "children", "Companion", "jb-md"})
public class ASTNodeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence text;
    @NotNull
    private final CancellationToken cancellationToken;

    @ExperimentalApi
    public ASTNodeBuilder(@NotNull CharSequence text, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        this.text = text;
        this.cancellationToken = cancellationToken;
    }

    @NotNull
    protected final CharSequence getText() {
        return this.text;
    }

    @NotNull
    protected final CancellationToken getCancellationToken() {
        return this.cancellationToken;
    }

    public ASTNodeBuilder(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(text, CancellationToken.NonCancellable.INSTANCE);
    }

    @NotNull
    public Seq<ASTNode> createLeafNodes(@NotNull IElementType type, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.WHITE_SPACE)) {
            MutableList mutableList = MutableList.create();
            Intrinsics.checkNotNullExpressionValue((Object)mutableList, (String)"create(...)");
            MutableList result = mutableList;
            int lastEol = startOffset;
            while (lastEol < endOffset) {
                this.cancellationToken.checkCancelled();
                int nextEol = Companion.indexOfSubSeq(this.text, lastEol, endOffset, '\n');
                if (nextEol == -1) break;
                if (nextEol > lastEol) {
                    result.append((Object)new LeafASTNode(MarkdownTokenTypes.WHITE_SPACE, lastEol, nextEol));
                }
                result.append((Object)new LeafASTNode(MarkdownTokenTypes.EOL, nextEol, nextEol + 1));
                lastEol = nextEol + 1;
            }
            if (endOffset > lastEol) {
                result.append((Object)new LeafASTNode(MarkdownTokenTypes.WHITE_SPACE, lastEol, endOffset));
            }
            return (Seq)result;
        }
        Seq seq = Seq.of((Object)new LeafASTNode(type, startOffset, endOffset));
        Intrinsics.checkNotNullExpressionValue((Object)seq, (String)"of(...)");
        return seq;
    }

    @NotNull
    public CompositeASTNode createCompositeNode(@NotNull IElementType type, @NotNull Seq<ASTNode> children) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.cancellationToken.checkCancelled();
        IElementType iElementType = type;
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.UNORDERED_LIST) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.ORDERED_LIST)) {
            return new ListCompositeNode(type, children);
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LIST_ITEM)) {
            return new ListItemCompositeNode(children);
        }
        return new CompositeASTNode(type, children);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/intellij/markdown/ast/ASTNodeBuilder$Companion;", "", "<init>", "()V", "indexOfSubSeq", "", "s", "", "from", "to", "c", "", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        public final int indexOfSubSeq(@NotNull CharSequence s, int from, int to, char c) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            int i = from;
            int n = to - 1;
            if (i <= n) {
                while (true) {
                    if (s.charAt(i) == c) {
                        return i;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

