/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.List;
import kala.text.StringSlice;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0018\u00010\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/intellij/markdown/parser/LookaheadText;", "", "text", "", "<init>", "(Ljava/lang/CharSequence;)V", "lines", "", "", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "getStartPosition", "()Lorg/intellij/markdown/parser/LookaheadText$Position;", "Position", "jb-md"})
public final class LookaheadText {
    @NotNull
    private final CharSequence text;
    @NotNull
    private final List<String> lines;
    @Nullable
    private final Position startPosition;

    public LookaheadText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        char[] cArray = new char[]{'\n'};
        this.lines = StringsKt.split$default((CharSequence)this.text, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        this.startPosition = this.text.length() > 0 ? Position.nextPosition$default(new Position(0, -1, -1), 0, 1, null) : null;
    }

    @Nullable
    public final Position getStartPosition() {
        return this.startPosition;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0016\u0010)\u001a\b\u0018\u00010\u0000R\u00020*2\b\b\u0002\u0010+\u001a\u00020\u0003J\f\u0010,\u001a\b\u0018\u00010\u0000R\u00020*J\r\u0010-\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00101\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0013R\u0011\u0010\u001b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000bR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000fR\u0013\u0010#\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000fR\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00062"}, d2={"Lorg/intellij/markdown/parser/LookaheadText$Position;", "", "lineN", "", "localPos", "globalPos", "<init>", "(Lorg/intellij/markdown/parser/LookaheadText;III)V", "originalText", "", "getOriginalText", "()Ljava/lang/CharSequence;", "currentLine", "", "getCurrentLine", "()Ljava/lang/String;", "toString", "offset", "getOffset", "()I", "offsetInCurrentLine", "getOffsetInCurrentLine", "nextLineOffset", "getNextLineOffset", "()Ljava/lang/Integer;", "nextLineOrEofOffset", "getNextLineOrEofOffset", "textFromPosition", "getTextFromPosition", "currentLineFromPosition", "Lkala/text/StringSlice;", "getCurrentLineFromPosition", "()Lkala/text/StringSlice;", "nextLine", "getNextLine", "prevLine", "getPrevLine", "char", "", "getChar", "()C", "nextPosition", "Lorg/intellij/markdown/parser/LookaheadText;", "delta", "nextLinePosition", "charsToNonWhitespace", "equals", "", "other", "hashCode", "jb-md"})
    @SourceDebugExtension(value={"SMAP\nLookaheadText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookaheadText.kt\norg/intellij/markdown/parser/LookaheadText$Position\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,141:1\n107#2,3:142\n111#2:146\n107#3:145\n*S KotlinDebug\n*F\n+ 1 LookaheadText.kt\norg/intellij/markdown/parser/LookaheadText$Position\n*L\n27#1:142,3\n27#1:146\n27#1:145\n*E\n"})
    public final class Position {
        private final int lineN;
        private final int localPos;
        private final int globalPos;
        @NotNull
        private final String currentLine;

        public Position(int lineN, int localPos, int globalPos) {
            this.lineN = lineN;
            this.localPos = localPos;
            this.globalPos = globalPos;
            this.currentLine = (String)LookaheadText.this.lines.get(this.lineN);
            Compat compat = Compat.INSTANCE;
            boolean condition$iv = this.localPos >= -1 && this.localPos < this.currentLine.length();
            boolean $i$f$assert = false;
            if (!condition$iv) {
                boolean bl = false;
                String string = "";
                throw new MarkdownParsingException(string);
            }
        }

        @NotNull
        public final CharSequence getOriginalText() {
            return LookaheadText.this.text;
        }

        @NotNull
        public final String getCurrentLine() {
            return this.currentLine;
        }

        @NotNull
        public String toString() {
            Object object;
            if (this.localPos == -1) {
                object = "\\n" + this.currentLine;
            } else {
                String string = this.currentLine.substring(this.localPos);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            }
            return "Position: '" + (String)object + "'";
        }

        public final int getOffset() {
            return this.globalPos;
        }

        public final int getOffsetInCurrentLine() {
            return this.localPos;
        }

        @Nullable
        public final Integer getNextLineOffset() {
            return this.lineN + 1 < LookaheadText.this.lines.size() ? Integer.valueOf(this.globalPos + (this.currentLine.length() - this.localPos)) : null;
        }

        public final int getNextLineOrEofOffset() {
            return this.globalPos + (this.currentLine.length() - this.localPos);
        }

        @NotNull
        public final CharSequence getTextFromPosition() {
            return LookaheadText.this.text.subSequence(this.globalPos, LookaheadText.this.text.length());
        }

        @NotNull
        public final StringSlice getCurrentLineFromPosition() {
            StringSlice stringSlice = StringSlice.of((String)this.currentLine, (int)this.getOffsetInCurrentLine(), (int)this.currentLine.length());
            Intrinsics.checkNotNullExpressionValue((Object)stringSlice, (String)"of(...)");
            return stringSlice;
        }

        @Nullable
        public final String getNextLine() {
            return this.lineN + 1 < LookaheadText.this.lines.size() ? (String)LookaheadText.this.lines.get(this.lineN + 1) : null;
        }

        @Nullable
        public final String getPrevLine() {
            return this.lineN > 0 ? (String)LookaheadText.this.lines.get(this.lineN - 1) : null;
        }

        public final char getChar() {
            return LookaheadText.this.text.charAt(this.globalPos);
        }

        @Nullable
        public final Position nextPosition(int delta) {
            int remaining = delta;
            Position currentPosition = this;
            while (remaining != 0) {
                if (currentPosition.localPos + remaining < currentPosition.currentLine.length()) {
                    return new Position(currentPosition.lineN, currentPosition.localPos + remaining, currentPosition.globalPos + remaining);
                }
                Integer nextLine = currentPosition.getNextLineOffset();
                if (nextLine == null) {
                    return null;
                }
                int payload = currentPosition.currentLine.length() - currentPosition.localPos;
                currentPosition = new Position(currentPosition.lineN + 1, -1, currentPosition.globalPos + payload);
                remaining -= payload;
            }
            return currentPosition;
        }

        public static /* synthetic */ Position nextPosition$default(Position position, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return position.nextPosition(n);
        }

        @Nullable
        public final Position nextLinePosition() {
            Integer n = this.getNextLineOffset();
            if (n == null) {
                return null;
            }
            int nextLine = n;
            return this.nextPosition(nextLine - this.getOffset());
        }

        @Nullable
        public final Integer charsToNonWhitespace() {
            String line = this.currentLine;
            for (int offset = Math.max(this.localPos, 0); offset < line.length(); ++offset) {
                char c = line.charAt(offset);
                if (c == ' ' || c == '\t') continue;
                return offset - this.localPos;
            }
            return null;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            Position cfr_ignored_0 = (Position)other;
            return this.globalPos == ((Position)other).globalPos;
        }

        public int hashCode() {
            return this.globalPos;
        }
    }
}

