/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.ListItemMarkerBlock;
import org.intellij.markdown.parser.markerblocks.impl.ListMarkerBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u000f*\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/ListMarkerProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "<init>", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "getLastExplicit", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)Ljava/lang/Boolean;", "jb-md"})
public final class ListMarkerProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        MarkdownConstraints currentConstraints = stateInfo.getCurrentConstraints();
        MarkdownConstraints nextConstraints = stateInfo.getNextConstraints();
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, currentConstraints)) {
            return CollectionsKt.emptyList();
        }
        if (!Intrinsics.areEqual((Object)nextConstraints, (Object)currentConstraints)) {
            Character c = ArraysKt.lastOrNull((char[])nextConstraints.getTypes());
            char c2 = '>';
            if ((c == null || c.charValue() != c2) && Intrinsics.areEqual((Object)this.getLastExplicit(nextConstraints), (Object)true)) {
                ArrayList<MarkerBlockImpl> result = new ArrayList<MarkerBlockImpl>();
                if (!(stateInfo.getLastBlock() instanceof ListMarkerBlock)) {
                    ProductionHolder.Marker marker = productionHolder.mark();
                    Character c3 = ArraysKt.lastOrNull((char[])nextConstraints.getTypes());
                    Intrinsics.checkNotNull((Object)c3);
                    result.add(new ListMarkerBlock(nextConstraints, marker, c3.charValue()));
                }
                result.add(new ListItemMarkerBlock(nextConstraints, productionHolder.mark()));
                return result;
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return false;
    }

    private final Boolean getLastExplicit(MarkdownConstraints $this$getLastExplicit) {
        return ArraysKt.lastOrNull((boolean[])$this$getLastExplicit.isExplicit());
    }
}

