/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\t\n\u000bJ\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "Node", "ParsingResult", "ParsingResultBuilder", "jb-md"})
public interface SequentialParser {
    @NotNull
    public ParsingResult parse(@NotNull TokensCache var1, @NotNull List<IntRange> var2);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "", "range", "Lkotlin/ranges/IntRange;", "type", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lkotlin/ranges/IntRange;Lcom/intellij/psi/tree/IElementType;)V", "getRange", "()Lkotlin/ranges/IntRange;", "getType", "()Lcom/intellij/psi/tree/IElementType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jb-md"})
    public static final class Node {
        @NotNull
        private final IntRange range;
        @NotNull
        private final IElementType type;

        public Node(@NotNull IntRange range, @NotNull IElementType type) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.range = range;
            this.type = type;
        }

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        @NotNull
        public final IElementType getType() {
            return this.type;
        }

        @NotNull
        public final IntRange component1() {
            return this.range;
        }

        @NotNull
        public final IElementType component2() {
            return this.type;
        }

        @NotNull
        public final Node copy(@NotNull IntRange range, @NotNull IElementType type) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Node(range, type);
        }

        public static /* synthetic */ Node copy$default(Node node, IntRange intRange, IElementType iElementType, int n, Object object) {
            if ((n & 1) != 0) {
                intRange = node.range;
            }
            if ((n & 2) != 0) {
                iElementType = node.type;
            }
            return node.copy(intRange, iElementType);
        }

        @NotNull
        public String toString() {
            return "Node(range=" + this.range + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.range.hashCode();
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node node = (Node)other;
            if (!Intrinsics.areEqual((Object)this.range, (Object)node.range)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)node.type);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "", "parsedNodes", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "getParsedNodes", "()Ljava/util/Collection;", "rangesToProcessFurther", "", "Lkotlin/ranges/IntRange;", "getRangesToProcessFurther", "jb-md"})
    public static interface ParsingResult {
        @NotNull
        public Collection<Node> getParsedNodes();

        @NotNull
        public Collection<List<IntRange>> getRangesToProcessFurther();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u0014\u0010\u0012\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u0014\u0010\u0013\u001a\u00020\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0001R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResultBuilder;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "<init>", "()V", "_parsedNodes", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "parsedNodes", "", "getParsedNodes", "()Ljava/util/Collection;", "_rangesToProcessFurther", "", "Lkotlin/ranges/IntRange;", "rangesToProcessFurther", "getRangesToProcessFurther", "withNode", "result", "withNodes", "withFurtherProcessing", "ranges", "withOtherParsingResult", "parsingResult", "jb-md"})
    public static final class ParsingResultBuilder
    implements ParsingResult {
        @NotNull
        private final Collection<Node> _parsedNodes = new ArrayList();
        @NotNull
        private final Collection<List<IntRange>> _rangesToProcessFurther = new ArrayList();

        @Override
        @NotNull
        public Collection<Node> getParsedNodes() {
            return this._parsedNodes;
        }

        @Override
        @NotNull
        public Collection<List<IntRange>> getRangesToProcessFurther() {
            return this._rangesToProcessFurther;
        }

        @NotNull
        public final ParsingResultBuilder withNode(@NotNull Node result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this._parsedNodes.add(result);
            return this;
        }

        @NotNull
        public final ParsingResultBuilder withNodes(@NotNull Collection<Node> parsedNodes) {
            Intrinsics.checkNotNullParameter(parsedNodes, (String)"parsedNodes");
            this._parsedNodes.addAll(parsedNodes);
            return this;
        }

        @NotNull
        public final ParsingResultBuilder withFurtherProcessing(@NotNull List<IntRange> ranges) {
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            this._rangesToProcessFurther.add(ranges);
            return this;
        }

        @NotNull
        public final ParsingResultBuilder withOtherParsingResult(@NotNull ParsingResult parsingResult) {
            Intrinsics.checkNotNullParameter((Object)parsingResult, (String)"parsingResult");
            this._parsedNodes.addAll(parsingResult.getParsedNodes());
            this._rangesToProcessFurther.addAll(parsingResult.getRangesToProcessFurther());
            return this;
        }
    }
}

