/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.lexer.TokenInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0004R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "", "<init>", "()V", "cachedTokens", "", "Lorg/intellij/markdown/lexer/TokenInfo;", "getCachedTokens", "()Ljava/util/List;", "filteredTokens", "getFilteredTokens", "originalText", "", "getOriginalText", "()Ljava/lang/CharSequence;", "originalTextRange", "Lkotlin/ranges/IntRange;", "getOriginalTextRange", "()Lkotlin/ranges/IntRange;", "getRawCharAt", "", "index", "", "verify", "", "RangesListIterator", "Iterator", "jb-md"})
@SourceDebugExtension(value={"SMAP\nTokensCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokensCache.kt\norg/intellij/markdown/parser/sequentialparsers/TokensCache\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,148:1\n107#2,3:149\n111#2:153\n107#2,3:154\n111#2:158\n107#3:152\n107#3:157\n*S KotlinDebug\n*F\n+ 1 TokensCache.kt\norg/intellij/markdown/parser/sequentialparsers/TokensCache\n*L\n21#1:149,3\n21#1:153\n24#1:154,3\n24#1:158\n21#1:152\n24#1:157\n*E\n"})
public abstract class TokensCache {
    @NotNull
    public abstract List<TokenInfo> getCachedTokens();

    @NotNull
    public abstract List<TokenInfo> getFilteredTokens();

    @NotNull
    public abstract CharSequence getOriginalText();

    @NotNull
    public abstract IntRange getOriginalTextRange();

    public final char getRawCharAt(int index) {
        if (index < this.getOriginalTextRange().getFirst()) {
            return '\u0000';
        }
        if (index > this.getOriginalTextRange().getLast()) {
            return '\u0000';
        }
        return this.getOriginalText().charAt(index);
    }

    protected final void verify() {
        boolean $i$f$assert;
        boolean condition$iv;
        int i;
        int n = ((Collection)this.getCachedTokens()).size();
        for (i = 0; i < n; ++i) {
            Compat compat = Compat.INSTANCE;
            condition$iv = this.getCachedTokens().get(i).getRawIndex() == i;
            $i$f$assert = false;
            if (condition$iv) continue;
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        n = ((Collection)this.getFilteredTokens()).size();
        for (i = 0; i < n; ++i) {
            Compat $this$iv = Compat.INSTANCE;
            condition$iv = this.getFilteredTokens().get(i).getNormIndex() == i;
            $i$f$assert = false;
            if (condition$iv) continue;
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0016\u001a\u00060\u0000R\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00060\u0000R\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u000e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "", "index", "", "<init>", "(Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;I)V", "getIndex", "()I", "type", "Lcom/intellij/psi/tree/IElementType;", "getType", "()Lcom/intellij/psi/tree/IElementType;", "firstChar", "", "getFirstChar", "()C", "length", "getLength", "start", "getStart", "end", "getEnd", "advance", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rollback", "info", "Lorg/intellij/markdown/lexer/TokenInfo;", "rawSteps", "rawLookup", "steps", "rawStart", "charLookup", "toString", "", "jb-md"})
    public class Iterator {
        private final int index;

        public Iterator(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        @Nullable
        public final IElementType getType() {
            return this.info(0).getType();
        }

        public final char getFirstChar() {
            return TokensCache.this.getRawCharAt(this.info(0).getTokenStart());
        }

        public final int getLength() {
            return this.info(0).getTokenEnd() - this.info(0).getTokenStart();
        }

        public final int getStart() {
            return this.info(0).getTokenStart();
        }

        public final int getEnd() {
            return this.info(0).getTokenEnd();
        }

        @NotNull
        public Iterator advance() {
            return new Iterator(this.index + 1);
        }

        @NotNull
        public Iterator rollback() {
            return new Iterator(this.index - 1);
        }

        private final TokenInfo info(int rawSteps) {
            int rawIndex;
            if (this.index < 0) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getFirst(), TokensCache.this.getOriginalTextRange().getFirst(), 0, 0);
            }
            if (this.index > TokensCache.this.getFilteredTokens().size()) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getLast() + 1, TokensCache.this.getOriginalTextRange().getLast() + 1, 0, 0);
            }
            int n = rawIndex = this.index < TokensCache.this.getFilteredTokens().size() ? TokensCache.this.getFilteredTokens().get(this.index).getRawIndex() + rawSteps : TokensCache.this.getCachedTokens().size() + rawSteps;
            if (rawIndex < 0) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getFirst(), TokensCache.this.getOriginalTextRange().getFirst(), 0, 0);
            }
            if (rawIndex >= TokensCache.this.getCachedTokens().size()) {
                return new TokenInfo(null, TokensCache.this.getOriginalTextRange().getLast() + 1, TokensCache.this.getOriginalTextRange().getLast() + 1, 0, 0);
            }
            return TokensCache.this.getCachedTokens().get(rawIndex);
        }

        @Nullable
        public IElementType rawLookup(int steps) {
            return this.info(steps).getType();
        }

        public final int rawStart(int steps) {
            return this.info(steps).getTokenStart();
        }

        public char charLookup(int steps) {
            if (steps == 0) {
                return TokensCache.this.getRawCharAt(this.getStart());
            }
            switch (steps) {
                case 1: {
                    return TokensCache.this.getRawCharAt(this.getEnd());
                }
                case -1: {
                    return TokensCache.this.getRawCharAt(this.getStart() - 1);
                }
            }
            int pos = steps > 0 ? this.rawStart(steps) : this.rawStart(steps + 1) - 1;
            return TokensCache.this.getRawCharAt(pos);
        }

        @NotNull
        public String toString() {
            return "Iterator: " + this.index + ": " + this.getType();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B'\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB\u0017\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\t\u0010\u000bJ\f\u0010\f\u001a\u00060\u0000R\u00020\u0002H\u0016J\f\u0010\r\u001a\u00060\u0000R\u00020\u0002H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$RangesListIterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "ranges", "", "Lkotlin/ranges/IntRange;", "listIndex", "", "value", "<init>", "(Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;Ljava/util/List;II)V", "(Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;Ljava/util/List;)V", "advance", "rollback", "rawLookup", "Lcom/intellij/psi/tree/IElementType;", "steps", "jb-md"})
    public final class RangesListIterator
    extends Iterator {
        @NotNull
        private final List<IntRange> ranges;
        private final int listIndex;
        final /* synthetic */ TokensCache this$0;

        private RangesListIterator(TokensCache this$0, List<IntRange> ranges, int listIndex, int value) {
            this.this$0 = this$0;
            super(value);
            this.ranges = ranges;
            this.listIndex = listIndex;
        }

        public RangesListIterator(@NotNull TokensCache this$0, List<IntRange> ranges) {
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            IntRange intRange = (IntRange)CollectionsKt.firstOrNull(ranges);
            this(this$0, ranges, 0, intRange != null ? intRange.getStart() : -1);
        }

        @Override
        @NotNull
        public RangesListIterator advance() {
            if (this.listIndex >= this.ranges.size()) {
                return this;
            }
            if (this.getIndex() == this.ranges.get(this.listIndex).getLast()) {
                IntRange intRange = (IntRange)CollectionsKt.getOrNull(this.ranges, (int)(this.listIndex + 1));
                return new RangesListIterator(this.this$0, this.ranges, this.listIndex + 1, intRange != null ? intRange.getStart().intValue() : this.this$0.getFilteredTokens().size());
            }
            return new RangesListIterator(this.this$0, this.ranges, this.listIndex, this.getIndex() + 1);
        }

        @Override
        @NotNull
        public RangesListIterator rollback() {
            if (this.listIndex < 0) {
                return this;
            }
            if (this.getIndex() == this.ranges.get(this.listIndex).getFirst()) {
                IntRange intRange = (IntRange)CollectionsKt.getOrNull(this.ranges, (int)(this.listIndex - 1));
                return new RangesListIterator(this.this$0, this.ranges, this.listIndex - 1, intRange != null ? intRange.getEndInclusive() : -1);
            }
            return new RangesListIterator(this.this$0, this.ranges, this.listIndex, this.getIndex() - 1);
        }

        @Override
        @Nullable
        public IElementType rawLookup(int steps) {
            IntRange intRange = (IntRange)CollectionsKt.getOrNull(this.ranges, (int)this.listIndex);
            if (intRange == null) {
                return null;
            }
            IntRange intRange2 = intRange;
            int n = intRange2.getFirst();
            int n2 = intRange2.getLast();
            int n3 = this.getIndex() + steps;
            boolean bl = n <= n3 ? n3 <= n2 : false;
            if (bl) {
                return super.rawLookup(steps);
            }
            return null;
        }
    }
}

