/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\"\u0010\u000b\u001a\b\u0018\u00010\fR\u00020\u00072\n\u0010\r\u001a\u00060\fR\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u001c\u0010\u0010\u001a\u00020\u000f2\n\u0010\u0011\u001a\u00060\fR\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0004\u00a8\u0006\u0014"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/BacktickParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "<init>", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "findOfSize", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "it", "length", "", "getLength", "info", "canEscape", "", "jb-md"})
public class BacktickParser
implements SequentialParser {
    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result = new SequentialParser.ParsingResultBuilder();
        RangesListBuilder delegateIndices = new RangesListBuilder();
        TokensCache.Iterator iterator = new TokensCache.RangesListIterator(tokens, rangesToGlue);
        while (iterator.getType() != null) {
            TokensCache.Iterator endIterator;
            if ((Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.BACKTICK) || Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS)) && (endIterator = this.findOfSize(iterator.advance(), this.getLength(iterator, true))) != null) {
                result.withNode(new SequentialParser.Node(new IntRange(iterator.getIndex(), endIterator.getIndex() + 1), MarkdownElementTypes.CODE_SPAN));
                iterator = endIterator.advance();
                continue;
            }
            delegateIndices.put(iterator.getIndex());
            iterator = iterator.advance();
        }
        return result.withFurtherProcessing(delegateIndices.get());
    }

    @Nullable
    protected final TokensCache.Iterator findOfSize(@NotNull TokensCache.Iterator it, int length) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TokensCache.Iterator iterator = it;
        while (iterator.getType() != null) {
            if ((Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.BACKTICK) || Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS)) && this.getLength(iterator, false) == length) {
                return iterator;
            }
            iterator = iterator.advance();
        }
        return null;
    }

    protected final int getLength(@NotNull TokensCache.Iterator info, boolean canEscape) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        int toSubtract = 0;
        if (Intrinsics.areEqual((Object)info.getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS)) {
            toSubtract = canEscape ? 2 : 1;
        }
        return info.getLength() - toSubtract;
    }
}

