/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.LinkParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/InlineLinkParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "<init>", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "Companion", "jb-md"})
public final class InlineLinkParser
implements SequentialParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result = new SequentialParser.ParsingResultBuilder();
        RangesListBuilder delegateIndices = new RangesListBuilder();
        TokensCache.Iterator iterator = new TokensCache.RangesListIterator(tokens, rangesToGlue);
        while (iterator.getType() != null) {
            LocalParsingResult inlineLink;
            if (Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.LBRACKET) && (inlineLink = Companion.parseInlineLink(iterator)) != null) {
                iterator = inlineLink.getIteratorPosition().advance();
                result = result.withOtherParsingResult(inlineLink);
                continue;
            }
            delegateIndices.put(iterator.getIndex());
            iterator = iterator.advance();
        }
        return result.withFurtherProcessing(delegateIndices.get());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a8\u0006\t"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/InlineLinkParser$Companion;", "", "<init>", "()V", "parseInlineLink", "Lorg/intellij/markdown/parser/sequentialparsers/LocalParsingResult;", "iterator", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LocalParsingResult parseInlineLink(@NotNull TokensCache.Iterator iterator) {
            Object object;
            Object object2;
            LocalParsingResult linkTitle;
            LocalParsingResult linkDestination;
            Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
            int startIndex = iterator.getIndex();
            TokensCache.Iterator it = iterator;
            LocalParsingResult localParsingResult = LinkParserUtil.INSTANCE.parseLinkText(it);
            if (localParsingResult == null) {
                return null;
            }
            LocalParsingResult linkText = localParsingResult;
            it = linkText.getIteratorPosition();
            if (!Intrinsics.areEqual((Object)it.rawLookup(1), (Object)MarkdownTokenTypes.LPAREN)) {
                return null;
            }
            if (Intrinsics.areEqual((Object)(it = it.advance().advance()).getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            if ((linkDestination = LinkParserUtil.INSTANCE.parseLinkDestination(it)) != null && Intrinsics.areEqual((Object)(it = linkDestination.getIteratorPosition().advance()).getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            if ((linkTitle = LinkParserUtil.INSTANCE.parseLinkTitle(it)) != null && Intrinsics.areEqual((Object)(it = linkTitle.getIteratorPosition().advance()).getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RPAREN)) {
                return null;
            }
            return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus(linkText.getParsedNodes(), (Iterable)((object2 = linkDestination) != null && (object2 = ((LocalParsingResult)object2).getParsedNodes()) != null ? (Iterable)object2 : (Iterable)CollectionsKt.emptyList())), (Iterable)((object = linkTitle) != null && (object = ((LocalParsingResult)object).getParsedNodes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList())), (Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.INLINE_LINK)), linkText.getRangesToProcessFurther());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

