/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\bJ\u0014\u0010\t\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\bJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\bJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a8\u0006\f"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/LinkParserUtil;", "", "<init>", "()V", "parseLinkDestination", "Lorg/intellij/markdown/parser/sequentialparsers/LocalParsingResult;", "iterator", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "parseLinkLabel", "parseLinkText", "parseLinkTitle", "jb-md"})
public final class LinkParserUtil {
    @NotNull
    public static final LinkParserUtil INSTANCE = new LinkParserUtil();

    private LinkParserUtil() {
    }

    @Nullable
    public final LocalParsingResult parseLinkDestination(@NotNull TokensCache.Iterator iterator) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        TokensCache.Iterator it = iterator;
        if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RPAREN)) {
            return null;
        }
        int startIndex = it.getIndex();
        boolean withBraces = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LT);
        if (withBraces) {
            it = it.advance();
        }
        boolean hasOpenedParentheses = false;
        while (!(it.getType() == null || withBraces && Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.GT))) {
            if (!withBraces) {
                if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LPAREN)) {
                    if (hasOpenedParentheses) break;
                    hasOpenedParentheses = true;
                }
                IElementType next = it.rawLookup(1);
                if (SequentialParserUtil.INSTANCE.isWhitespace(it, 1) || next == null) break;
                if (Intrinsics.areEqual((Object)next, (Object)MarkdownTokenTypes.RPAREN)) {
                    if (!hasOpenedParentheses) break;
                    hasOpenedParentheses = false;
                }
            }
            it = it.advance();
        }
        if (it.getType() != null && !hasOpenedParentheses) {
            return new LocalParsingResult(it, CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.LINK_DESTINATION)));
        }
        return null;
    }

    @Nullable
    public final LocalParsingResult parseLinkLabel(@NotNull TokensCache.Iterator iterator) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        TokensCache.Iterator it = iterator;
        if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) {
            return null;
        }
        int startIndex = it.getIndex();
        RangesListBuilder delegate = new RangesListBuilder();
        it = it.advance();
        while (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET) && it.getType() != null) {
            delegate.put(it.getIndex());
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) break;
            it = it.advance();
        }
        if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET)) {
            int endIndex = it.getIndex();
            if (endIndex == startIndex + 1) {
                return null;
            }
            return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startIndex, endIndex + 1), MarkdownElementTypes.LINK_LABEL)), delegate.get());
        }
        return null;
    }

    @Nullable
    public final LocalParsingResult parseLinkText(@NotNull TokensCache.Iterator iterator) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        TokensCache.Iterator it = iterator;
        if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) {
            return null;
        }
        int startIndex = it.getIndex();
        RangesListBuilder delegate = new RangesListBuilder();
        int bracketDepth = 1;
        it = it.advance();
        while (!(it.getType() == null || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET) && --bracketDepth == 0)) {
            delegate.put(it.getIndex());
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET)) {
                ++bracketDepth;
            }
            it = it.advance();
        }
        if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RBRACKET)) {
            return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.LINK_TEXT)), delegate.get());
        }
        return null;
    }

    @Nullable
    public final LocalParsingResult parseLinkTitle(@NotNull TokensCache.Iterator iterator) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        TokensCache.Iterator it = iterator;
        if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL)) {
            return null;
        }
        int startIndex = it.getIndex();
        IElementType closingType = null;
        if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.SINGLE_QUOTE) || Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.DOUBLE_QUOTE)) {
            closingType = it.getType();
        } else if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LPAREN)) {
            closingType = MarkdownTokenTypes.RPAREN;
        } else {
            return null;
        }
        it = it.advance();
        while (it.getType() != null && !Intrinsics.areEqual((Object)it.getType(), (Object)closingType)) {
            it = it.advance();
        }
        if (it.getType() != null) {
            return new LocalParsingResult(it, CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.LINK_TITLE)));
        }
        return null;
    }
}

