package org.intellij.markdown.ast

import com.intellij.psi.tree.IElementType
import kala.collection.Seq

open class CompositeASTNode(type: IElementType, final override val children: Seq<ASTNode>)
  : ASTNodeImpl(type, children.firstOrNull?.startOffset ?: 0, children.lastOrNull?.endOffset ?: 0) {
  init {
    for (child in children) {
      if (child is ASTNodeImpl) {
        @Suppress("LeakingThis")
        child.parent = this
      }
    }
  }


}
